/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.Backend;
import software.amazon.awssdk.services.amplify.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.amplify.model.Stage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBranchRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, UpdateBranchRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(UpdateBranchRequest.getter(UpdateBranchRequest::appId)).setter(UpdateBranchRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(UpdateBranchRequest.getter(UpdateBranchRequest::branchName)).setter(UpdateBranchRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateBranchRequest.getter(UpdateBranchRequest::description)).setter(UpdateBranchRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("framework").getter(UpdateBranchRequest.getter(UpdateBranchRequest::framework)).setter(UpdateBranchRequest.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stage").getter(UpdateBranchRequest.getter(UpdateBranchRequest::stageAsString)).setter(UpdateBranchRequest.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final SdkField<Boolean> ENABLE_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableNotification").getter(UpdateBranchRequest.getter(UpdateBranchRequest::enableNotification)).setter(UpdateBranchRequest.setter(Builder::enableNotification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableNotification").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableAutoBuild").getter(UpdateBranchRequest.getter(UpdateBranchRequest::enableAutoBuild)).setter(UpdateBranchRequest.setter(Builder::enableAutoBuild)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()}).build();
    private static final SdkField<Boolean> ENABLE_SKEW_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableSkewProtection").getter(UpdateBranchRequest.getter(UpdateBranchRequest::enableSkewProtection)).setter(UpdateBranchRequest.setter(Builder::enableSkewProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSkewProtection").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(UpdateBranchRequest.getter(UpdateBranchRequest::environmentVariables)).setter(UpdateBranchRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("basicAuthCredentials").getter(UpdateBranchRequest.getter(UpdateBranchRequest::basicAuthCredentials)).setter(UpdateBranchRequest.setter(Builder::basicAuthCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build()}).build();
    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableBasicAuth").getter(UpdateBranchRequest.getter(UpdateBranchRequest::enableBasicAuth)).setter(UpdateBranchRequest.setter(Builder::enableBasicAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enablePerformanceMode").getter(UpdateBranchRequest.getter(UpdateBranchRequest::enablePerformanceMode)).setter(UpdateBranchRequest.setter(Builder::enablePerformanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePerformanceMode").build()}).build();
    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildSpec").getter(UpdateBranchRequest.getter(UpdateBranchRequest::buildSpec)).setter(UpdateBranchRequest.setter(Builder::buildSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()}).build();
    private static final SdkField<String> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ttl").getter(UpdateBranchRequest.getter(UpdateBranchRequest::ttl)).setter(UpdateBranchRequest.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateBranchRequest.getter(UpdateBranchRequest::displayName)).setter(UpdateBranchRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enablePullRequestPreview").getter(UpdateBranchRequest.getter(UpdateBranchRequest::enablePullRequestPreview)).setter(UpdateBranchRequest.setter(Builder::enablePullRequestPreview)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build()}).build();
    private static final SdkField<String> PULL_REQUEST_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestEnvironmentName").getter(UpdateBranchRequest.getter(UpdateBranchRequest::pullRequestEnvironmentName)).setter(UpdateBranchRequest.setter(Builder::pullRequestEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEnvironmentName").build()}).build();
    private static final SdkField<String> BACKEND_ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backendEnvironmentArn").getter(UpdateBranchRequest.getter(UpdateBranchRequest::backendEnvironmentArn)).setter(UpdateBranchRequest.setter(Builder::backendEnvironmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentArn").build()}).build();
    private static final SdkField<Backend> BACKEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("backend").getter(UpdateBranchRequest.getter(UpdateBranchRequest::backend)).setter(UpdateBranchRequest.setter(Builder::backend)).constructor(Backend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backend").build()}).build();
    private static final SdkField<String> COMPUTE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeRoleArn").getter(UpdateBranchRequest.getter(UpdateBranchRequest::computeRoleArn)).setter(UpdateBranchRequest.setter(Builder::computeRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BRANCH_NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_FIELD, STAGE_FIELD, ENABLE_NOTIFICATION_FIELD, ENABLE_AUTO_BUILD_FIELD, ENABLE_SKEW_PROTECTION_FIELD, ENVIRONMENT_VARIABLES_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, ENABLE_BASIC_AUTH_FIELD, ENABLE_PERFORMANCE_MODE_FIELD, BUILD_SPEC_FIELD, TTL_FIELD, DISPLAY_NAME_FIELD, ENABLE_PULL_REQUEST_PREVIEW_FIELD, PULL_REQUEST_ENVIRONMENT_NAME_FIELD, BACKEND_ENVIRONMENT_ARN_FIELD, BACKEND_FIELD, COMPUTE_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBranchRequest.memberNameToFieldInitializer();
    private final String appId;
    private final String branchName;
    private final String description;
    private final String framework;
    private final String stage;
    private final Boolean enableNotification;
    private final Boolean enableAutoBuild;
    private final Boolean enableSkewProtection;
    private final Map<String, String> environmentVariables;
    private final String basicAuthCredentials;
    private final Boolean enableBasicAuth;
    private final Boolean enablePerformanceMode;
    private final String buildSpec;
    private final String ttl;
    private final String displayName;
    private final Boolean enablePullRequestPreview;
    private final String pullRequestEnvironmentName;
    private final String backendEnvironmentArn;
    private final Backend backend;
    private final String computeRoleArn;

    private UpdateBranchRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.framework = builder.framework;
        this.stage = builder.stage;
        this.enableNotification = builder.enableNotification;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.enableSkewProtection = builder.enableSkewProtection;
        this.environmentVariables = builder.environmentVariables;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.enablePerformanceMode = builder.enablePerformanceMode;
        this.buildSpec = builder.buildSpec;
        this.ttl = builder.ttl;
        this.displayName = builder.displayName;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
        this.backendEnvironmentArn = builder.backendEnvironmentArn;
        this.backend = builder.backend;
        this.computeRoleArn = builder.computeRoleArn;
    }

    public final String appId() {
        return this.appId;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final String description() {
        return this.description;
    }

    public final String framework() {
        return this.framework;
    }

    public final Stage stage() {
        return Stage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final Boolean enableNotification() {
        return this.enableNotification;
    }

    public final Boolean enableAutoBuild() {
        return this.enableAutoBuild;
    }

    public final Boolean enableSkewProtection() {
        return this.enableSkewProtection;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final String basicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public final Boolean enableBasicAuth() {
        return this.enableBasicAuth;
    }

    public final Boolean enablePerformanceMode() {
        return this.enablePerformanceMode;
    }

    public final String buildSpec() {
        return this.buildSpec;
    }

    public final String ttl() {
        return this.ttl;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Boolean enablePullRequestPreview() {
        return this.enablePullRequestPreview;
    }

    public final String pullRequestEnvironmentName() {
        return this.pullRequestEnvironmentName;
    }

    public final String backendEnvironmentArn() {
        return this.backendEnvironmentArn;
    }

    public final Backend backend() {
        return this.backend;
    }

    public final String computeRoleArn() {
        return this.computeRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.framework());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSkewProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backend());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBranchRequest)) {
            return false;
        }
        UpdateBranchRequest other = (UpdateBranchRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.framework(), other.framework()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.enableNotification(), other.enableNotification()) && Objects.equals(this.enableAutoBuild(), other.enableAutoBuild()) && Objects.equals(this.enableSkewProtection(), other.enableSkewProtection()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.basicAuthCredentials(), other.basicAuthCredentials()) && Objects.equals(this.enableBasicAuth(), other.enableBasicAuth()) && Objects.equals(this.enablePerformanceMode(), other.enablePerformanceMode()) && Objects.equals(this.buildSpec(), other.buildSpec()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.enablePullRequestPreview(), other.enablePullRequestPreview()) && Objects.equals(this.pullRequestEnvironmentName(), other.pullRequestEnvironmentName()) && Objects.equals(this.backendEnvironmentArn(), other.backendEnvironmentArn()) && Objects.equals(this.backend(), other.backend()) && Objects.equals(this.computeRoleArn(), other.computeRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBranchRequest").add("AppId", (Object)this.appId()).add("BranchName", (Object)this.branchName()).add("Description", (Object)this.description()).add("Framework", (Object)this.framework()).add("Stage", (Object)this.stageAsString()).add("EnableNotification", (Object)this.enableNotification()).add("EnableAutoBuild", (Object)this.enableAutoBuild()).add("EnableSkewProtection", (Object)this.enableSkewProtection()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("BasicAuthCredentials", (Object)(this.basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("EnableBasicAuth", (Object)this.enableBasicAuth()).add("EnablePerformanceMode", (Object)this.enablePerformanceMode()).add("BuildSpec", (Object)(this.buildSpec() == null ? null : "*** Sensitive Data Redacted ***")).add("Ttl", (Object)this.ttl()).add("DisplayName", (Object)this.displayName()).add("EnablePullRequestPreview", (Object)this.enablePullRequestPreview()).add("PullRequestEnvironmentName", (Object)this.pullRequestEnvironmentName()).add("BackendEnvironmentArn", (Object)this.backendEnvironmentArn()).add("Backend", (Object)this.backend()).add("ComputeRoleArn", (Object)this.computeRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "framework": {
                return Optional.ofNullable(clazz.cast(this.framework()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "enableNotification": {
                return Optional.ofNullable(clazz.cast(this.enableNotification()));
            }
            case "enableAutoBuild": {
                return Optional.ofNullable(clazz.cast(this.enableAutoBuild()));
            }
            case "enableSkewProtection": {
                return Optional.ofNullable(clazz.cast(this.enableSkewProtection()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "basicAuthCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthCredentials()));
            }
            case "enableBasicAuth": {
                return Optional.ofNullable(clazz.cast(this.enableBasicAuth()));
            }
            case "enablePerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceMode()));
            }
            case "buildSpec": {
                return Optional.ofNullable(clazz.cast(this.buildSpec()));
            }
            case "ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "enablePullRequestPreview": {
                return Optional.ofNullable(clazz.cast(this.enablePullRequestPreview()));
            }
            case "pullRequestEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.pullRequestEnvironmentName()));
            }
            case "backendEnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentArn()));
            }
            case "backend": {
                return Optional.ofNullable(clazz.cast(this.backend()));
            }
            case "computeRoleArn": {
                return Optional.ofNullable(clazz.cast(this.computeRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", APP_ID_FIELD);
        map.put("branchName", BRANCH_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("framework", FRAMEWORK_FIELD);
        map.put("stage", STAGE_FIELD);
        map.put("enableNotification", ENABLE_NOTIFICATION_FIELD);
        map.put("enableAutoBuild", ENABLE_AUTO_BUILD_FIELD);
        map.put("enableSkewProtection", ENABLE_SKEW_PROTECTION_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("basicAuthCredentials", BASIC_AUTH_CREDENTIALS_FIELD);
        map.put("enableBasicAuth", ENABLE_BASIC_AUTH_FIELD);
        map.put("enablePerformanceMode", ENABLE_PERFORMANCE_MODE_FIELD);
        map.put("buildSpec", BUILD_SPEC_FIELD);
        map.put("ttl", TTL_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("enablePullRequestPreview", ENABLE_PULL_REQUEST_PREVIEW_FIELD);
        map.put("pullRequestEnvironmentName", PULL_REQUEST_ENVIRONMENT_NAME_FIELD);
        map.put("backendEnvironmentArn", BACKEND_ENVIRONMENT_ARN_FIELD);
        map.put("backend", BACKEND_FIELD);
        map.put("computeRoleArn", COMPUTE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBranchRequest, T> g) {
        return obj -> g.apply((UpdateBranchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String branchName;
        private String description;
        private String framework;
        private String stage;
        private Boolean enableNotification;
        private Boolean enableAutoBuild;
        private Boolean enableSkewProtection;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private String basicAuthCredentials;
        private Boolean enableBasicAuth;
        private Boolean enablePerformanceMode;
        private String buildSpec;
        private String ttl;
        private String displayName;
        private Boolean enablePullRequestPreview;
        private String pullRequestEnvironmentName;
        private String backendEnvironmentArn;
        private Backend backend;
        private String computeRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBranchRequest model) {
            super(model);
            this.appId(model.appId);
            this.branchName(model.branchName);
            this.description(model.description);
            this.framework(model.framework);
            this.stage(model.stage);
            this.enableNotification(model.enableNotification);
            this.enableAutoBuild(model.enableAutoBuild);
            this.enableSkewProtection(model.enableSkewProtection);
            this.environmentVariables(model.environmentVariables);
            this.basicAuthCredentials(model.basicAuthCredentials);
            this.enableBasicAuth(model.enableBasicAuth);
            this.enablePerformanceMode(model.enablePerformanceMode);
            this.buildSpec(model.buildSpec);
            this.ttl(model.ttl);
            this.displayName(model.displayName);
            this.enablePullRequestPreview(model.enablePullRequestPreview);
            this.pullRequestEnvironmentName(model.pullRequestEnvironmentName);
            this.backendEnvironmentArn(model.backendEnvironmentArn);
            this.backend(model.backend);
            this.computeRoleArn(model.computeRoleArn);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFramework() {
            return this.framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final Boolean getEnableNotification() {
            return this.enableNotification;
        }

        public final void setEnableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
        }

        @Override
        public final Builder enableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
            return this;
        }

        public final Boolean getEnableAutoBuild() {
            return this.enableAutoBuild;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final Boolean getEnableSkewProtection() {
            return this.enableSkewProtection;
        }

        public final void setEnableSkewProtection(Boolean enableSkewProtection) {
            this.enableSkewProtection = enableSkewProtection;
        }

        @Override
        public final Builder enableSkewProtection(Boolean enableSkewProtection) {
            this.enableSkewProtection = enableSkewProtection;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final String getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return this.enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final Boolean getEnablePerformanceMode() {
            return this.enablePerformanceMode;
        }

        public final void setEnablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
        }

        @Override
        public final Builder enablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        public final String getBuildSpec() {
            return this.buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final String getTtl() {
            return this.ttl;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getEnablePullRequestPreview() {
            return this.enablePullRequestPreview;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        @Override
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final String getPullRequestEnvironmentName() {
            return this.pullRequestEnvironmentName;
        }

        public final void setPullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
        }

        @Override
        public final Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        public final String getBackendEnvironmentArn() {
            return this.backendEnvironmentArn;
        }

        public final void setBackendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
        }

        @Override
        public final Builder backendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
            return this;
        }

        public final Backend.Builder getBackend() {
            return this.backend != null ? this.backend.toBuilder() : null;
        }

        public final void setBackend(Backend.BuilderImpl backend) {
            this.backend = backend != null ? backend.build() : null;
        }

        @Override
        public final Builder backend(Backend backend) {
            this.backend = backend;
            return this;
        }

        public final String getComputeRoleArn() {
            return this.computeRoleArn;
        }

        public final void setComputeRoleArn(String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
        }

        @Override
        public final Builder computeRoleArn(String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBranchRequest build() {
            return new UpdateBranchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBranchRequest> {
        public Builder appId(String var1);

        public Builder branchName(String var1);

        public Builder description(String var1);

        public Builder framework(String var1);

        public Builder stage(String var1);

        public Builder stage(Stage var1);

        public Builder enableNotification(Boolean var1);

        public Builder enableAutoBuild(Boolean var1);

        public Builder enableSkewProtection(Boolean var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder basicAuthCredentials(String var1);

        public Builder enableBasicAuth(Boolean var1);

        public Builder enablePerformanceMode(Boolean var1);

        public Builder buildSpec(String var1);

        public Builder ttl(String var1);

        public Builder displayName(String var1);

        public Builder enablePullRequestPreview(Boolean var1);

        public Builder pullRequestEnvironmentName(String var1);

        public Builder backendEnvironmentArn(String var1);

        public Builder backend(Backend var1);

        default public Builder backend(Consumer<Backend.Builder> backend) {
            return this.backend((Backend)((Backend.Builder)Backend.builder().applyMutation(backend)).build());
        }

        public Builder computeRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

