/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure for the delete backend environment request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBackendEnvironmentRequest extends AmplifyRequest implements
        ToCopyableBuilder<DeleteBackendEnvironmentRequest.Builder, DeleteBackendEnvironmentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(DeleteBackendEnvironmentRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(DeleteBackendEnvironmentRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            ENVIRONMENT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String environmentName;

    private DeleteBackendEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
    }

    /**
     * <p>
     * The unique ID of an Amplify app.
     * </p>
     * 
     * @return The unique ID of an Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of a backend environment of an Amplify app.
     * </p>
     * 
     * @return The name of a backend environment of an Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBackendEnvironmentRequest)) {
            return false;
        }
        DeleteBackendEnvironmentRequest other = (DeleteBackendEnvironmentRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(environmentName(), other.environmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBackendEnvironmentRequest").add("AppId", appId())
                .add("EnvironmentName", environmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBackendEnvironmentRequest, T> g) {
        return obj -> g.apply((DeleteBackendEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBackendEnvironmentRequest> {
        /**
         * <p>
         * The unique ID of an Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of a backend environment of an Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of a backend environment of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBackendEnvironmentRequest model) {
            super(model);
            appId(model.appId);
            environmentName(model.environmentName);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBackendEnvironmentRequest build() {
            return new DeleteBackendEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
