/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomRule> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomRule.getter(CustomRule::source)).setter(CustomRule.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomRule.getter(CustomRule::target)).setter(CustomRule.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomRule.getter(CustomRule::status)).setter(CustomRule.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomRule.getter(CustomRule::condition)).setter(CustomRule.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD, STATUS_FIELD, CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String target;
    private final String status;
    private final String condition;

    private CustomRule(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.status = builder.status;
        this.condition = builder.condition;
    }

    public String source() {
        return this.source;
    }

    public String target() {
        return this.target;
    }

    public String status() {
        return this.status;
    }

    public String condition() {
        return this.condition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRule)) {
            return false;
        }
        CustomRule other = (CustomRule)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.condition(), other.condition());
    }

    public String toString() {
        return ToString.builder((String)"CustomRule").add("Source", (Object)this.source()).add("Target", (Object)this.target()).add("Status", (Object)this.status()).add("Condition", (Object)this.condition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomRule, T> g) {
        return obj -> g.apply((CustomRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String target;
        private String status;
        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRule model) {
            this.source(model.source);
            this.target(model.target);
            this.status(model.status);
            this.condition(model.condition);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCondition() {
            return this.condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        public CustomRule build() {
            return new CustomRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomRule> {
        public Builder source(String var1);

        public Builder target(String var1);

        public Builder status(String var1);

        public Builder condition(String var1);
    }
}

