/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure with Production Branch information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductionBranch implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductionBranch.Builder, ProductionBranch> {
    private static final SdkField<Instant> LAST_DEPLOY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProductionBranch::lastDeployTime)).setter(setter(Builder::lastDeployTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeployTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProductionBranch::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> THUMBNAIL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProductionBranch::thumbnailUrl)).setter(setter(Builder::thumbnailUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailUrl").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProductionBranch::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_DEPLOY_TIME_FIELD,
            STATUS_FIELD, THUMBNAIL_URL_FIELD, BRANCH_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant lastDeployTime;

    private final String status;

    private final String thumbnailUrl;

    private final String branchName;

    private ProductionBranch(BuilderImpl builder) {
        this.lastDeployTime = builder.lastDeployTime;
        this.status = builder.status;
        this.thumbnailUrl = builder.thumbnailUrl;
        this.branchName = builder.branchName;
    }

    /**
     * <p>
     * Last Deploy Time of Production Branch.
     * </p>
     * 
     * @return Last Deploy Time of Production Branch.
     */
    public Instant lastDeployTime() {
        return lastDeployTime;
    }

    /**
     * <p>
     * Status of Production Branch.
     * </p>
     * 
     * @return Status of Production Branch.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Thumbnail URL for Production Branch.
     * </p>
     * 
     * @return Thumbnail URL for Production Branch.
     */
    public String thumbnailUrl() {
        return thumbnailUrl;
    }

    /**
     * <p>
     * Branch Name for Production Branch.
     * </p>
     * 
     * @return Branch Name for Production Branch.
     */
    public String branchName() {
        return branchName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastDeployTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailUrl());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionBranch)) {
            return false;
        }
        ProductionBranch other = (ProductionBranch) obj;
        return Objects.equals(lastDeployTime(), other.lastDeployTime()) && Objects.equals(status(), other.status())
                && Objects.equals(thumbnailUrl(), other.thumbnailUrl()) && Objects.equals(branchName(), other.branchName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProductionBranch").add("LastDeployTime", lastDeployTime()).add("Status", status())
                .add("ThumbnailUrl", thumbnailUrl()).add("BranchName", branchName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastDeployTime":
            return Optional.ofNullable(clazz.cast(lastDeployTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "thumbnailUrl":
            return Optional.ofNullable(clazz.cast(thumbnailUrl()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionBranch, T> g) {
        return obj -> g.apply((ProductionBranch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductionBranch> {
        /**
         * <p>
         * Last Deploy Time of Production Branch.
         * </p>
         * 
         * @param lastDeployTime
         *        Last Deploy Time of Production Branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeployTime(Instant lastDeployTime);

        /**
         * <p>
         * Status of Production Branch.
         * </p>
         * 
         * @param status
         *        Status of Production Branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Thumbnail URL for Production Branch.
         * </p>
         * 
         * @param thumbnailUrl
         *        Thumbnail URL for Production Branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailUrl(String thumbnailUrl);

        /**
         * <p>
         * Branch Name for Production Branch.
         * </p>
         * 
         * @param branchName
         *        Branch Name for Production Branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastDeployTime;

        private String status;

        private String thumbnailUrl;

        private String branchName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionBranch model) {
            lastDeployTime(model.lastDeployTime);
            status(model.status);
            thumbnailUrl(model.thumbnailUrl);
            branchName(model.branchName);
        }

        public final Instant getLastDeployTime() {
            return lastDeployTime;
        }

        @Override
        public final Builder lastDeployTime(Instant lastDeployTime) {
            this.lastDeployTime = lastDeployTime;
            return this;
        }

        public final void setLastDeployTime(Instant lastDeployTime) {
            this.lastDeployTime = lastDeployTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getThumbnailUrl() {
            return thumbnailUrl;
        }

        @Override
        public final Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public final void setThumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public ProductionBranch build() {
            return new ProductionBranch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
