/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure for start a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeploymentResponse extends AmplifyResponse implements
        ToCopyableBuilder<StartDeploymentResponse.Builder, StartDeploymentResponse> {
    private static final SdkField<JobSummary> JOB_SUMMARY_FIELD = SdkField.<JobSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartDeploymentResponse::jobSummary)).setter(setter(Builder::jobSummary))
            .constructor(JobSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARY_FIELD));

    private final JobSummary jobSummary;

    private StartDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummary = builder.jobSummary;
    }

    /**
     * <p>
     * Summary for the Job.
     * </p>
     * 
     * @return Summary for the Job.
     */
    public JobSummary jobSummary() {
        return jobSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentResponse)) {
            return false;
        }
        StartDeploymentResponse other = (StartDeploymentResponse) obj;
        return Objects.equals(jobSummary(), other.jobSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartDeploymentResponse").add("JobSummary", jobSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobSummary":
            return Optional.ofNullable(clazz.cast(jobSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentResponse, T> g) {
        return obj -> g.apply((StartDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartDeploymentResponse> {
        /**
         * <p>
         * Summary for the Job.
         * </p>
         * 
         * @param jobSummary
         *        Summary for the Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummary(JobSummary jobSummary);

        /**
         * <p>
         * Summary for the Job.
         * </p>
         * This is a convenience that creates an instance of the {@link JobSummary.Builder} avoiding the need to create
         * one manually via {@link JobSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSummary.Builder#build()} is called immediately and its result
         * is passed to {@link #jobSummary(JobSummary)}.
         * 
         * @param jobSummary
         *        a consumer that will call methods on {@link JobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSummary(JobSummary)
         */
        default Builder jobSummary(Consumer<JobSummary.Builder> jobSummary) {
            return jobSummary(JobSummary.builder().applyMutation(jobSummary).build());
        }
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private JobSummary jobSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentResponse model) {
            super(model);
            jobSummary(model.jobSummary);
        }

        public final JobSummary.Builder getJobSummary() {
            return jobSummary != null ? jobSummary.toBuilder() : null;
        }

        @Override
        public final Builder jobSummary(JobSummary jobSummary) {
            this.jobSummary = jobSummary;
            return this;
        }

        public final void setJobSummary(JobSummary.BuilderImpl jobSummary) {
            this.jobSummary = jobSummary != null ? jobSummary.build() : null;
        }

        @Override
        public StartDeploymentResponse build() {
            return new StartDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
