/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amplify App represents different branches of a repository for building, deploying, and hosting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class App implements SdkPojo, Serializable, ToCopyableBuilder<App.Builder, App> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(App::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(App::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(App::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::iamServiceRoleArn)).setter(setter(Builder::iamServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(App::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::defaultDomain)).setter(setter(Builder::defaultDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDomain").build()).build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(App::enableBranchAutoBuild)).setter(setter(Builder::enableBranchAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(App::enableBasicAuth)).setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::basicAuthCredentials)).setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField
            .<List<CustomRule>> builder(MarshallingType.LIST)
            .getter(getter(App::customRules))
            .setter(setter(Builder::customRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProductionBranch> PRODUCTION_BRANCH_FIELD = SdkField
            .<ProductionBranch> builder(MarshallingType.SDK_POJO).getter(getter(App::productionBranch))
            .setter(setter(Builder::productionBranch)).constructor(ProductionBranch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productionBranch").build()).build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BRANCH_CREATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(App::enableAutoBranchCreation))
            .setter(setter(Builder::enableAutoBranchCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBranchCreation").build())
            .build();

    private static final SdkField<List<String>> AUTO_BRANCH_CREATION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(App::autoBranchCreationPatterns))
            .setter(setter(Builder::autoBranchCreationPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoBranchCreationConfig> AUTO_BRANCH_CREATION_CONFIG_FIELD = SdkField
            .<AutoBranchCreationConfig> builder(MarshallingType.SDK_POJO).getter(getter(App::autoBranchCreationConfig))
            .setter(setter(Builder::autoBranchCreationConfig)).constructor(AutoBranchCreationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_ARN_FIELD,
            NAME_FIELD, TAGS_FIELD, DESCRIPTION_FIELD, REPOSITORY_FIELD, PLATFORM_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD,
            IAM_SERVICE_ROLE_ARN_FIELD, ENVIRONMENT_VARIABLES_FIELD, DEFAULT_DOMAIN_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD,
            ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD, PRODUCTION_BRANCH_FIELD, BUILD_SPEC_FIELD,
            ENABLE_AUTO_BRANCH_CREATION_FIELD, AUTO_BRANCH_CREATION_PATTERNS_FIELD, AUTO_BRANCH_CREATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final String appArn;

    private final String name;

    private final Map<String, String> tags;

    private final String description;

    private final String repository;

    private final String platform;

    private final Instant createTime;

    private final Instant updateTime;

    private final String iamServiceRoleArn;

    private final Map<String, String> environmentVariables;

    private final String defaultDomain;

    private final Boolean enableBranchAutoBuild;

    private final Boolean enableBasicAuth;

    private final String basicAuthCredentials;

    private final List<CustomRule> customRules;

    private final ProductionBranch productionBranch;

    private final String buildSpec;

    private final Boolean enableAutoBranchCreation;

    private final List<String> autoBranchCreationPatterns;

    private final AutoBranchCreationConfig autoBranchCreationConfig;

    private App(BuilderImpl builder) {
        this.appId = builder.appId;
        this.appArn = builder.appArn;
        this.name = builder.name;
        this.tags = builder.tags;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.environmentVariables = builder.environmentVariables;
        this.defaultDomain = builder.defaultDomain;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.productionBranch = builder.productionBranch;
        this.buildSpec = builder.buildSpec;
        this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
        this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
        this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
    }

    /**
     * <p>
     * Unique Id for the Amplify App.
     * </p>
     * 
     * @return Unique Id for the Amplify App.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * ARN for the Amplify App.
     * </p>
     * 
     * @return ARN for the Amplify App.
     */
    public String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Name for the Amplify App.
     * </p>
     * 
     * @return Name for the Amplify App.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Tag for Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Tag for Amplify App.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Description for the Amplify App.
     * </p>
     * 
     * @return Description for the Amplify App.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Repository for the Amplify App.
     * </p>
     * 
     * @return Repository for the Amplify App.
     */
    public String repository() {
        return repository;
    }

    /**
     * <p>
     * Platform for the Amplify App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return Platform for the Amplify App.
     * @see Platform
     */
    public Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * Platform for the Amplify App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return Platform for the Amplify App.
     * @see Platform
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * Create date / time for the Amplify App.
     * </p>
     * 
     * @return Create date / time for the Amplify App.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Update date / time for the Amplify App.
     * </p>
     * 
     * @return Update date / time for the Amplify App.
     */
    public Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * IAM service role ARN for the Amplify App.
     * </p>
     * 
     * @return IAM service role ARN for the Amplify App.
     */
    public String iamServiceRoleArn() {
        return iamServiceRoleArn;
    }

    /**
     * <p>
     * Environment Variables for the Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Environment Variables for the Amplify App.
     */
    public Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Default domain for the Amplify App.
     * </p>
     * 
     * @return Default domain for the Amplify App.
     */
    public String defaultDomain() {
        return defaultDomain;
    }

    /**
     * <p>
     * Enables auto-building of branches for the Amplify App.
     * </p>
     * 
     * @return Enables auto-building of branches for the Amplify App.
     */
    public Boolean enableBranchAutoBuild() {
        return enableBranchAutoBuild;
    }

    /**
     * <p>
     * Enables Basic Authorization for branches for the Amplify App.
     * </p>
     * 
     * @return Enables Basic Authorization for branches for the Amplify App.
     */
    public Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * Basic Authorization credentials for branches for the Amplify App.
     * </p>
     * 
     * @return Basic Authorization credentials for branches for the Amplify App.
     */
    public String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * Custom redirect / rewrite rules for the Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Custom redirect / rewrite rules for the Amplify App.
     */
    public List<CustomRule> customRules() {
        return customRules;
    }

    /**
     * <p>
     * Structure with Production Branch information.
     * </p>
     * 
     * @return Structure with Production Branch information.
     */
    public ProductionBranch productionBranch() {
        return productionBranch;
    }

    /**
     * <p>
     * BuildSpec content for Amplify App.
     * </p>
     * 
     * @return BuildSpec content for Amplify App.
     */
    public String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * Enables automated branch creation for the Amplify App.
     * </p>
     * 
     * @return Enables automated branch creation for the Amplify App.
     */
    public Boolean enableAutoBranchCreation() {
        return enableAutoBranchCreation;
    }

    /**
     * <p>
     * Automated branch creation glob patterns for the Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Automated branch creation glob patterns for the Amplify App.
     */
    public List<String> autoBranchCreationPatterns() {
        return autoBranchCreationPatterns;
    }

    /**
     * <p>
     * Automated branch creation config for the Amplify App.
     * </p>
     * 
     * @return Automated branch creation config for the Amplify App.
     */
    public AutoBranchCreationConfig autoBranchCreationConfig() {
        return autoBranchCreationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDomain());
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(customRules());
        hashCode = 31 * hashCode + Objects.hashCode(productionBranch());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBranchCreation());
        hashCode = 31 * hashCode + Objects.hashCode(autoBranchCreationPatterns());
        hashCode = 31 * hashCode + Objects.hashCode(autoBranchCreationConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(appArn(), other.appArn())
                && Objects.equals(name(), other.name()) && Objects.equals(tags(), other.tags())
                && Objects.equals(description(), other.description()) && Objects.equals(repository(), other.repository())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(iamServiceRoleArn(), other.iamServiceRoleArn())
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(defaultDomain(), other.defaultDomain())
                && Objects.equals(enableBranchAutoBuild(), other.enableBranchAutoBuild())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(customRules(), other.customRules())
                && Objects.equals(productionBranch(), other.productionBranch()) && Objects.equals(buildSpec(), other.buildSpec())
                && Objects.equals(enableAutoBranchCreation(), other.enableAutoBranchCreation())
                && Objects.equals(autoBranchCreationPatterns(), other.autoBranchCreationPatterns())
                && Objects.equals(autoBranchCreationConfig(), other.autoBranchCreationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("App").add("AppId", appId()).add("AppArn", appArn()).add("Name", name()).add("Tags", tags())
                .add("Description", description()).add("Repository", repository()).add("Platform", platformAsString())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("IamServiceRoleArn", iamServiceRoleArn())
                .add("EnvironmentVariables", environmentVariables()).add("DefaultDomain", defaultDomain())
                .add("EnableBranchAutoBuild", enableBranchAutoBuild()).add("EnableBasicAuth", enableBasicAuth())
                .add("BasicAuthCredentials", basicAuthCredentials()).add("CustomRules", customRules())
                .add("ProductionBranch", productionBranch()).add("BuildSpec", buildSpec())
                .add("EnableAutoBranchCreation", enableAutoBranchCreation())
                .add("AutoBranchCreationPatterns", autoBranchCreationPatterns())
                .add("AutoBranchCreationConfig", autoBranchCreationConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "iamServiceRoleArn":
            return Optional.ofNullable(clazz.cast(iamServiceRoleArn()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "defaultDomain":
            return Optional.ofNullable(clazz.cast(defaultDomain()));
        case "enableBranchAutoBuild":
            return Optional.ofNullable(clazz.cast(enableBranchAutoBuild()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "customRules":
            return Optional.ofNullable(clazz.cast(customRules()));
        case "productionBranch":
            return Optional.ofNullable(clazz.cast(productionBranch()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "enableAutoBranchCreation":
            return Optional.ofNullable(clazz.cast(enableAutoBranchCreation()));
        case "autoBranchCreationPatterns":
            return Optional.ofNullable(clazz.cast(autoBranchCreationPatterns()));
        case "autoBranchCreationConfig":
            return Optional.ofNullable(clazz.cast(autoBranchCreationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, App> {
        /**
         * <p>
         * Unique Id for the Amplify App.
         * </p>
         * 
         * @param appId
         *        Unique Id for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * ARN for the Amplify App.
         * </p>
         * 
         * @param appArn
         *        ARN for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Name for the Amplify App.
         * </p>
         * 
         * @param name
         *        Name for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Tag for Amplify App.
         * </p>
         * 
         * @param tags
         *        Tag for Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Description for the Amplify App.
         * </p>
         * 
         * @param description
         *        Description for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Repository for the Amplify App.
         * </p>
         * 
         * @param repository
         *        Repository for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * Platform for the Amplify App.
         * </p>
         * 
         * @param platform
         *        Platform for the Amplify App.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * Platform for the Amplify App.
         * </p>
         * 
         * @param platform
         *        Platform for the Amplify App.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * Create date / time for the Amplify App.
         * </p>
         * 
         * @param createTime
         *        Create date / time for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Update date / time for the Amplify App.
         * </p>
         * 
         * @param updateTime
         *        Update date / time for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * IAM service role ARN for the Amplify App.
         * </p>
         * 
         * @param iamServiceRoleArn
         *        IAM service role ARN for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamServiceRoleArn(String iamServiceRoleArn);

        /**
         * <p>
         * Environment Variables for the Amplify App.
         * </p>
         * 
         * @param environmentVariables
         *        Environment Variables for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Default domain for the Amplify App.
         * </p>
         * 
         * @param defaultDomain
         *        Default domain for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDomain(String defaultDomain);

        /**
         * <p>
         * Enables auto-building of branches for the Amplify App.
         * </p>
         * 
         * @param enableBranchAutoBuild
         *        Enables auto-building of branches for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild);

        /**
         * <p>
         * Enables Basic Authorization for branches for the Amplify App.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables Basic Authorization for branches for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * Basic Authorization credentials for branches for the Amplify App.
         * </p>
         * 
         * @param basicAuthCredentials
         *        Basic Authorization credentials for branches for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * Custom redirect / rewrite rules for the Amplify App.
         * </p>
         * 
         * @param customRules
         *        Custom redirect / rewrite rules for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(Collection<CustomRule> customRules);

        /**
         * <p>
         * Custom redirect / rewrite rules for the Amplify App.
         * </p>
         * 
         * @param customRules
         *        Custom redirect / rewrite rules for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(CustomRule... customRules);

        /**
         * <p>
         * Custom redirect / rewrite rules for the Amplify App.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomRule>.Builder} avoiding the need to
         * create one manually via {@link List<CustomRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #customRules(List<CustomRule>)}.
         * 
         * @param customRules
         *        a consumer that will call methods on {@link List<CustomRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRules(List<CustomRule>)
         */
        Builder customRules(Consumer<CustomRule.Builder>... customRules);

        /**
         * <p>
         * Structure with Production Branch information.
         * </p>
         * 
         * @param productionBranch
         *        Structure with Production Branch information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionBranch(ProductionBranch productionBranch);

        /**
         * <p>
         * Structure with Production Branch information.
         * </p>
         * This is a convenience that creates an instance of the {@link ProductionBranch.Builder} avoiding the need to
         * create one manually via {@link ProductionBranch#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProductionBranch.Builder#build()} is called immediately and its
         * result is passed to {@link #productionBranch(ProductionBranch)}.
         * 
         * @param productionBranch
         *        a consumer that will call methods on {@link ProductionBranch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productionBranch(ProductionBranch)
         */
        default Builder productionBranch(Consumer<ProductionBranch.Builder> productionBranch) {
            return productionBranch(ProductionBranch.builder().applyMutation(productionBranch).build());
        }

        /**
         * <p>
         * BuildSpec content for Amplify App.
         * </p>
         * 
         * @param buildSpec
         *        BuildSpec content for Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * Enables automated branch creation for the Amplify App.
         * </p>
         * 
         * @param enableAutoBranchCreation
         *        Enables automated branch creation for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation);

        /**
         * <p>
         * Automated branch creation glob patterns for the Amplify App.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        Automated branch creation glob patterns for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns);

        /**
         * <p>
         * Automated branch creation glob patterns for the Amplify App.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        Automated branch creation glob patterns for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns);

        /**
         * <p>
         * Automated branch creation config for the Amplify App.
         * </p>
         * 
         * @param autoBranchCreationConfig
         *        Automated branch creation config for the Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig);

        /**
         * <p>
         * Automated branch creation config for the Amplify App.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoBranchCreationConfig.Builder} avoiding the
         * need to create one manually via {@link AutoBranchCreationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoBranchCreationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #autoBranchCreationConfig(AutoBranchCreationConfig)}.
         * 
         * @param autoBranchCreationConfig
         *        a consumer that will call methods on {@link AutoBranchCreationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoBranchCreationConfig(AutoBranchCreationConfig)
         */
        default Builder autoBranchCreationConfig(Consumer<AutoBranchCreationConfig.Builder> autoBranchCreationConfig) {
            return autoBranchCreationConfig(AutoBranchCreationConfig.builder().applyMutation(autoBranchCreationConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private String appArn;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private String repository;

        private String platform;

        private Instant createTime;

        private Instant updateTime;

        private String iamServiceRoleArn;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private String defaultDomain;

        private Boolean enableBranchAutoBuild;

        private Boolean enableBasicAuth;

        private String basicAuthCredentials;

        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();

        private ProductionBranch productionBranch;

        private String buildSpec;

        private Boolean enableAutoBranchCreation;

        private List<String> autoBranchCreationPatterns = DefaultSdkAutoConstructList.getInstance();

        private AutoBranchCreationConfig autoBranchCreationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            appId(model.appId);
            appArn(model.appArn);
            name(model.name);
            tags(model.tags);
            description(model.description);
            repository(model.repository);
            platform(model.platform);
            createTime(model.createTime);
            updateTime(model.updateTime);
            iamServiceRoleArn(model.iamServiceRoleArn);
            environmentVariables(model.environmentVariables);
            defaultDomain(model.defaultDomain);
            enableBranchAutoBuild(model.enableBranchAutoBuild);
            enableBasicAuth(model.enableBasicAuth);
            basicAuthCredentials(model.basicAuthCredentials);
            customRules(model.customRules);
            productionBranch(model.productionBranch);
            buildSpec(model.buildSpec);
            enableAutoBranchCreation(model.enableAutoBranchCreation);
            autoBranchCreationPatterns(model.autoBranchCreationPatterns);
            autoBranchCreationConfig(model.autoBranchCreationConfig);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getAppArn() {
            return appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRepository() {
            return repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getPlatformAsString() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final String getIamServiceRoleArn() {
            return iamServiceRoleArn;
        }

        @Override
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final String getDefaultDomain() {
            return defaultDomain;
        }

        @Override
        public final Builder defaultDomain(String defaultDomain) {
            this.defaultDomain = defaultDomain;
            return this;
        }

        public final void setDefaultDomain(String defaultDomain) {
            this.defaultDomain = defaultDomain;
        }

        public final Boolean getEnableBranchAutoBuild() {
            return enableBranchAutoBuild;
        }

        @Override
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final Collection<CustomRule.Builder> getCustomRules() {
            return customRules != null ? customRules.stream().map(CustomRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(CustomRule... customRules) {
            customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder>... customRules) {
            customRules(Stream.of(customRules).map(c -> CustomRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        public final ProductionBranch.Builder getProductionBranch() {
            return productionBranch != null ? productionBranch.toBuilder() : null;
        }

        @Override
        public final Builder productionBranch(ProductionBranch productionBranch) {
            this.productionBranch = productionBranch;
            return this;
        }

        public final void setProductionBranch(ProductionBranch.BuilderImpl productionBranch) {
            this.productionBranch = productionBranch != null ? productionBranch.build() : null;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final Boolean getEnableAutoBranchCreation() {
            return enableAutoBranchCreation;
        }

        @Override
        public final Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
            return this;
        }

        public final void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
        }

        public final Collection<String> getAutoBranchCreationPatterns() {
            return autoBranchCreationPatterns;
        }

        @Override
        public final Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns) {
            autoBranchCreationPatterns(Arrays.asList(autoBranchCreationPatterns));
            return this;
        }

        public final void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
        }

        public final AutoBranchCreationConfig.Builder getAutoBranchCreationConfig() {
            return autoBranchCreationConfig != null ? autoBranchCreationConfig.toBuilder() : null;
        }

        @Override
        public final Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        public final void setAutoBranchCreationConfig(AutoBranchCreationConfig.BuilderImpl autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig != null ? autoBranchCreationConfig.build() : null;
        }

        @Override
        public App build() {
            return new App(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
