/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request structure for update Domain Association request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainAssociationRequest extends AmplifyRequest implements
        ToCopyableBuilder<UpdateDomainAssociationRequest.Builder, UpdateDomainAssociationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDomainAssociationRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDomainAssociationRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_SUB_DOMAIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateDomainAssociationRequest::enableAutoSubDomain)).setter(setter(Builder::enableAutoSubDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoSubDomain").build())
            .build();

    private static final SdkField<List<SubDomainSetting>> SUB_DOMAIN_SETTINGS_FIELD = SdkField
            .<List<SubDomainSetting>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDomainAssociationRequest::subDomainSettings))
            .setter(setter(Builder::subDomainSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subDomainSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubDomainSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubDomainSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            DOMAIN_NAME_FIELD, ENABLE_AUTO_SUB_DOMAIN_FIELD, SUB_DOMAIN_SETTINGS_FIELD));

    private final String appId;

    private final String domainName;

    private final Boolean enableAutoSubDomain;

    private final List<SubDomainSetting> subDomainSettings;

    private UpdateDomainAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.domainName = builder.domainName;
        this.enableAutoSubDomain = builder.enableAutoSubDomain;
        this.subDomainSettings = builder.subDomainSettings;
    }

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     * 
     * @return Unique Id for an Amplify App.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * Name of the domain.
     * </p>
     * 
     * @return Name of the domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Enables automated creation of Subdomains for branches.
     * </p>
     * 
     * @return Enables automated creation of Subdomains for branches.
     */
    public Boolean enableAutoSubDomain() {
        return enableAutoSubDomain;
    }

    /**
     * <p>
     * Setting structure for the Subdomain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Setting structure for the Subdomain.
     */
    public List<SubDomainSetting> subDomainSettings() {
        return subDomainSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoSubDomain());
        hashCode = 31 * hashCode + Objects.hashCode(subDomainSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainAssociationRequest)) {
            return false;
        }
        UpdateDomainAssociationRequest other = (UpdateDomainAssociationRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(enableAutoSubDomain(), other.enableAutoSubDomain())
                && Objects.equals(subDomainSettings(), other.subDomainSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDomainAssociationRequest").add("AppId", appId()).add("DomainName", domainName())
                .add("EnableAutoSubDomain", enableAutoSubDomain()).add("SubDomainSettings", subDomainSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "enableAutoSubDomain":
            return Optional.ofNullable(clazz.cast(enableAutoSubDomain()));
        case "subDomainSettings":
            return Optional.ofNullable(clazz.cast(subDomainSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDomainAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainAssociationRequest> {
        /**
         * <p>
         * Unique Id for an Amplify App.
         * </p>
         * 
         * @param appId
         *        Unique Id for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Name of the domain.
         * </p>
         * 
         * @param domainName
         *        Name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Enables automated creation of Subdomains for branches.
         * </p>
         * 
         * @param enableAutoSubDomain
         *        Enables automated creation of Subdomains for branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoSubDomain(Boolean enableAutoSubDomain);

        /**
         * <p>
         * Setting structure for the Subdomain.
         * </p>
         * 
         * @param subDomainSettings
         *        Setting structure for the Subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDomainSettings(Collection<SubDomainSetting> subDomainSettings);

        /**
         * <p>
         * Setting structure for the Subdomain.
         * </p>
         * 
         * @param subDomainSettings
         *        Setting structure for the Subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDomainSettings(SubDomainSetting... subDomainSettings);

        /**
         * <p>
         * Setting structure for the Subdomain.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubDomainSetting>.Builder} avoiding the
         * need to create one manually via {@link List<SubDomainSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubDomainSetting>.Builder#build()} is called immediately and
         * its result is passed to {@link #subDomainSettings(List<SubDomainSetting>)}.
         * 
         * @param subDomainSettings
         *        a consumer that will call methods on {@link List<SubDomainSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subDomainSettings(List<SubDomainSetting>)
         */
        Builder subDomainSettings(Consumer<SubDomainSetting.Builder>... subDomainSettings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String domainName;

        private Boolean enableAutoSubDomain;

        private List<SubDomainSetting> subDomainSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainAssociationRequest model) {
            super(model);
            appId(model.appId);
            domainName(model.domainName);
            enableAutoSubDomain(model.enableAutoSubDomain);
            subDomainSettings(model.subDomainSettings);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getEnableAutoSubDomain() {
            return enableAutoSubDomain;
        }

        @Override
        public final Builder enableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
            return this;
        }

        public final void setEnableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
        }

        public final Collection<SubDomainSetting.Builder> getSubDomainSettings() {
            return subDomainSettings != null ? subDomainSettings.stream().map(SubDomainSetting::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subDomainSettings(Collection<SubDomainSetting> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copy(subDomainSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomainSettings(SubDomainSetting... subDomainSettings) {
            subDomainSettings(Arrays.asList(subDomainSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomainSettings(Consumer<SubDomainSetting.Builder>... subDomainSettings) {
            subDomainSettings(Stream.of(subDomainSettings).map(c -> SubDomainSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubDomainSettings(Collection<SubDomainSetting.BuilderImpl> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copyFromBuilder(subDomainSettings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainAssociationRequest build() {
            return new UpdateDomainAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
