/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Branch for an Amplify App, which maps to a 3rd party repository branch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Branch implements SdkPojo, Serializable, ToCopyableBuilder<Branch.Builder, Branch> {
    private static final SdkField<String> BRANCH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::branchArn)).setter(setter(Builder::branchArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchArn").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Branch::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Boolean> ENABLE_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Branch::enableNotification)).setter(setter(Builder::enableNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableNotification").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Branch::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Branch::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Branch::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Branch::enableAutoBuild)).setter(setter(Builder::enableAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()).build();

    private static final SdkField<List<String>> CUSTOM_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Branch::customDomains))
            .setter(setter(Builder::customDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::framework)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()).build();

    private static final SdkField<String> ACTIVE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::activeJobId)).setter(setter(Builder::activeJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeJobId").build()).build();

    private static final SdkField<String> TOTAL_NUMBER_OF_JOBS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::totalNumberOfJobs)).setter(setter(Builder::totalNumberOfJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNumberOfJobs").build()).build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Branch::enableBasicAuth)).setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<String> THUMBNAIL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::thumbnailUrl)).setter(setter(Builder::thumbnailUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailUrl").build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::basicAuthCredentials)).setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<String> TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Branch::associatedResources))
            .setter(setter(Builder::associatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(Branch::enablePullRequestPreview))
            .setter(setter(Builder::enablePullRequestPreview))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build())
            .build();

    private static final SdkField<String> DESTINATION_BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::destinationBranch)).setter(setter(Builder::destinationBranch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationBranch").build()).build();

    private static final SdkField<String> SOURCE_BRANCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Branch::sourceBranch)).setter(setter(Builder::sourceBranch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceBranch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_ARN_FIELD,
            BRANCH_NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, STAGE_FIELD, DISPLAY_NAME_FIELD, ENABLE_NOTIFICATION_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ENVIRONMENT_VARIABLES_FIELD, ENABLE_AUTO_BUILD_FIELD, CUSTOM_DOMAINS_FIELD,
            FRAMEWORK_FIELD, ACTIVE_JOB_ID_FIELD, TOTAL_NUMBER_OF_JOBS_FIELD, ENABLE_BASIC_AUTH_FIELD, THUMBNAIL_URL_FIELD,
            BASIC_AUTH_CREDENTIALS_FIELD, BUILD_SPEC_FIELD, TTL_FIELD, ASSOCIATED_RESOURCES_FIELD,
            ENABLE_PULL_REQUEST_PREVIEW_FIELD, DESTINATION_BRANCH_FIELD, SOURCE_BRANCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String branchArn;

    private final String branchName;

    private final String description;

    private final Map<String, String> tags;

    private final String stage;

    private final String displayName;

    private final Boolean enableNotification;

    private final Instant createTime;

    private final Instant updateTime;

    private final Map<String, String> environmentVariables;

    private final Boolean enableAutoBuild;

    private final List<String> customDomains;

    private final String framework;

    private final String activeJobId;

    private final String totalNumberOfJobs;

    private final Boolean enableBasicAuth;

    private final String thumbnailUrl;

    private final String basicAuthCredentials;

    private final String buildSpec;

    private final String ttl;

    private final List<String> associatedResources;

    private final Boolean enablePullRequestPreview;

    private final String destinationBranch;

    private final String sourceBranch;

    private Branch(BuilderImpl builder) {
        this.branchArn = builder.branchArn;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.tags = builder.tags;
        this.stage = builder.stage;
        this.displayName = builder.displayName;
        this.enableNotification = builder.enableNotification;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.environmentVariables = builder.environmentVariables;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.customDomains = builder.customDomains;
        this.framework = builder.framework;
        this.activeJobId = builder.activeJobId;
        this.totalNumberOfJobs = builder.totalNumberOfJobs;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.thumbnailUrl = builder.thumbnailUrl;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.buildSpec = builder.buildSpec;
        this.ttl = builder.ttl;
        this.associatedResources = builder.associatedResources;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.destinationBranch = builder.destinationBranch;
        this.sourceBranch = builder.sourceBranch;
    }

    /**
     * <p>
     * ARN for a branch, part of an Amplify App.
     * </p>
     * 
     * @return ARN for a branch, part of an Amplify App.
     */
    public String branchArn() {
        return branchArn;
    }

    /**
     * <p>
     * Name for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Name for a branch, part of an Amplify App.
     */
    public String branchName() {
        return branchName;
    }

    /**
     * <p>
     * Description for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Description for a branch, part of an Amplify App.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Tag for branch for Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Tag for branch for Amplify App.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Stage for a branch, part of an Amplify App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage for a branch, part of an Amplify App.
     * @see Stage
     */
    public Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * Stage for a branch, part of an Amplify App.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Stage for a branch, part of an Amplify App.
     * @see Stage
     */
    public String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * Display name for a branch, will use as the default domain prefix.
     * </p>
     * 
     * @return Display name for a branch, will use as the default domain prefix.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Enables notifications for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Enables notifications for a branch, part of an Amplify App.
     */
    public Boolean enableNotification() {
        return enableNotification;
    }

    /**
     * <p>
     * Creation date and time for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Creation date and time for a branch, part of an Amplify App.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Last updated date and time for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Last updated date and time for a branch, part of an Amplify App.
     */
    public Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * Environment Variables specific to a branch, part of an Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Environment Variables specific to a branch, part of an Amplify App.
     */
    public Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Enables auto-building on push for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Enables auto-building on push for a branch, part of an Amplify App.
     */
    public Boolean enableAutoBuild() {
        return enableAutoBuild;
    }

    /**
     * <p>
     * Custom domains for a branch, part of an Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Custom domains for a branch, part of an Amplify App.
     */
    public List<String> customDomains() {
        return customDomains;
    }

    /**
     * <p>
     * Framework for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Framework for a branch, part of an Amplify App.
     */
    public String framework() {
        return framework;
    }

    /**
     * <p>
     * Id of the active job for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Id of the active job for a branch, part of an Amplify App.
     */
    public String activeJobId() {
        return activeJobId;
    }

    /**
     * <p>
     * Total number of Jobs part of an Amplify App.
     * </p>
     * 
     * @return Total number of Jobs part of an Amplify App.
     */
    public String totalNumberOfJobs() {
        return totalNumberOfJobs;
    }

    /**
     * <p>
     * Enables Basic Authorization for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Enables Basic Authorization for a branch, part of an Amplify App.
     */
    public Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * Thumbnail URL for the branch.
     * </p>
     * 
     * @return Thumbnail URL for the branch.
     */
    public String thumbnailUrl() {
        return thumbnailUrl;
    }

    /**
     * <p>
     * Basic Authorization credentials for a branch, part of an Amplify App.
     * </p>
     * 
     * @return Basic Authorization credentials for a branch, part of an Amplify App.
     */
    public String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * BuildSpec content for branch for Amplify App.
     * </p>
     * 
     * @return BuildSpec content for branch for Amplify App.
     */
    public String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * The content TTL for the website in seconds.
     * </p>
     * 
     * @return The content TTL for the website in seconds.
     */
    public String ttl() {
        return ttl;
    }

    /**
     * <p>
     * List of custom resources that are linked to this branch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of custom resources that are linked to this branch.
     */
    public List<String> associatedResources() {
        return associatedResources;
    }

    /**
     * <p>
     * Enables Pull Request Preview for this branch.
     * </p>
     * 
     * @return Enables Pull Request Preview for this branch.
     */
    public Boolean enablePullRequestPreview() {
        return enablePullRequestPreview;
    }

    /**
     * <p>
     * The destination branch if the branch is a pull request branch.
     * </p>
     * 
     * @return The destination branch if the branch is a pull request branch.
     */
    public String destinationBranch() {
        return destinationBranch;
    }

    /**
     * <p>
     * The source branch if the branch is a pull request branch.
     * </p>
     * 
     * @return The source branch if the branch is a pull request branch.
     */
    public String sourceBranch() {
        return sourceBranch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branchArn());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(enableNotification());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(environmentVariables());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(customDomains());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(activeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailUrl());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResources());
        hashCode = 31 * hashCode + Objects.hashCode(enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(destinationBranch());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBranch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Branch)) {
            return false;
        }
        Branch other = (Branch) obj;
        return Objects.equals(branchArn(), other.branchArn()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(description(), other.description()) && Objects.equals(tags(), other.tags())
                && Objects.equals(stageAsString(), other.stageAsString()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(enableNotification(), other.enableNotification())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(enableAutoBuild(), other.enableAutoBuild())
                && Objects.equals(customDomains(), other.customDomains()) && Objects.equals(framework(), other.framework())
                && Objects.equals(activeJobId(), other.activeJobId())
                && Objects.equals(totalNumberOfJobs(), other.totalNumberOfJobs())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(thumbnailUrl(), other.thumbnailUrl())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(buildSpec(), other.buildSpec()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(associatedResources(), other.associatedResources())
                && Objects.equals(enablePullRequestPreview(), other.enablePullRequestPreview())
                && Objects.equals(destinationBranch(), other.destinationBranch())
                && Objects.equals(sourceBranch(), other.sourceBranch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Branch").add("BranchArn", branchArn()).add("BranchName", branchName())
                .add("Description", description()).add("Tags", tags()).add("Stage", stageAsString())
                .add("DisplayName", displayName()).add("EnableNotification", enableNotification())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("EnvironmentVariables", environmentVariables()).add("EnableAutoBuild", enableAutoBuild())
                .add("CustomDomains", customDomains()).add("Framework", framework()).add("ActiveJobId", activeJobId())
                .add("TotalNumberOfJobs", totalNumberOfJobs()).add("EnableBasicAuth", enableBasicAuth())
                .add("ThumbnailUrl", thumbnailUrl()).add("BasicAuthCredentials", basicAuthCredentials())
                .add("BuildSpec", buildSpec()).add("Ttl", ttl()).add("AssociatedResources", associatedResources())
                .add("EnablePullRequestPreview", enablePullRequestPreview()).add("DestinationBranch", destinationBranch())
                .add("SourceBranch", sourceBranch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branchArn":
            return Optional.ofNullable(clazz.cast(branchArn()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "enableNotification":
            return Optional.ofNullable(clazz.cast(enableNotification()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "enableAutoBuild":
            return Optional.ofNullable(clazz.cast(enableAutoBuild()));
        case "customDomains":
            return Optional.ofNullable(clazz.cast(customDomains()));
        case "framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "activeJobId":
            return Optional.ofNullable(clazz.cast(activeJobId()));
        case "totalNumberOfJobs":
            return Optional.ofNullable(clazz.cast(totalNumberOfJobs()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "thumbnailUrl":
            return Optional.ofNullable(clazz.cast(thumbnailUrl()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "associatedResources":
            return Optional.ofNullable(clazz.cast(associatedResources()));
        case "enablePullRequestPreview":
            return Optional.ofNullable(clazz.cast(enablePullRequestPreview()));
        case "destinationBranch":
            return Optional.ofNullable(clazz.cast(destinationBranch()));
        case "sourceBranch":
            return Optional.ofNullable(clazz.cast(sourceBranch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Branch, T> g) {
        return obj -> g.apply((Branch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Branch> {
        /**
         * <p>
         * ARN for a branch, part of an Amplify App.
         * </p>
         * 
         * @param branchArn
         *        ARN for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchArn(String branchArn);

        /**
         * <p>
         * Name for a branch, part of an Amplify App.
         * </p>
         * 
         * @param branchName
         *        Name for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * Description for a branch, part of an Amplify App.
         * </p>
         * 
         * @param description
         *        Description for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tag for branch for Amplify App.
         * </p>
         * 
         * @param tags
         *        Tag for branch for Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Stage for a branch, part of an Amplify App.
         * </p>
         * 
         * @param stage
         *        Stage for a branch, part of an Amplify App.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Stage for a branch, part of an Amplify App.
         * </p>
         * 
         * @param stage
         *        Stage for a branch, part of an Amplify App.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * Display name for a branch, will use as the default domain prefix.
         * </p>
         * 
         * @param displayName
         *        Display name for a branch, will use as the default domain prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Enables notifications for a branch, part of an Amplify App.
         * </p>
         * 
         * @param enableNotification
         *        Enables notifications for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNotification(Boolean enableNotification);

        /**
         * <p>
         * Creation date and time for a branch, part of an Amplify App.
         * </p>
         * 
         * @param createTime
         *        Creation date and time for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Last updated date and time for a branch, part of an Amplify App.
         * </p>
         * 
         * @param updateTime
         *        Last updated date and time for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * Environment Variables specific to a branch, part of an Amplify App.
         * </p>
         * 
         * @param environmentVariables
         *        Environment Variables specific to a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Enables auto-building on push for a branch, part of an Amplify App.
         * </p>
         * 
         * @param enableAutoBuild
         *        Enables auto-building on push for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBuild(Boolean enableAutoBuild);

        /**
         * <p>
         * Custom domains for a branch, part of an Amplify App.
         * </p>
         * 
         * @param customDomains
         *        Custom domains for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomains(Collection<String> customDomains);

        /**
         * <p>
         * Custom domains for a branch, part of an Amplify App.
         * </p>
         * 
         * @param customDomains
         *        Custom domains for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomains(String... customDomains);

        /**
         * <p>
         * Framework for a branch, part of an Amplify App.
         * </p>
         * 
         * @param framework
         *        Framework for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * Id of the active job for a branch, part of an Amplify App.
         * </p>
         * 
         * @param activeJobId
         *        Id of the active job for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeJobId(String activeJobId);

        /**
         * <p>
         * Total number of Jobs part of an Amplify App.
         * </p>
         * 
         * @param totalNumberOfJobs
         *        Total number of Jobs part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfJobs(String totalNumberOfJobs);

        /**
         * <p>
         * Enables Basic Authorization for a branch, part of an Amplify App.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables Basic Authorization for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * Thumbnail URL for the branch.
         * </p>
         * 
         * @param thumbnailUrl
         *        Thumbnail URL for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailUrl(String thumbnailUrl);

        /**
         * <p>
         * Basic Authorization credentials for a branch, part of an Amplify App.
         * </p>
         * 
         * @param basicAuthCredentials
         *        Basic Authorization credentials for a branch, part of an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * BuildSpec content for branch for Amplify App.
         * </p>
         * 
         * @param buildSpec
         *        BuildSpec content for branch for Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * The content TTL for the website in seconds.
         * </p>
         * 
         * @param ttl
         *        The content TTL for the website in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(String ttl);

        /**
         * <p>
         * List of custom resources that are linked to this branch.
         * </p>
         * 
         * @param associatedResources
         *        List of custom resources that are linked to this branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(Collection<String> associatedResources);

        /**
         * <p>
         * List of custom resources that are linked to this branch.
         * </p>
         * 
         * @param associatedResources
         *        List of custom resources that are linked to this branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResources(String... associatedResources);

        /**
         * <p>
         * Enables Pull Request Preview for this branch.
         * </p>
         * 
         * @param enablePullRequestPreview
         *        Enables Pull Request Preview for this branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePullRequestPreview(Boolean enablePullRequestPreview);

        /**
         * <p>
         * The destination branch if the branch is a pull request branch.
         * </p>
         * 
         * @param destinationBranch
         *        The destination branch if the branch is a pull request branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBranch(String destinationBranch);

        /**
         * <p>
         * The source branch if the branch is a pull request branch.
         * </p>
         * 
         * @param sourceBranch
         *        The source branch if the branch is a pull request branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBranch(String sourceBranch);
    }

    static final class BuilderImpl implements Builder {
        private String branchArn;

        private String branchName;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String stage;

        private String displayName;

        private Boolean enableNotification;

        private Instant createTime;

        private Instant updateTime;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableAutoBuild;

        private List<String> customDomains = DefaultSdkAutoConstructList.getInstance();

        private String framework;

        private String activeJobId;

        private String totalNumberOfJobs;

        private Boolean enableBasicAuth;

        private String thumbnailUrl;

        private String basicAuthCredentials;

        private String buildSpec;

        private String ttl;

        private List<String> associatedResources = DefaultSdkAutoConstructList.getInstance();

        private Boolean enablePullRequestPreview;

        private String destinationBranch;

        private String sourceBranch;

        private BuilderImpl() {
        }

        private BuilderImpl(Branch model) {
            branchArn(model.branchArn);
            branchName(model.branchName);
            description(model.description);
            tags(model.tags);
            stage(model.stage);
            displayName(model.displayName);
            enableNotification(model.enableNotification);
            createTime(model.createTime);
            updateTime(model.updateTime);
            environmentVariables(model.environmentVariables);
            enableAutoBuild(model.enableAutoBuild);
            customDomains(model.customDomains);
            framework(model.framework);
            activeJobId(model.activeJobId);
            totalNumberOfJobs(model.totalNumberOfJobs);
            enableBasicAuth(model.enableBasicAuth);
            thumbnailUrl(model.thumbnailUrl);
            basicAuthCredentials(model.basicAuthCredentials);
            buildSpec(model.buildSpec);
            ttl(model.ttl);
            associatedResources(model.associatedResources);
            enablePullRequestPreview(model.enablePullRequestPreview);
            destinationBranch(model.destinationBranch);
            sourceBranch(model.sourceBranch);
        }

        public final String getBranchArn() {
            return branchArn;
        }

        @Override
        public final Builder branchArn(String branchArn) {
            this.branchArn = branchArn;
            return this;
        }

        public final void setBranchArn(String branchArn) {
            this.branchArn = branchArn;
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getStageAsString() {
            return stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableNotification() {
            return enableNotification;
        }

        @Override
        public final Builder enableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
            return this;
        }

        public final void setEnableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final Boolean getEnableAutoBuild() {
            return enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        public final Collection<String> getCustomDomains() {
            return customDomains;
        }

        @Override
        public final Builder customDomains(Collection<String> customDomains) {
            this.customDomains = CustomDomainsCopier.copy(customDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDomains(String... customDomains) {
            customDomains(Arrays.asList(customDomains));
            return this;
        }

        public final void setCustomDomains(Collection<String> customDomains) {
            this.customDomains = CustomDomainsCopier.copy(customDomains);
        }

        public final String getFramework() {
            return framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final String getActiveJobId() {
            return activeJobId;
        }

        @Override
        public final Builder activeJobId(String activeJobId) {
            this.activeJobId = activeJobId;
            return this;
        }

        public final void setActiveJobId(String activeJobId) {
            this.activeJobId = activeJobId;
        }

        public final String getTotalNumberOfJobs() {
            return totalNumberOfJobs;
        }

        @Override
        public final Builder totalNumberOfJobs(String totalNumberOfJobs) {
            this.totalNumberOfJobs = totalNumberOfJobs;
            return this;
        }

        public final void setTotalNumberOfJobs(String totalNumberOfJobs) {
            this.totalNumberOfJobs = totalNumberOfJobs;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        public final String getThumbnailUrl() {
            return thumbnailUrl;
        }

        @Override
        public final Builder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public final void setThumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        public final String getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        public final Collection<String> getAssociatedResources() {
            return associatedResources;
        }

        @Override
        public final Builder associatedResources(Collection<String> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(String... associatedResources) {
            associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        public final void setAssociatedResources(Collection<String> associatedResources) {
            this.associatedResources = AssociatedResourcesCopier.copy(associatedResources);
        }

        public final Boolean getEnablePullRequestPreview() {
            return enablePullRequestPreview;
        }

        @Override
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        public final String getDestinationBranch() {
            return destinationBranch;
        }

        @Override
        public final Builder destinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
            return this;
        }

        public final void setDestinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
        }

        public final String getSourceBranch() {
            return sourceBranch;
        }

        @Override
        public final Builder sourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
            return this;
        }

        public final void setSourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
        }

        @Override
        public Branch build() {
            return new Branch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
