/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.AdditionalConstraintsElement;
import software.amazon.awssdk.services.amplifybackend.model.ListOfAdditionalConstraintsElementCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendAuthPasswordPolicyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateBackendAuthPasswordPolicyConfig> {
    private static final SdkField<List<String>> ADDITIONAL_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalConstraints").getter(CreateBackendAuthPasswordPolicyConfig.getter(CreateBackendAuthPasswordPolicyConfig::additionalConstraintsAsStrings)).setter(CreateBackendAuthPasswordPolicyConfig.setter(Builder::additionalConstraintsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> MINIMUM_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinimumLength").getter(CreateBackendAuthPasswordPolicyConfig.getter(CreateBackendAuthPasswordPolicyConfig::minimumLength)).setter(CreateBackendAuthPasswordPolicyConfig.setter(Builder::minimumLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_CONSTRAINTS_FIELD, MINIMUM_LENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> additionalConstraints;
    private final Double minimumLength;

    private CreateBackendAuthPasswordPolicyConfig(BuilderImpl builder) {
        this.additionalConstraints = builder.additionalConstraints;
        this.minimumLength = builder.minimumLength;
    }

    public List<AdditionalConstraintsElement> additionalConstraints() {
        return ListOfAdditionalConstraintsElementCopier.copyStringToEnum(this.additionalConstraints);
    }

    public boolean hasAdditionalConstraints() {
        return this.additionalConstraints != null && !(this.additionalConstraints instanceof SdkAutoConstructList);
    }

    public List<String> additionalConstraintsAsStrings() {
        return this.additionalConstraints;
    }

    public Double minimumLength() {
        return this.minimumLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalConstraints() ? this.additionalConstraintsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthPasswordPolicyConfig)) {
            return false;
        }
        CreateBackendAuthPasswordPolicyConfig other = (CreateBackendAuthPasswordPolicyConfig)obj;
        return this.hasAdditionalConstraints() == other.hasAdditionalConstraints() && Objects.equals(this.additionalConstraintsAsStrings(), other.additionalConstraintsAsStrings()) && Objects.equals(this.minimumLength(), other.minimumLength());
    }

    public String toString() {
        return ToString.builder((String)"CreateBackendAuthPasswordPolicyConfig").add("AdditionalConstraints", this.hasAdditionalConstraints() ? this.additionalConstraintsAsStrings() : null).add("MinimumLength", (Object)this.minimumLength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalConstraints": {
                return Optional.ofNullable(clazz.cast(this.additionalConstraintsAsStrings()));
            }
            case "MinimumLength": {
                return Optional.ofNullable(clazz.cast(this.minimumLength()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthPasswordPolicyConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthPasswordPolicyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> additionalConstraints = DefaultSdkAutoConstructList.getInstance();
        private Double minimumLength;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthPasswordPolicyConfig model) {
            this.additionalConstraintsWithStrings(model.additionalConstraints);
            this.minimumLength(model.minimumLength);
        }

        public final Collection<String> getAdditionalConstraints() {
            if (this.additionalConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalConstraints;
        }

        @Override
        public final Builder additionalConstraintsWithStrings(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConstraintsWithStrings(String ... additionalConstraints) {
            this.additionalConstraintsWithStrings(Arrays.asList(additionalConstraints));
            return this;
        }

        @Override
        public final Builder additionalConstraints(Collection<AdditionalConstraintsElement> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copyEnumToString(additionalConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConstraints(AdditionalConstraintsElement ... additionalConstraints) {
            this.additionalConstraints(Arrays.asList(additionalConstraints));
            return this;
        }

        public final void setAdditionalConstraints(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
        }

        public final Double getMinimumLength() {
            return this.minimumLength;
        }

        @Override
        public final Builder minimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public final void setMinimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
        }

        public CreateBackendAuthPasswordPolicyConfig build() {
            return new CreateBackendAuthPasswordPolicyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateBackendAuthPasswordPolicyConfig> {
        public Builder additionalConstraintsWithStrings(Collection<String> var1);

        public Builder additionalConstraintsWithStrings(String ... var1);

        public Builder additionalConstraints(Collection<AdditionalConstraintsElement> var1);

        public Builder additionalConstraints(AdditionalConstraintsElement ... var1);

        public Builder minimumLength(Double var1);
    }
}

