/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.BackendAPIAuthType;
import software.amazon.awssdk.services.amplifybackend.model.BackendAPIConflictResolution;
import software.amazon.awssdk.services.amplifybackend.model.ListOfBackendAPIAuthTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackendAPIResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackendAPIResourceConfig> {
    private static final SdkField<List<BackendAPIAuthType>> ADDITIONAL_AUTH_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalAuthTypes").getter(BackendAPIResourceConfig.getter(BackendAPIResourceConfig::additionalAuthTypes)).setter(BackendAPIResourceConfig.setter(Builder::additionalAuthTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackendAPIAuthType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> API_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiName").getter(BackendAPIResourceConfig.getter(BackendAPIResourceConfig::apiName)).setter(BackendAPIResourceConfig.setter(Builder::apiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiName").build()}).build();
    private static final SdkField<BackendAPIConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConflictResolution").getter(BackendAPIResourceConfig.getter(BackendAPIResourceConfig::conflictResolution)).setter(BackendAPIResourceConfig.setter(Builder::conflictResolution)).constructor(BackendAPIConflictResolution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolution").build()}).build();
    private static final SdkField<BackendAPIAuthType> DEFAULT_AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultAuthType").getter(BackendAPIResourceConfig.getter(BackendAPIResourceConfig::defaultAuthType)).setter(BackendAPIResourceConfig.setter(Builder::defaultAuthType)).constructor(BackendAPIAuthType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAuthType").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(BackendAPIResourceConfig.getter(BackendAPIResourceConfig::service)).setter(BackendAPIResourceConfig.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> TRANSFORM_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformSchema").getter(BackendAPIResourceConfig.getter(BackendAPIResourceConfig::transformSchema)).setter(BackendAPIResourceConfig.setter(Builder::transformSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_AUTH_TYPES_FIELD, API_NAME_FIELD, CONFLICT_RESOLUTION_FIELD, DEFAULT_AUTH_TYPE_FIELD, SERVICE_FIELD, TRANSFORM_SCHEMA_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<BackendAPIAuthType> additionalAuthTypes;
    private final String apiName;
    private final BackendAPIConflictResolution conflictResolution;
    private final BackendAPIAuthType defaultAuthType;
    private final String service;
    private final String transformSchema;

    private BackendAPIResourceConfig(BuilderImpl builder) {
        this.additionalAuthTypes = builder.additionalAuthTypes;
        this.apiName = builder.apiName;
        this.conflictResolution = builder.conflictResolution;
        this.defaultAuthType = builder.defaultAuthType;
        this.service = builder.service;
        this.transformSchema = builder.transformSchema;
    }

    public boolean hasAdditionalAuthTypes() {
        return this.additionalAuthTypes != null && !(this.additionalAuthTypes instanceof SdkAutoConstructList);
    }

    public List<BackendAPIAuthType> additionalAuthTypes() {
        return this.additionalAuthTypes;
    }

    public String apiName() {
        return this.apiName;
    }

    public BackendAPIConflictResolution conflictResolution() {
        return this.conflictResolution;
    }

    public BackendAPIAuthType defaultAuthType() {
        return this.defaultAuthType;
    }

    public String service() {
        return this.service;
    }

    public String transformSchema() {
        return this.transformSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAuthTypes() ? this.additionalAuthTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.apiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAuthType());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformSchema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendAPIResourceConfig)) {
            return false;
        }
        BackendAPIResourceConfig other = (BackendAPIResourceConfig)obj;
        return this.hasAdditionalAuthTypes() == other.hasAdditionalAuthTypes() && Objects.equals(this.additionalAuthTypes(), other.additionalAuthTypes()) && Objects.equals(this.apiName(), other.apiName()) && Objects.equals(this.conflictResolution(), other.conflictResolution()) && Objects.equals(this.defaultAuthType(), other.defaultAuthType()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.transformSchema(), other.transformSchema());
    }

    public String toString() {
        return ToString.builder((String)"BackendAPIResourceConfig").add("AdditionalAuthTypes", this.hasAdditionalAuthTypes() ? this.additionalAuthTypes() : null).add("ApiName", (Object)this.apiName()).add("ConflictResolution", (Object)this.conflictResolution()).add("DefaultAuthType", (Object)this.defaultAuthType()).add("Service", (Object)this.service()).add("TransformSchema", (Object)this.transformSchema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalAuthTypes": {
                return Optional.ofNullable(clazz.cast(this.additionalAuthTypes()));
            }
            case "ApiName": {
                return Optional.ofNullable(clazz.cast(this.apiName()));
            }
            case "ConflictResolution": {
                return Optional.ofNullable(clazz.cast(this.conflictResolution()));
            }
            case "DefaultAuthType": {
                return Optional.ofNullable(clazz.cast(this.defaultAuthType()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "TransformSchema": {
                return Optional.ofNullable(clazz.cast(this.transformSchema()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendAPIResourceConfig, T> g) {
        return obj -> g.apply((BackendAPIResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BackendAPIAuthType> additionalAuthTypes = DefaultSdkAutoConstructList.getInstance();
        private String apiName;
        private BackendAPIConflictResolution conflictResolution;
        private BackendAPIAuthType defaultAuthType;
        private String service;
        private String transformSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendAPIResourceConfig model) {
            this.additionalAuthTypes(model.additionalAuthTypes);
            this.apiName(model.apiName);
            this.conflictResolution(model.conflictResolution);
            this.defaultAuthType(model.defaultAuthType);
            this.service(model.service);
            this.transformSchema(model.transformSchema);
        }

        public final Collection<BackendAPIAuthType.Builder> getAdditionalAuthTypes() {
            if (this.additionalAuthTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalAuthTypes != null ? (Collection)this.additionalAuthTypes.stream().map(BackendAPIAuthType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAuthTypes(Collection<BackendAPIAuthType> additionalAuthTypes) {
            this.additionalAuthTypes = ListOfBackendAPIAuthTypeCopier.copy(additionalAuthTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthTypes(BackendAPIAuthType ... additionalAuthTypes) {
            this.additionalAuthTypes(Arrays.asList(additionalAuthTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthTypes(Consumer<BackendAPIAuthType.Builder> ... additionalAuthTypes) {
            this.additionalAuthTypes(Stream.of(additionalAuthTypes).map(c -> (BackendAPIAuthType)((BackendAPIAuthType.Builder)BackendAPIAuthType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAuthTypes(Collection<BackendAPIAuthType.BuilderImpl> additionalAuthTypes) {
            this.additionalAuthTypes = ListOfBackendAPIAuthTypeCopier.copyFromBuilder(additionalAuthTypes);
        }

        public final String getApiName() {
            return this.apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        public final BackendAPIConflictResolution.Builder getConflictResolution() {
            return this.conflictResolution != null ? this.conflictResolution.toBuilder() : null;
        }

        @Override
        public final Builder conflictResolution(BackendAPIConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final void setConflictResolution(BackendAPIConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        public final BackendAPIAuthType.Builder getDefaultAuthType() {
            return this.defaultAuthType != null ? this.defaultAuthType.toBuilder() : null;
        }

        @Override
        public final Builder defaultAuthType(BackendAPIAuthType defaultAuthType) {
            this.defaultAuthType = defaultAuthType;
            return this;
        }

        public final void setDefaultAuthType(BackendAPIAuthType.BuilderImpl defaultAuthType) {
            this.defaultAuthType = defaultAuthType != null ? defaultAuthType.build() : null;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getTransformSchema() {
            return this.transformSchema;
        }

        @Override
        public final Builder transformSchema(String transformSchema) {
            this.transformSchema = transformSchema;
            return this;
        }

        public final void setTransformSchema(String transformSchema) {
            this.transformSchema = transformSchema;
        }

        public BackendAPIResourceConfig build() {
            return new BackendAPIResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackendAPIResourceConfig> {
        public Builder additionalAuthTypes(Collection<BackendAPIAuthType> var1);

        public Builder additionalAuthTypes(BackendAPIAuthType ... var1);

        public Builder additionalAuthTypes(Consumer<BackendAPIAuthType.Builder> ... var1);

        public Builder apiName(String var1);

        public Builder conflictResolution(BackendAPIConflictResolution var1);

        default public Builder conflictResolution(Consumer<BackendAPIConflictResolution.Builder> conflictResolution) {
            return this.conflictResolution((BackendAPIConflictResolution)((BackendAPIConflictResolution.Builder)BackendAPIConflictResolution.builder().applyMutation(conflictResolution)).build());
        }

        public Builder defaultAuthType(BackendAPIAuthType var1);

        default public Builder defaultAuthType(Consumer<BackendAPIAuthType.Builder> defaultAuthType) {
            return this.defaultAuthType((BackendAPIAuthType)((BackendAPIAuthType.Builder)BackendAPIAuthType.builder().applyMutation(defaultAuthType)).build());
        }

        public Builder service(String var1);

        public Builder transformSchema(String var1);
    }
}

