/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.MFAMode;
import software.amazon.awssdk.services.amplifybackend.model.Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBackendAuthMFAConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateBackendAuthMFAConfig> {
    private static final SdkField<String> MFA_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MFAMode").getter(UpdateBackendAuthMFAConfig.getter(UpdateBackendAuthMFAConfig::mfaModeAsString)).setter(UpdateBackendAuthMFAConfig.setter(Builder::mfaMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAMode").build()}).build();
    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(UpdateBackendAuthMFAConfig.getter(UpdateBackendAuthMFAConfig::settings)).setter(UpdateBackendAuthMFAConfig.setter(Builder::settings)).constructor(Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MFA_MODE_FIELD, SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mfaMode;
    private final Settings settings;

    private UpdateBackendAuthMFAConfig(BuilderImpl builder) {
        this.mfaMode = builder.mfaMode;
        this.settings = builder.settings;
    }

    public MFAMode mfaMode() {
        return MFAMode.fromValue(this.mfaMode);
    }

    public String mfaModeAsString() {
        return this.mfaMode;
    }

    public Settings settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthMFAConfig)) {
            return false;
        }
        UpdateBackendAuthMFAConfig other = (UpdateBackendAuthMFAConfig)obj;
        return Objects.equals(this.mfaModeAsString(), other.mfaModeAsString()) && Objects.equals(this.settings(), other.settings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBackendAuthMFAConfig").add("MFAMode", (Object)this.mfaModeAsString()).add("Settings", (Object)this.settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MFAMode": {
                return Optional.ofNullable(clazz.cast(this.mfaModeAsString()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthMFAConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthMFAConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mfaMode;
        private Settings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthMFAConfig model) {
            this.mfaMode(model.mfaMode);
            this.settings(model.settings);
        }

        public final String getMfaMode() {
            return this.mfaMode;
        }

        @Override
        public final Builder mfaMode(String mfaMode) {
            this.mfaMode = mfaMode;
            return this;
        }

        @Override
        public final Builder mfaMode(MFAMode mfaMode) {
            this.mfaMode(mfaMode == null ? null : mfaMode.toString());
            return this;
        }

        public final void setMfaMode(String mfaMode) {
            this.mfaMode = mfaMode;
        }

        public final Settings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public UpdateBackendAuthMFAConfig build() {
            return new UpdateBackendAuthMFAConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateBackendAuthMFAConfig> {
        public Builder mfaMode(String var1);

        public Builder mfaMode(MFAMode var1);

        public Builder settings(Settings var1);

        default public Builder settings(Consumer<Settings.Builder> settings) {
            return this.settings((Settings)((Settings.Builder)Settings.builder().applyMutation(settings)).build());
        }
    }
}

