/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The password policy configuration for the backend of your Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackendAuthPasswordPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateBackendAuthPasswordPolicyConfig.Builder, CreateBackendAuthPasswordPolicyConfig> {
    private static final SdkField<List<String>> ADDITIONAL_CONSTRAINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalConstraints")
            .getter(getter(CreateBackendAuthPasswordPolicyConfig::additionalConstraintsAsStrings))
            .setter(setter(Builder::additionalConstraintsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> MINIMUM_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinimumLength").getter(getter(CreateBackendAuthPasswordPolicyConfig::minimumLength))
            .setter(setter(Builder::minimumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_CONSTRAINTS_FIELD,
            MINIMUM_LENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> additionalConstraints;

    private final Double minimumLength;

    private CreateBackendAuthPasswordPolicyConfig(BuilderImpl builder) {
        this.additionalConstraints = builder.additionalConstraints;
        this.minimumLength = builder.minimumLength;
    }

    /**
     * <p>
     * Additional constraints for the password used to access the backend of your Amplify project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalConstraints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional constraints for the password used to access the backend of your Amplify project.
     */
    public final List<AdditionalConstraintsElement> additionalConstraints() {
        return ListOfAdditionalConstraintsElementCopier.copyStringToEnum(additionalConstraints);
    }

    /**
     * Returns true if the AdditionalConstraints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAdditionalConstraints() {
        return additionalConstraints != null && !(additionalConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional constraints for the password used to access the backend of your Amplify project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalConstraints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional constraints for the password used to access the backend of your Amplify project.
     */
    public final List<String> additionalConstraintsAsStrings() {
        return additionalConstraints;
    }

    /**
     * <p>
     * The minimum length of the password used to access the backend of your Amplify project.
     * </p>
     * 
     * @return The minimum length of the password used to access the backend of your Amplify project.
     */
    public final Double minimumLength() {
        return minimumLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalConstraints() ? additionalConstraintsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minimumLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthPasswordPolicyConfig)) {
            return false;
        }
        CreateBackendAuthPasswordPolicyConfig other = (CreateBackendAuthPasswordPolicyConfig) obj;
        return hasAdditionalConstraints() == other.hasAdditionalConstraints()
                && Objects.equals(additionalConstraintsAsStrings(), other.additionalConstraintsAsStrings())
                && Objects.equals(minimumLength(), other.minimumLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackendAuthPasswordPolicyConfig")
                .add("AdditionalConstraints", hasAdditionalConstraints() ? additionalConstraintsAsStrings() : null)
                .add("MinimumLength", minimumLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalConstraints":
            return Optional.ofNullable(clazz.cast(additionalConstraintsAsStrings()));
        case "MinimumLength":
            return Optional.ofNullable(clazz.cast(minimumLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthPasswordPolicyConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthPasswordPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateBackendAuthPasswordPolicyConfig> {
        /**
         * <p>
         * Additional constraints for the password used to access the backend of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Additional constraints for the password used to access the backend of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraintsWithStrings(Collection<String> additionalConstraints);

        /**
         * <p>
         * Additional constraints for the password used to access the backend of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Additional constraints for the password used to access the backend of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraintsWithStrings(String... additionalConstraints);

        /**
         * <p>
         * Additional constraints for the password used to access the backend of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Additional constraints for the password used to access the backend of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraints(Collection<AdditionalConstraintsElement> additionalConstraints);

        /**
         * <p>
         * Additional constraints for the password used to access the backend of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Additional constraints for the password used to access the backend of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraints(AdditionalConstraintsElement... additionalConstraints);

        /**
         * <p>
         * The minimum length of the password used to access the backend of your Amplify project.
         * </p>
         * 
         * @param minimumLength
         *        The minimum length of the password used to access the backend of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLength(Double minimumLength);
    }

    static final class BuilderImpl implements Builder {
        private List<String> additionalConstraints = DefaultSdkAutoConstructList.getInstance();

        private Double minimumLength;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthPasswordPolicyConfig model) {
            additionalConstraintsWithStrings(model.additionalConstraints);
            minimumLength(model.minimumLength);
        }

        public final Collection<String> getAdditionalConstraints() {
            if (additionalConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalConstraints;
        }

        @Override
        public final Builder additionalConstraintsWithStrings(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConstraintsWithStrings(String... additionalConstraints) {
            additionalConstraintsWithStrings(Arrays.asList(additionalConstraints));
            return this;
        }

        @Override
        public final Builder additionalConstraints(Collection<AdditionalConstraintsElement> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copyEnumToString(additionalConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConstraints(AdditionalConstraintsElement... additionalConstraints) {
            additionalConstraints(Arrays.asList(additionalConstraints));
            return this;
        }

        public final void setAdditionalConstraints(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
        }

        public final Double getMinimumLength() {
            return minimumLength;
        }

        @Override
        public final Builder minimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public final void setMinimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
        }

        @Override
        public CreateBackendAuthPasswordPolicyConfig build() {
            return new CreateBackendAuthPasswordPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
