/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.LoginAuthConfigReqObj;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBackendConfigResponse
extends AmplifyBackendResponse
implements ToCopyableBuilder<Builder, UpdateBackendConfigResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(UpdateBackendConfigResponse.getter(UpdateBackendConfigResponse::appId)).setter(UpdateBackendConfigResponse.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> BACKEND_MANAGER_APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackendManagerAppId").getter(UpdateBackendConfigResponse.getter(UpdateBackendConfigResponse::backendManagerAppId)).setter(UpdateBackendConfigResponse.setter(Builder::backendManagerAppId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendManagerAppId").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(UpdateBackendConfigResponse.getter(UpdateBackendConfigResponse::error)).setter(UpdateBackendConfigResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<LoginAuthConfigReqObj> LOGIN_AUTH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoginAuthConfig").getter(UpdateBackendConfigResponse.getter(UpdateBackendConfigResponse::loginAuthConfig)).setter(UpdateBackendConfigResponse.setter(Builder::loginAuthConfig)).constructor(LoginAuthConfigReqObj::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loginAuthConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BACKEND_MANAGER_APP_ID_FIELD, ERROR_FIELD, LOGIN_AUTH_CONFIG_FIELD));
    private final String appId;
    private final String backendManagerAppId;
    private final String error;
    private final LoginAuthConfigReqObj loginAuthConfig;

    private UpdateBackendConfigResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendManagerAppId = builder.backendManagerAppId;
        this.error = builder.error;
        this.loginAuthConfig = builder.loginAuthConfig;
    }

    public final String appId() {
        return this.appId;
    }

    public final String backendManagerAppId() {
        return this.backendManagerAppId;
    }

    public final String error() {
        return this.error;
    }

    public final LoginAuthConfigReqObj loginAuthConfig() {
        return this.loginAuthConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendManagerAppId());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.loginAuthConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendConfigResponse)) {
            return false;
        }
        UpdateBackendConfigResponse other = (UpdateBackendConfigResponse)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.backendManagerAppId(), other.backendManagerAppId()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.loginAuthConfig(), other.loginAuthConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBackendConfigResponse").add("AppId", (Object)this.appId()).add("BackendManagerAppId", (Object)this.backendManagerAppId()).add("Error", (Object)this.error()).add("LoginAuthConfig", (Object)this.loginAuthConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "BackendManagerAppId": {
                return Optional.ofNullable(clazz.cast(this.backendManagerAppId()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "LoginAuthConfig": {
                return Optional.ofNullable(clazz.cast(this.loginAuthConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendConfigResponse, T> g) {
        return obj -> g.apply((UpdateBackendConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendResponse.BuilderImpl
    implements Builder {
        private String appId;
        private String backendManagerAppId;
        private String error;
        private LoginAuthConfigReqObj loginAuthConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendConfigResponse model) {
            super(model);
            this.appId(model.appId);
            this.backendManagerAppId(model.backendManagerAppId);
            this.error(model.error);
            this.loginAuthConfig(model.loginAuthConfig);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getBackendManagerAppId() {
            return this.backendManagerAppId;
        }

        @Override
        public final Builder backendManagerAppId(String backendManagerAppId) {
            this.backendManagerAppId = backendManagerAppId;
            return this;
        }

        public final void setBackendManagerAppId(String backendManagerAppId) {
            this.backendManagerAppId = backendManagerAppId;
        }

        public final String getError() {
            return this.error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final LoginAuthConfigReqObj.Builder getLoginAuthConfig() {
            return this.loginAuthConfig != null ? this.loginAuthConfig.toBuilder() : null;
        }

        @Override
        public final Builder loginAuthConfig(LoginAuthConfigReqObj loginAuthConfig) {
            this.loginAuthConfig = loginAuthConfig;
            return this;
        }

        public final void setLoginAuthConfig(LoginAuthConfigReqObj.BuilderImpl loginAuthConfig) {
            this.loginAuthConfig = loginAuthConfig != null ? loginAuthConfig.build() : null;
        }

        @Override
        public UpdateBackendConfigResponse build() {
            return new UpdateBackendConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyBackendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBackendConfigResponse> {
        public Builder appId(String var1);

        public Builder backendManagerAppId(String var1);

        public Builder error(String var1);

        public Builder loginAuthConfig(LoginAuthConfigReqObj var1);

        default public Builder loginAuthConfig(Consumer<LoginAuthConfigReqObj.Builder> loginAuthConfig) {
            return this.loginAuthConfig((LoginAuthConfigReqObj)((LoginAuthConfigReqObj.Builder)LoginAuthConfigReqObj.builder().applyMutation(loginAuthConfig)).build());
        }
    }
}

