/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportBackendAuthRequest
extends AmplifyBackendRequest
implements ToCopyableBuilder<Builder, ImportBackendAuthRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(ImportBackendAuthRequest.getter(ImportBackendAuthRequest::appId)).setter(ImportBackendAuthRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackendEnvironmentName").getter(ImportBackendAuthRequest.getter(ImportBackendAuthRequest::backendEnvironmentName)).setter(ImportBackendAuthRequest.setter(Builder::backendEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backendEnvironmentName").build()}).build();
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(ImportBackendAuthRequest.getter(ImportBackendAuthRequest::identityPoolId)).setter(ImportBackendAuthRequest.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityPoolId").build()}).build();
    private static final SdkField<String> NATIVE_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NativeClientId").getter(ImportBackendAuthRequest.getter(ImportBackendAuthRequest::nativeClientId)).setter(ImportBackendAuthRequest.setter(Builder::nativeClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nativeClientId").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(ImportBackendAuthRequest.getter(ImportBackendAuthRequest::userPoolId)).setter(ImportBackendAuthRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolId").build()}).build();
    private static final SdkField<String> WEB_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebClientId").getter(ImportBackendAuthRequest.getter(ImportBackendAuthRequest::webClientId)).setter(ImportBackendAuthRequest.setter(Builder::webClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webClientId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BACKEND_ENVIRONMENT_NAME_FIELD, IDENTITY_POOL_ID_FIELD, NATIVE_CLIENT_ID_FIELD, USER_POOL_ID_FIELD, WEB_CLIENT_ID_FIELD));
    private final String appId;
    private final String backendEnvironmentName;
    private final String identityPoolId;
    private final String nativeClientId;
    private final String userPoolId;
    private final String webClientId;

    private ImportBackendAuthRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.identityPoolId = builder.identityPoolId;
        this.nativeClientId = builder.nativeClientId;
        this.userPoolId = builder.userPoolId;
        this.webClientId = builder.webClientId;
    }

    public final String appId() {
        return this.appId;
    }

    public final String backendEnvironmentName() {
        return this.backendEnvironmentName;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final String nativeClientId() {
        return this.nativeClientId;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String webClientId() {
        return this.webClientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nativeClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.webClientId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportBackendAuthRequest)) {
            return false;
        }
        ImportBackendAuthRequest other = (ImportBackendAuthRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.backendEnvironmentName(), other.backendEnvironmentName()) && Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.nativeClientId(), other.nativeClientId()) && Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.webClientId(), other.webClientId());
    }

    public final String toString() {
        return ToString.builder((String)"ImportBackendAuthRequest").add("AppId", (Object)this.appId()).add("BackendEnvironmentName", (Object)this.backendEnvironmentName()).add("IdentityPoolId", (Object)this.identityPoolId()).add("NativeClientId", (Object)this.nativeClientId()).add("UserPoolId", (Object)this.userPoolId()).add("WebClientId", (Object)this.webClientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "BackendEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentName()));
            }
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "NativeClientId": {
                return Optional.ofNullable(clazz.cast(this.nativeClientId()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "WebClientId": {
                return Optional.ofNullable(clazz.cast(this.webClientId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportBackendAuthRequest, T> g) {
        return obj -> g.apply((ImportBackendAuthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String backendEnvironmentName;
        private String identityPoolId;
        private String nativeClientId;
        private String userPoolId;
        private String webClientId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportBackendAuthRequest model) {
            super(model);
            this.appId(model.appId);
            this.backendEnvironmentName(model.backendEnvironmentName);
            this.identityPoolId(model.identityPoolId);
            this.nativeClientId(model.nativeClientId);
            this.userPoolId(model.userPoolId);
            this.webClientId(model.webClientId);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getBackendEnvironmentName() {
            return this.backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getNativeClientId() {
            return this.nativeClientId;
        }

        @Override
        public final Builder nativeClientId(String nativeClientId) {
            this.nativeClientId = nativeClientId;
            return this;
        }

        public final void setNativeClientId(String nativeClientId) {
            this.nativeClientId = nativeClientId;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getWebClientId() {
            return this.webClientId;
        }

        @Override
        public final Builder webClientId(String webClientId) {
            this.webClientId = webClientId;
            return this;
        }

        public final void setWebClientId(String webClientId) {
            this.webClientId = webClientId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportBackendAuthRequest build() {
            return new ImportBackendAuthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyBackendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportBackendAuthRequest> {
        public Builder appId(String var1);

        public Builder backendEnvironmentName(String var1);

        public Builder identityPoolId(String var1);

        public Builder nativeClientId(String var1);

        public Builder userPoolId(String var1);

        public Builder webClientId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

