/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendConfigResponse extends AmplifyBackendResponse implements
        ToCopyableBuilder<UpdateBackendConfigResponse.Builder, UpdateBackendConfigResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(UpdateBackendConfigResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> BACKEND_MANAGER_APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackendManagerAppId").getter(getter(UpdateBackendConfigResponse::backendManagerAppId))
            .setter(setter(Builder::backendManagerAppId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendManagerAppId").build())
            .build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(UpdateBackendConfigResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<LoginAuthConfigReqObj> LOGIN_AUTH_CONFIG_FIELD = SdkField
            .<LoginAuthConfigReqObj> builder(MarshallingType.SDK_POJO).memberName("LoginAuthConfig")
            .getter(getter(UpdateBackendConfigResponse::loginAuthConfig)).setter(setter(Builder::loginAuthConfig))
            .constructor(LoginAuthConfigReqObj::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loginAuthConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BACKEND_MANAGER_APP_ID_FIELD, ERROR_FIELD, LOGIN_AUTH_CONFIG_FIELD));

    private final String appId;

    private final String backendManagerAppId;

    private final String error;

    private final LoginAuthConfigReqObj loginAuthConfig;

    private UpdateBackendConfigResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendManagerAppId = builder.backendManagerAppId;
        this.error = builder.error;
        this.loginAuthConfig = builder.loginAuthConfig;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The app ID for the backend manager.
     * </p>
     * 
     * @return The app ID for the backend manager.
     */
    public final String backendManagerAppId() {
        return backendManagerAppId;
    }

    /**
     * <p>
     * If the request fails, this error is returned.
     * </p>
     * 
     * @return If the request fails, this error is returned.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.
     * </p>
     * 
     * @return Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.
     */
    public final LoginAuthConfigReqObj loginAuthConfig() {
        return loginAuthConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(backendManagerAppId());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(loginAuthConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendConfigResponse)) {
            return false;
        }
        UpdateBackendConfigResponse other = (UpdateBackendConfigResponse) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(backendManagerAppId(), other.backendManagerAppId())
                && Objects.equals(error(), other.error()) && Objects.equals(loginAuthConfig(), other.loginAuthConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendConfigResponse").add("AppId", appId())
                .add("BackendManagerAppId", backendManagerAppId()).add("Error", error())
                .add("LoginAuthConfig", loginAuthConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "BackendManagerAppId":
            return Optional.ofNullable(clazz.cast(backendManagerAppId()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "LoginAuthConfig":
            return Optional.ofNullable(clazz.cast(loginAuthConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendConfigResponse, T> g) {
        return obj -> g.apply((UpdateBackendConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyBackendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBackendConfigResponse> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The app ID for the backend manager.
         * </p>
         * 
         * @param backendManagerAppId
         *        The app ID for the backend manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendManagerAppId(String backendManagerAppId);

        /**
         * <p>
         * If the request fails, this error is returned.
         * </p>
         * 
         * @param error
         *        If the request fails, this error is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.
         * </p>
         * 
         * @param loginAuthConfig
         *        Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginAuthConfig(LoginAuthConfigReqObj loginAuthConfig);

        /**
         * <p>
         * Describes the Amazon Cognito configurations for the Admin UI auth resource to log in with.
         * </p>
         * This is a convenience that creates an instance of the {@link LoginAuthConfigReqObj.Builder} avoiding the need
         * to create one manually via {@link LoginAuthConfigReqObj#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoginAuthConfigReqObj.Builder#build()} is called immediately and
         * its result is passed to {@link #loginAuthConfig(LoginAuthConfigReqObj)}.
         * 
         * @param loginAuthConfig
         *        a consumer that will call methods on {@link LoginAuthConfigReqObj.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loginAuthConfig(LoginAuthConfigReqObj)
         */
        default Builder loginAuthConfig(Consumer<LoginAuthConfigReqObj.Builder> loginAuthConfig) {
            return loginAuthConfig(LoginAuthConfigReqObj.builder().applyMutation(loginAuthConfig).build());
        }
    }

    static final class BuilderImpl extends AmplifyBackendResponse.BuilderImpl implements Builder {
        private String appId;

        private String backendManagerAppId;

        private String error;

        private LoginAuthConfigReqObj loginAuthConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendConfigResponse model) {
            super(model);
            appId(model.appId);
            backendManagerAppId(model.backendManagerAppId);
            error(model.error);
            loginAuthConfig(model.loginAuthConfig);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendManagerAppId() {
            return backendManagerAppId;
        }

        public final void setBackendManagerAppId(String backendManagerAppId) {
            this.backendManagerAppId = backendManagerAppId;
        }

        @Override
        @Transient
        public final Builder backendManagerAppId(String backendManagerAppId) {
            this.backendManagerAppId = backendManagerAppId;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        @Transient
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final LoginAuthConfigReqObj.Builder getLoginAuthConfig() {
            return loginAuthConfig != null ? loginAuthConfig.toBuilder() : null;
        }

        public final void setLoginAuthConfig(LoginAuthConfigReqObj.BuilderImpl loginAuthConfig) {
            this.loginAuthConfig = loginAuthConfig != null ? loginAuthConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder loginAuthConfig(LoginAuthConfigReqObj loginAuthConfig) {
            this.loginAuthConfig = loginAuthConfig;
            return this;
        }

        @Override
        public UpdateBackendConfigResponse build() {
            return new UpdateBackendConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
