/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.BackendAPIAppSyncAuthSettings;
import software.amazon.awssdk.services.amplifybackend.model.Mode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackendAPIAuthType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackendAPIAuthType> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(BackendAPIAuthType.getter(BackendAPIAuthType::modeAsString)).setter(BackendAPIAuthType.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<BackendAPIAppSyncAuthSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(BackendAPIAuthType.getter(BackendAPIAuthType::settings)).setter(BackendAPIAuthType.setter(Builder::settings)).constructor(BackendAPIAppSyncAuthSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final BackendAPIAppSyncAuthSettings settings;

    private BackendAPIAuthType(BuilderImpl builder) {
        this.mode = builder.mode;
        this.settings = builder.settings;
    }

    public final Mode mode() {
        return Mode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final BackendAPIAppSyncAuthSettings settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendAPIAuthType)) {
            return false;
        }
        BackendAPIAuthType other = (BackendAPIAuthType)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"BackendAPIAuthType").add("Mode", (Object)this.modeAsString()).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendAPIAuthType, T> g) {
        return obj -> g.apply((BackendAPIAuthType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private BackendAPIAppSyncAuthSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendAPIAuthType model) {
            this.mode(model.mode);
            this.settings(model.settings);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        @Transient
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        @Transient
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final BackendAPIAppSyncAuthSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(BackendAPIAppSyncAuthSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(BackendAPIAppSyncAuthSettings settings) {
            this.settings = settings;
            return this;
        }

        public BackendAPIAuthType build() {
            return new BackendAPIAuthType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackendAPIAuthType> {
        public Builder mode(String var1);

        public Builder mode(Mode var1);

        public Builder settings(BackendAPIAppSyncAuthSettings var1);

        default public Builder settings(Consumer<BackendAPIAppSyncAuthSettings.Builder> settings) {
            return this.settings((BackendAPIAppSyncAuthSettings)((BackendAPIAppSyncAuthSettings.Builder)BackendAPIAppSyncAuthSettings.builder().applyMutation(settings)).build());
        }
    }
}

