/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTokenResponse
extends AmplifyBackendResponse
implements ToCopyableBuilder<Builder, CreateTokenResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(CreateTokenResponse.getter(CreateTokenResponse::appId)).setter(CreateTokenResponse.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> CHALLENGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChallengeCode").getter(CreateTokenResponse.getter(CreateTokenResponse::challengeCode)).setter(CreateTokenResponse.setter(Builder::challengeCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("challengeCode").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(CreateTokenResponse.getter(CreateTokenResponse::sessionId)).setter(CreateTokenResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ttl").getter(CreateTokenResponse.getter(CreateTokenResponse::ttl)).setter(CreateTokenResponse.setter(Builder::ttl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, CHALLENGE_CODE_FIELD, SESSION_ID_FIELD, TTL_FIELD));
    private final String appId;
    private final String challengeCode;
    private final String sessionId;
    private final String ttl;

    private CreateTokenResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.challengeCode = builder.challengeCode;
        this.sessionId = builder.sessionId;
        this.ttl = builder.ttl;
    }

    public final String appId() {
        return this.appId;
    }

    public final String challengeCode() {
        return this.challengeCode;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String ttl() {
        return this.ttl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenResponse)) {
            return false;
        }
        CreateTokenResponse other = (CreateTokenResponse)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.challengeCode(), other.challengeCode()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.ttl(), other.ttl());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTokenResponse").add("AppId", (Object)this.appId()).add("ChallengeCode", (Object)this.challengeCode()).add("SessionId", (Object)this.sessionId()).add("Ttl", (Object)this.ttl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "ChallengeCode": {
                return Optional.ofNullable(clazz.cast(this.challengeCode()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Ttl": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenResponse, T> g) {
        return obj -> g.apply((CreateTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendResponse.BuilderImpl
    implements Builder {
        private String appId;
        private String challengeCode;
        private String sessionId;
        private String ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenResponse model) {
            super(model);
            this.appId(model.appId);
            this.challengeCode(model.challengeCode);
            this.sessionId(model.sessionId);
            this.ttl(model.ttl);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getChallengeCode() {
            return this.challengeCode;
        }

        public final void setChallengeCode(String challengeCode) {
            this.challengeCode = challengeCode;
        }

        @Override
        @Transient
        public final Builder challengeCode(String challengeCode) {
            this.challengeCode = challengeCode;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTtl() {
            return this.ttl;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        @Transient
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        @Override
        public CreateTokenResponse build() {
            return new CreateTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyBackendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTokenResponse> {
        public Builder appId(String var1);

        public Builder challengeCode(String var1);

        public Builder sessionId(String var1);

        public Builder ttl(String var1);
    }
}

