/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates the multi-factor authentication (MFA) configuration for the backend of your Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendAuthMFAConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateBackendAuthMFAConfig.Builder, UpdateBackendAuthMFAConfig> {
    private static final SdkField<String> MFA_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MFAMode").getter(getter(UpdateBackendAuthMFAConfig::mfaModeAsString)).setter(setter(Builder::mfaMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAMode").build()).build();

    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.<Settings> builder(MarshallingType.SDK_POJO)
            .memberName("Settings").getter(getter(UpdateBackendAuthMFAConfig::settings)).setter(setter(Builder::settings))
            .constructor(Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MFA_MODE_FIELD, SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mfaMode;

    private final Settings settings;

    private UpdateBackendAuthMFAConfig(BuilderImpl builder) {
        this.mfaMode = builder.mfaMode;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The MFA mode for the backend of your Amplify project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaMode} will
     * return {@link MFAMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mfaModeAsString}.
     * </p>
     * 
     * @return The MFA mode for the backend of your Amplify project.
     * @see MFAMode
     */
    public final MFAMode mfaMode() {
        return MFAMode.fromValue(mfaMode);
    }

    /**
     * <p>
     * The MFA mode for the backend of your Amplify project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaMode} will
     * return {@link MFAMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mfaModeAsString}.
     * </p>
     * 
     * @return The MFA mode for the backend of your Amplify project.
     * @see MFAMode
     */
    public final String mfaModeAsString() {
        return mfaMode;
    }

    /**
     * <p>
     * The settings of your MFA configuration for the backend of your Amplify project.
     * </p>
     * 
     * @return The settings of your MFA configuration for the backend of your Amplify project.
     */
    public final Settings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mfaModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthMFAConfig)) {
            return false;
        }
        UpdateBackendAuthMFAConfig other = (UpdateBackendAuthMFAConfig) obj;
        return Objects.equals(mfaModeAsString(), other.mfaModeAsString()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendAuthMFAConfig").add("MFAMode", mfaModeAsString()).add("Settings", settings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MFAMode":
            return Optional.ofNullable(clazz.cast(mfaModeAsString()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthMFAConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthMFAConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateBackendAuthMFAConfig> {
        /**
         * <p>
         * The MFA mode for the backend of your Amplify project.
         * </p>
         * 
         * @param mfaMode
         *        The MFA mode for the backend of your Amplify project.
         * @see MFAMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MFAMode
         */
        Builder mfaMode(String mfaMode);

        /**
         * <p>
         * The MFA mode for the backend of your Amplify project.
         * </p>
         * 
         * @param mfaMode
         *        The MFA mode for the backend of your Amplify project.
         * @see MFAMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MFAMode
         */
        Builder mfaMode(MFAMode mfaMode);

        /**
         * <p>
         * The settings of your MFA configuration for the backend of your Amplify project.
         * </p>
         * 
         * @param settings
         *        The settings of your MFA configuration for the backend of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Settings settings);

        /**
         * <p>
         * The settings of your MFA configuration for the backend of your Amplify project.
         * </p>
         * This is a convenience method that creates an instance of the {@link Settings.Builder} avoiding the need to
         * create one manually via {@link Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Settings.Builder#build()} is called immediately and its result is
         * passed to {@link #settings(Settings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(Settings)
         */
        default Builder settings(Consumer<Settings.Builder> settings) {
            return settings(Settings.builder().applyMutation(settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mfaMode;

        private Settings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthMFAConfig model) {
            mfaMode(model.mfaMode);
            settings(model.settings);
        }

        public final String getMfaMode() {
            return mfaMode;
        }

        public final void setMfaMode(String mfaMode) {
            this.mfaMode = mfaMode;
        }

        @Override
        public final Builder mfaMode(String mfaMode) {
            this.mfaMode = mfaMode;
            return this;
        }

        @Override
        public final Builder mfaMode(MFAMode mfaMode) {
            this.mfaMode(mfaMode == null ? null : mfaMode.toString());
            return this;
        }

        public final Settings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public UpdateBackendAuthMFAConfig build() {
            return new UpdateBackendAuthMFAConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
