/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource configuration for updating backend storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendStorageResourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateBackendStorageResourceConfig.Builder, UpdateBackendStorageResourceConfig> {
    private static final SdkField<BackendStoragePermissions> PERMISSIONS_FIELD = SdkField
            .<BackendStoragePermissions> builder(MarshallingType.SDK_POJO).memberName("Permissions")
            .getter(getter(UpdateBackendStorageResourceConfig::permissions)).setter(setter(Builder::permissions))
            .constructor(BackendStoragePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(UpdateBackendStorageResourceConfig::serviceNameAsString))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD,
            SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final BackendStoragePermissions permissions;

    private final String serviceName;

    private UpdateBackendStorageResourceConfig(BuilderImpl builder) {
        this.permissions = builder.permissions;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The authorization configuration for the storage S3 bucket.
     * </p>
     * 
     * @return The authorization configuration for the storage S3 bucket.
     */
    public final BackendStoragePermissions permissions() {
        return permissions;
    }

    /**
     * <p>
     * The name of the storage service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the storage service.
     * @see ServiceName
     */
    public final ServiceName serviceName() {
        return ServiceName.fromValue(serviceName);
    }

    /**
     * <p>
     * The name of the storage service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link ServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the storage service.
     * @see ServiceName
     */
    public final String serviceNameAsString() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendStorageResourceConfig)) {
            return false;
        }
        UpdateBackendStorageResourceConfig other = (UpdateBackendStorageResourceConfig) obj;
        return Objects.equals(permissions(), other.permissions())
                && Objects.equals(serviceNameAsString(), other.serviceNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendStorageResourceConfig").add("Permissions", permissions())
                .add("ServiceName", serviceNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendStorageResourceConfig, T> g) {
        return obj -> g.apply((UpdateBackendStorageResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateBackendStorageResourceConfig> {
        /**
         * <p>
         * The authorization configuration for the storage S3 bucket.
         * </p>
         * 
         * @param permissions
         *        The authorization configuration for the storage S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(BackendStoragePermissions permissions);

        /**
         * <p>
         * The authorization configuration for the storage S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackendStoragePermissions.Builder}
         * avoiding the need to create one manually via {@link BackendStoragePermissions#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackendStoragePermissions.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(BackendStoragePermissions)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link BackendStoragePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(BackendStoragePermissions)
         */
        default Builder permissions(Consumer<BackendStoragePermissions.Builder> permissions) {
            return permissions(BackendStoragePermissions.builder().applyMutation(permissions).build());
        }

        /**
         * <p>
         * The name of the storage service.
         * </p>
         * 
         * @param serviceName
         *        The name of the storage service.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the storage service.
         * </p>
         * 
         * @param serviceName
         *        The name of the storage service.
         * @see ServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceName
         */
        Builder serviceName(ServiceName serviceName);
    }

    static final class BuilderImpl implements Builder {
        private BackendStoragePermissions permissions;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendStorageResourceConfig model) {
            permissions(model.permissions);
            serviceName(model.serviceName);
        }

        public final BackendStoragePermissions.Builder getPermissions() {
            return permissions != null ? permissions.toBuilder() : null;
        }

        public final void setPermissions(BackendStoragePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(BackendStoragePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        @Override
        public UpdateBackendStorageResourceConfig build() {
            return new UpdateBackendStorageResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
