/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for using the social identity providers for access to your Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SocialProviderSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SocialProviderSettings.Builder, SocialProviderSettings> {
    private static final SdkField<BackendAuthSocialProviderConfig> FACEBOOK_FIELD = SdkField
            .<BackendAuthSocialProviderConfig> builder(MarshallingType.SDK_POJO).memberName("Facebook")
            .getter(getter(SocialProviderSettings::facebook)).setter(setter(Builder::facebook))
            .constructor(BackendAuthSocialProviderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facebook").build()).build();

    private static final SdkField<BackendAuthSocialProviderConfig> GOOGLE_FIELD = SdkField
            .<BackendAuthSocialProviderConfig> builder(MarshallingType.SDK_POJO).memberName("Google")
            .getter(getter(SocialProviderSettings::google)).setter(setter(Builder::google))
            .constructor(BackendAuthSocialProviderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Google").build()).build();

    private static final SdkField<BackendAuthSocialProviderConfig> LOGIN_WITH_AMAZON_FIELD = SdkField
            .<BackendAuthSocialProviderConfig> builder(MarshallingType.SDK_POJO).memberName("LoginWithAmazon")
            .getter(getter(SocialProviderSettings::loginWithAmazon)).setter(setter(Builder::loginWithAmazon))
            .constructor(BackendAuthSocialProviderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginWithAmazon").build()).build();

    private static final SdkField<BackendAuthAppleProviderConfig> SIGN_IN_WITH_APPLE_FIELD = SdkField
            .<BackendAuthAppleProviderConfig> builder(MarshallingType.SDK_POJO).memberName("SignInWithApple")
            .getter(getter(SocialProviderSettings::signInWithApple)).setter(setter(Builder::signInWithApple))
            .constructor(BackendAuthAppleProviderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInWithApple").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACEBOOK_FIELD, GOOGLE_FIELD,
            LOGIN_WITH_AMAZON_FIELD, SIGN_IN_WITH_APPLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final BackendAuthSocialProviderConfig facebook;

    private final BackendAuthSocialProviderConfig google;

    private final BackendAuthSocialProviderConfig loginWithAmazon;

    private final BackendAuthAppleProviderConfig signInWithApple;

    private SocialProviderSettings(BuilderImpl builder) {
        this.facebook = builder.facebook;
        this.google = builder.google;
        this.loginWithAmazon = builder.loginWithAmazon;
        this.signInWithApple = builder.signInWithApple;
    }

    /**
     * Returns the value of the Facebook property for this object.
     * 
     * @return The value of the Facebook property for this object.
     */
    public final BackendAuthSocialProviderConfig facebook() {
        return facebook;
    }

    /**
     * Returns the value of the Google property for this object.
     * 
     * @return The value of the Google property for this object.
     */
    public final BackendAuthSocialProviderConfig google() {
        return google;
    }

    /**
     * Returns the value of the LoginWithAmazon property for this object.
     * 
     * @return The value of the LoginWithAmazon property for this object.
     */
    public final BackendAuthSocialProviderConfig loginWithAmazon() {
        return loginWithAmazon;
    }

    /**
     * Returns the value of the SignInWithApple property for this object.
     * 
     * @return The value of the SignInWithApple property for this object.
     */
    public final BackendAuthAppleProviderConfig signInWithApple() {
        return signInWithApple;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(facebook());
        hashCode = 31 * hashCode + Objects.hashCode(google());
        hashCode = 31 * hashCode + Objects.hashCode(loginWithAmazon());
        hashCode = 31 * hashCode + Objects.hashCode(signInWithApple());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SocialProviderSettings)) {
            return false;
        }
        SocialProviderSettings other = (SocialProviderSettings) obj;
        return Objects.equals(facebook(), other.facebook()) && Objects.equals(google(), other.google())
                && Objects.equals(loginWithAmazon(), other.loginWithAmazon())
                && Objects.equals(signInWithApple(), other.signInWithApple());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SocialProviderSettings").add("Facebook", facebook()).add("Google", google())
                .add("LoginWithAmazon", loginWithAmazon()).add("SignInWithApple", signInWithApple()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Facebook":
            return Optional.ofNullable(clazz.cast(facebook()));
        case "Google":
            return Optional.ofNullable(clazz.cast(google()));
        case "LoginWithAmazon":
            return Optional.ofNullable(clazz.cast(loginWithAmazon()));
        case "SignInWithApple":
            return Optional.ofNullable(clazz.cast(signInWithApple()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SocialProviderSettings, T> g) {
        return obj -> g.apply((SocialProviderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SocialProviderSettings> {
        /**
         * Sets the value of the Facebook property for this object.
         *
         * @param facebook
         *        The new value for the Facebook property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facebook(BackendAuthSocialProviderConfig facebook);

        /**
         * Sets the value of the Facebook property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BackendAuthSocialProviderConfig.Builder}
         * avoiding the need to create one manually via {@link BackendAuthSocialProviderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackendAuthSocialProviderConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #facebook(BackendAuthSocialProviderConfig)}.
         * 
         * @param facebook
         *        a consumer that will call methods on {@link BackendAuthSocialProviderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facebook(BackendAuthSocialProviderConfig)
         */
        default Builder facebook(Consumer<BackendAuthSocialProviderConfig.Builder> facebook) {
            return facebook(BackendAuthSocialProviderConfig.builder().applyMutation(facebook).build());
        }

        /**
         * Sets the value of the Google property for this object.
         *
         * @param google
         *        The new value for the Google property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder google(BackendAuthSocialProviderConfig google);

        /**
         * Sets the value of the Google property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BackendAuthSocialProviderConfig.Builder}
         * avoiding the need to create one manually via {@link BackendAuthSocialProviderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackendAuthSocialProviderConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #google(BackendAuthSocialProviderConfig)}.
         * 
         * @param google
         *        a consumer that will call methods on {@link BackendAuthSocialProviderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #google(BackendAuthSocialProviderConfig)
         */
        default Builder google(Consumer<BackendAuthSocialProviderConfig.Builder> google) {
            return google(BackendAuthSocialProviderConfig.builder().applyMutation(google).build());
        }

        /**
         * Sets the value of the LoginWithAmazon property for this object.
         *
         * @param loginWithAmazon
         *        The new value for the LoginWithAmazon property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginWithAmazon(BackendAuthSocialProviderConfig loginWithAmazon);

        /**
         * Sets the value of the LoginWithAmazon property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BackendAuthSocialProviderConfig.Builder}
         * avoiding the need to create one manually via {@link BackendAuthSocialProviderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackendAuthSocialProviderConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #loginWithAmazon(BackendAuthSocialProviderConfig)}.
         * 
         * @param loginWithAmazon
         *        a consumer that will call methods on {@link BackendAuthSocialProviderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loginWithAmazon(BackendAuthSocialProviderConfig)
         */
        default Builder loginWithAmazon(Consumer<BackendAuthSocialProviderConfig.Builder> loginWithAmazon) {
            return loginWithAmazon(BackendAuthSocialProviderConfig.builder().applyMutation(loginWithAmazon).build());
        }

        /**
         * Sets the value of the SignInWithApple property for this object.
         *
         * @param signInWithApple
         *        The new value for the SignInWithApple property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signInWithApple(BackendAuthAppleProviderConfig signInWithApple);

        /**
         * Sets the value of the SignInWithApple property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BackendAuthAppleProviderConfig.Builder}
         * avoiding the need to create one manually via {@link BackendAuthAppleProviderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackendAuthAppleProviderConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #signInWithApple(BackendAuthAppleProviderConfig)}.
         * 
         * @param signInWithApple
         *        a consumer that will call methods on {@link BackendAuthAppleProviderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signInWithApple(BackendAuthAppleProviderConfig)
         */
        default Builder signInWithApple(Consumer<BackendAuthAppleProviderConfig.Builder> signInWithApple) {
            return signInWithApple(BackendAuthAppleProviderConfig.builder().applyMutation(signInWithApple).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BackendAuthSocialProviderConfig facebook;

        private BackendAuthSocialProviderConfig google;

        private BackendAuthSocialProviderConfig loginWithAmazon;

        private BackendAuthAppleProviderConfig signInWithApple;

        private BuilderImpl() {
        }

        private BuilderImpl(SocialProviderSettings model) {
            facebook(model.facebook);
            google(model.google);
            loginWithAmazon(model.loginWithAmazon);
            signInWithApple(model.signInWithApple);
        }

        public final BackendAuthSocialProviderConfig.Builder getFacebook() {
            return facebook != null ? facebook.toBuilder() : null;
        }

        public final void setFacebook(BackendAuthSocialProviderConfig.BuilderImpl facebook) {
            this.facebook = facebook != null ? facebook.build() : null;
        }

        @Override
        public final Builder facebook(BackendAuthSocialProviderConfig facebook) {
            this.facebook = facebook;
            return this;
        }

        public final BackendAuthSocialProviderConfig.Builder getGoogle() {
            return google != null ? google.toBuilder() : null;
        }

        public final void setGoogle(BackendAuthSocialProviderConfig.BuilderImpl google) {
            this.google = google != null ? google.build() : null;
        }

        @Override
        public final Builder google(BackendAuthSocialProviderConfig google) {
            this.google = google;
            return this;
        }

        public final BackendAuthSocialProviderConfig.Builder getLoginWithAmazon() {
            return loginWithAmazon != null ? loginWithAmazon.toBuilder() : null;
        }

        public final void setLoginWithAmazon(BackendAuthSocialProviderConfig.BuilderImpl loginWithAmazon) {
            this.loginWithAmazon = loginWithAmazon != null ? loginWithAmazon.build() : null;
        }

        @Override
        public final Builder loginWithAmazon(BackendAuthSocialProviderConfig loginWithAmazon) {
            this.loginWithAmazon = loginWithAmazon;
            return this;
        }

        public final BackendAuthAppleProviderConfig.Builder getSignInWithApple() {
            return signInWithApple != null ? signInWithApple.toBuilder() : null;
        }

        public final void setSignInWithApple(BackendAuthAppleProviderConfig.BuilderImpl signInWithApple) {
            this.signInWithApple = signInWithApple != null ? signInWithApple.build() : null;
        }

        @Override
        public final Builder signInWithApple(BackendAuthAppleProviderConfig signInWithApple) {
            this.signInWithApple = signInWithApple;
            return this;
        }

        @Override
        public SocialProviderSettings build() {
            return new SocialProviderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
