/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes Apple social federation configurations for allowing your app users to sign in using OAuth.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendAuthAppleProviderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<BackendAuthAppleProviderConfig.Builder, BackendAuthAppleProviderConfig> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientId").getter(getter(BackendAuthAppleProviderConfig::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("client_id").build()).build();

    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyId")
            .getter(getter(BackendAuthAppleProviderConfig::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key_id").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateKey").getter(getter(BackendAuthAppleProviderConfig::privateKey))
            .setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("private_key").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(BackendAuthAppleProviderConfig::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("team_id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, KEY_ID_FIELD,
            PRIVATE_KEY_FIELD, TEAM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String keyId;

    private final String privateKey;

    private final String teamId;

    private BackendAuthAppleProviderConfig(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.keyId = builder.keyId;
        this.privateKey = builder.privateKey;
        this.teamId = builder.teamId;
    }

    /**
     * <p>
     * Describes the client_id (also called Services ID) that comes from Apple.
     * </p>
     * 
     * @return Describes the client_id (also called Services ID) that comes from Apple.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * Describes the key_id that comes from Apple.
     * </p>
     * 
     * @return Describes the key_id that comes from Apple.
     */
    public final String keyId() {
        return keyId;
    }

    /**
     * <p>
     * Describes the private_key that comes from Apple.
     * </p>
     * 
     * @return Describes the private_key that comes from Apple.
     */
    public final String privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * Describes the team_id that comes from Apple.
     * </p>
     * 
     * @return Describes the team_id that comes from Apple.
     */
    public final String teamId() {
        return teamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendAuthAppleProviderConfig)) {
            return false;
        }
        BackendAuthAppleProviderConfig other = (BackendAuthAppleProviderConfig) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(keyId(), other.keyId())
                && Objects.equals(privateKey(), other.privateKey()) && Objects.equals(teamId(), other.teamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackendAuthAppleProviderConfig").add("ClientId", clientId()).add("KeyId", keyId())
                .add("PrivateKey", privateKey()).add("TeamId", teamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendAuthAppleProviderConfig, T> g) {
        return obj -> g.apply((BackendAuthAppleProviderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendAuthAppleProviderConfig> {
        /**
         * <p>
         * Describes the client_id (also called Services ID) that comes from Apple.
         * </p>
         * 
         * @param clientId
         *        Describes the client_id (also called Services ID) that comes from Apple.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * Describes the key_id that comes from Apple.
         * </p>
         * 
         * @param keyId
         *        Describes the key_id that comes from Apple.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * Describes the private_key that comes from Apple.
         * </p>
         * 
         * @param privateKey
         *        Describes the private_key that comes from Apple.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * <p>
         * Describes the team_id that comes from Apple.
         * </p>
         * 
         * @param teamId
         *        Describes the team_id that comes from Apple.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String keyId;

        private String privateKey;

        private String teamId;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendAuthAppleProviderConfig model) {
            clientId(model.clientId);
            keyId(model.keyId);
            privateKey(model.privateKey);
            teamId(model.teamId);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getKeyId() {
            return keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        @Transient
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        @Transient
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        @Transient
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        @Override
        public BackendAuthAppleProviderConfig build() {
            return new BackendAuthAppleProviderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
