/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for this operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoginAuthConfigReqObj implements SdkPojo, Serializable,
        ToCopyableBuilder<LoginAuthConfigReqObj.Builder, LoginAuthConfigReqObj> {
    private static final SdkField<String> AWS_COGNITO_IDENTITY_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsCognitoIdentityPoolId")
            .getter(getter(LoginAuthConfigReqObj::awsCognitoIdentityPoolId))
            .setter(setter(Builder::awsCognitoIdentityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aws_cognito_identity_pool_id")
                    .build()).build();

    private static final SdkField<String> AWS_COGNITO_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsCognitoRegion").getter(getter(LoginAuthConfigReqObj::awsCognitoRegion))
            .setter(setter(Builder::awsCognitoRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aws_cognito_region").build())
            .build();

    private static final SdkField<String> AWS_USER_POOLS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsUserPoolsId").getter(getter(LoginAuthConfigReqObj::awsUserPoolsId))
            .setter(setter(Builder::awsUserPoolsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aws_user_pools_id").build()).build();

    private static final SdkField<String> AWS_USER_POOLS_WEB_CLIENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsUserPoolsWebClientId")
            .getter(getter(LoginAuthConfigReqObj::awsUserPoolsWebClientId))
            .setter(setter(Builder::awsUserPoolsWebClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aws_user_pools_web_client_id")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_COGNITO_IDENTITY_POOL_ID_FIELD, AWS_COGNITO_REGION_FIELD, AWS_USER_POOLS_ID_FIELD,
            AWS_USER_POOLS_WEB_CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsCognitoIdentityPoolId;

    private final String awsCognitoRegion;

    private final String awsUserPoolsId;

    private final String awsUserPoolsWebClientId;

    private LoginAuthConfigReqObj(BuilderImpl builder) {
        this.awsCognitoIdentityPoolId = builder.awsCognitoIdentityPoolId;
        this.awsCognitoRegion = builder.awsCognitoRegion;
        this.awsUserPoolsId = builder.awsUserPoolsId;
        this.awsUserPoolsWebClientId = builder.awsUserPoolsWebClientId;
    }

    /**
     * <p>
     * The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.
     * </p>
     * 
     * @return The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.
     */
    public final String awsCognitoIdentityPoolId() {
        return awsCognitoIdentityPoolId;
    }

    /**
     * <p>
     * The AWS Region for the Amplify Admin UI login.
     * </p>
     * 
     * @return The AWS Region for the Amplify Admin UI login.
     */
    public final String awsCognitoRegion() {
        return awsCognitoRegion;
    }

    /**
     * <p>
     * The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.
     * </p>
     * 
     * @return The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.
     */
    public final String awsUserPoolsId() {
        return awsUserPoolsId;
    }

    /**
     * <p>
     * The web client ID for the Amazon Cognito user pools.
     * </p>
     * 
     * @return The web client ID for the Amazon Cognito user pools.
     */
    public final String awsUserPoolsWebClientId() {
        return awsUserPoolsWebClientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsCognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(awsCognitoRegion());
        hashCode = 31 * hashCode + Objects.hashCode(awsUserPoolsId());
        hashCode = 31 * hashCode + Objects.hashCode(awsUserPoolsWebClientId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoginAuthConfigReqObj)) {
            return false;
        }
        LoginAuthConfigReqObj other = (LoginAuthConfigReqObj) obj;
        return Objects.equals(awsCognitoIdentityPoolId(), other.awsCognitoIdentityPoolId())
                && Objects.equals(awsCognitoRegion(), other.awsCognitoRegion())
                && Objects.equals(awsUserPoolsId(), other.awsUserPoolsId())
                && Objects.equals(awsUserPoolsWebClientId(), other.awsUserPoolsWebClientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoginAuthConfigReqObj").add("AwsCognitoIdentityPoolId", awsCognitoIdentityPoolId())
                .add("AwsCognitoRegion", awsCognitoRegion()).add("AwsUserPoolsId", awsUserPoolsId())
                .add("AwsUserPoolsWebClientId", awsUserPoolsWebClientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsCognitoIdentityPoolId":
            return Optional.ofNullable(clazz.cast(awsCognitoIdentityPoolId()));
        case "AwsCognitoRegion":
            return Optional.ofNullable(clazz.cast(awsCognitoRegion()));
        case "AwsUserPoolsId":
            return Optional.ofNullable(clazz.cast(awsUserPoolsId()));
        case "AwsUserPoolsWebClientId":
            return Optional.ofNullable(clazz.cast(awsUserPoolsWebClientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoginAuthConfigReqObj, T> g) {
        return obj -> g.apply((LoginAuthConfigReqObj) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoginAuthConfigReqObj> {
        /**
         * <p>
         * The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.
         * </p>
         * 
         * @param awsCognitoIdentityPoolId
         *        The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCognitoIdentityPoolId(String awsCognitoIdentityPoolId);

        /**
         * <p>
         * The AWS Region for the Amplify Admin UI login.
         * </p>
         * 
         * @param awsCognitoRegion
         *        The AWS Region for the Amplify Admin UI login.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCognitoRegion(String awsCognitoRegion);

        /**
         * <p>
         * The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.
         * </p>
         * 
         * @param awsUserPoolsId
         *        The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsUserPoolsId(String awsUserPoolsId);

        /**
         * <p>
         * The web client ID for the Amazon Cognito user pools.
         * </p>
         * 
         * @param awsUserPoolsWebClientId
         *        The web client ID for the Amazon Cognito user pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsUserPoolsWebClientId(String awsUserPoolsWebClientId);
    }

    static final class BuilderImpl implements Builder {
        private String awsCognitoIdentityPoolId;

        private String awsCognitoRegion;

        private String awsUserPoolsId;

        private String awsUserPoolsWebClientId;

        private BuilderImpl() {
        }

        private BuilderImpl(LoginAuthConfigReqObj model) {
            awsCognitoIdentityPoolId(model.awsCognitoIdentityPoolId);
            awsCognitoRegion(model.awsCognitoRegion);
            awsUserPoolsId(model.awsUserPoolsId);
            awsUserPoolsWebClientId(model.awsUserPoolsWebClientId);
        }

        public final String getAwsCognitoIdentityPoolId() {
            return awsCognitoIdentityPoolId;
        }

        public final void setAwsCognitoIdentityPoolId(String awsCognitoIdentityPoolId) {
            this.awsCognitoIdentityPoolId = awsCognitoIdentityPoolId;
        }

        @Override
        public final Builder awsCognitoIdentityPoolId(String awsCognitoIdentityPoolId) {
            this.awsCognitoIdentityPoolId = awsCognitoIdentityPoolId;
            return this;
        }

        public final String getAwsCognitoRegion() {
            return awsCognitoRegion;
        }

        public final void setAwsCognitoRegion(String awsCognitoRegion) {
            this.awsCognitoRegion = awsCognitoRegion;
        }

        @Override
        public final Builder awsCognitoRegion(String awsCognitoRegion) {
            this.awsCognitoRegion = awsCognitoRegion;
            return this;
        }

        public final String getAwsUserPoolsId() {
            return awsUserPoolsId;
        }

        public final void setAwsUserPoolsId(String awsUserPoolsId) {
            this.awsUserPoolsId = awsUserPoolsId;
        }

        @Override
        public final Builder awsUserPoolsId(String awsUserPoolsId) {
            this.awsUserPoolsId = awsUserPoolsId;
            return this;
        }

        public final String getAwsUserPoolsWebClientId() {
            return awsUserPoolsWebClientId;
        }

        public final void setAwsUserPoolsWebClientId(String awsUserPoolsWebClientId) {
            this.awsUserPoolsWebClientId = awsUserPoolsWebClientId;
        }

        @Override
        public final Builder awsUserPoolsWebClientId(String awsUserPoolsWebClientId) {
            this.awsUserPoolsWebClientId = awsUserPoolsWebClientId;
            return this;
        }

        @Override
        public LoginAuthConfigReqObj build() {
            return new LoginAuthConfigReqObj(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
