/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendException;
import software.amazon.awssdk.services.amplifybackend.model.BadRequestException;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.GatewayTimeoutException;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse;
import software.amazon.awssdk.services.amplifybackend.model.NotFoundException;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsResponse;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.TooManyRequestsException;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsIterable;

/**
 * Service client for accessing AmplifyBackend. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Amplify Admin API
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AmplifyBackendClient extends AwsClient {
    String SERVICE_NAME = "amplifybackend";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "amplifybackend";

    /**
     * <p>
     * This operation clones an existing backend.
     * </p>
     *
     * @param cloneBackendRequest
     *        The request body for CloneBackend.
     * @return Result of the CloneBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CloneBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CloneBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CloneBackendResponse cloneBackend(CloneBackendRequest cloneBackendRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation clones an existing backend.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloneBackendRequest.Builder} avoiding the need to
     * create one manually via {@link CloneBackendRequest#builder()}
     * </p>
     *
     * @param cloneBackendRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest.Builder} to create a
     *        request. The request body for CloneBackend.
     * @return Result of the CloneBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CloneBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CloneBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CloneBackendResponse cloneBackend(Consumer<CloneBackendRequest.Builder> cloneBackendRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return cloneBackend(CloneBackendRequest.builder().applyMutation(cloneBackendRequest).build());
    }

    /**
     * <p>
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app
     * creation.
     * </p>
     *
     * @param createBackendRequest
     *        The request body for CreateBackend.
     * @return Result of the CreateBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBackendResponse createBackend(CreateBackendRequest createBackendRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app
     * creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBackendRequest#builder()}
     * </p>
     *
     * @param createBackendRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest.Builder} to create a
     *        request. The request body for CreateBackend.
     * @return Result of the CreateBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBackendResponse createBackend(Consumer<CreateBackendRequest.Builder> createBackendRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return createBackend(CreateBackendRequest.builder().applyMutation(createBackendRequest).build());
    }

    /**
     * <p>
     * Creates a new backend API resource.
     * </p>
     *
     * @param createBackendApiRequest
     *        The request body for CreateBackendAPI.
     * @return Result of the CreateBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendApiResponse createBackendAPI(CreateBackendApiRequest createBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendApiRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackendApiRequest#builder()}
     * </p>
     *
     * @param createBackendApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiRequest.Builder} to create a
     *        request. The request body for CreateBackendAPI.
     * @return Result of the CreateBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendApiResponse createBackendAPI(Consumer<CreateBackendApiRequest.Builder> createBackendApiRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return createBackendAPI(CreateBackendApiRequest.builder().applyMutation(createBackendApiRequest).build());
    }

    /**
     * <p>
     * Creates a new backend authentication resource.
     * </p>
     *
     * @param createBackendAuthRequest
     *        The request body for CreateBackendAuth.
     * @return Result of the CreateBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendAuthResponse createBackendAuth(CreateBackendAuthRequest createBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new backend authentication resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendAuthRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackendAuthRequest#builder()}
     * </p>
     *
     * @param createBackendAuthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthRequest.Builder} to create a
     *        request. The request body for CreateBackendAuth.
     * @return Result of the CreateBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendAuthResponse createBackendAuth(Consumer<CreateBackendAuthRequest.Builder> createBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return createBackendAuth(CreateBackendAuthRequest.builder().applyMutation(createBackendAuthRequest).build());
    }

    /**
     * <p>
     * Creates a config object for a backend.
     * </p>
     *
     * @param createBackendConfigRequest
     *        The request body for CreateBackendConfig.
     * @return Result of the CreateBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendConfigResponse createBackendConfig(CreateBackendConfigRequest createBackendConfigRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a config object for a backend.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBackendConfigRequest#builder()}
     * </p>
     *
     * @param createBackendConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest.Builder} to create
     *        a request. The request body for CreateBackendConfig.
     * @return Result of the CreateBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendConfigResponse createBackendConfig(
            Consumer<CreateBackendConfigRequest.Builder> createBackendConfigRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return createBackendConfig(CreateBackendConfigRequest.builder().applyMutation(createBackendConfigRequest).build());
    }

    /**
     * <p>
     * Creates a backend storage resource.
     * </p>
     *
     * @param createBackendStorageRequest
     *        The request body for CreateBackendStorage.
     * @return Result of the CreateBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendStorageResponse createBackendStorage(CreateBackendStorageRequest createBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a backend storage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendStorageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBackendStorageRequest#builder()}
     * </p>
     *
     * @param createBackendStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest.Builder} to create
     *        a request. The request body for CreateBackendStorage.
     * @return Result of the CreateBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBackendStorageResponse createBackendStorage(
            Consumer<CreateBackendStorageRequest.Builder> createBackendStorageRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return createBackendStorage(CreateBackendStorageRequest.builder().applyMutation(createBackendStorageRequest).build());
    }

    /**
     * <p>
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     * </p>
     *
     * @param createTokenRequest
     * @return Result of the CreateToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTokenResponse createToken(CreateTokenRequest createTokenRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTokenRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTokenRequest#builder()}
     * </p>
     *
     * @param createTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.CreateTokenRequest.Builder} to create a
     *        request.
     * @return Result of the CreateToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTokenResponse createToken(Consumer<CreateTokenRequest.Builder> createTokenRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return createToken(CreateTokenRequest.builder().applyMutation(createTokenRequest).build());
    }

    /**
     * <p>
     * Removes an existing environment from your Amplify project.
     * </p>
     *
     * @param deleteBackendRequest
     * @return Result of the DeleteBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBackendResponse deleteBackend(DeleteBackendRequest deleteBackendRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an existing environment from your Amplify project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBackendRequest#builder()}
     * </p>
     *
     * @param deleteBackendRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.DeleteBackendRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBackendResponse deleteBackend(Consumer<DeleteBackendRequest.Builder> deleteBackendRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return deleteBackend(DeleteBackendRequest.builder().applyMutation(deleteBackendRequest).build());
    }

    /**
     * <p>
     * Deletes an existing backend API resource.
     * </p>
     *
     * @param deleteBackendApiRequest
     *        The request body for DeleteBackendAPI.
     * @return Result of the DeleteBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendApiResponse deleteBackendAPI(DeleteBackendApiRequest deleteBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendApiRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackendApiRequest#builder()}
     * </p>
     *
     * @param deleteBackendApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiRequest.Builder} to create a
     *        request. The request body for DeleteBackendAPI.
     * @return Result of the DeleteBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendApiResponse deleteBackendAPI(Consumer<DeleteBackendApiRequest.Builder> deleteBackendApiRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return deleteBackendAPI(DeleteBackendApiRequest.builder().applyMutation(deleteBackendApiRequest).build());
    }

    /**
     * <p>
     * Deletes an existing backend authentication resource.
     * </p>
     *
     * @param deleteBackendAuthRequest
     *        The request body for DeleteBackendAuth.
     * @return Result of the DeleteBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendAuthResponse deleteBackendAuth(DeleteBackendAuthRequest deleteBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing backend authentication resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendAuthRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackendAuthRequest#builder()}
     * </p>
     *
     * @param deleteBackendAuthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthRequest.Builder} to create a
     *        request. The request body for DeleteBackendAuth.
     * @return Result of the DeleteBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendAuthResponse deleteBackendAuth(Consumer<DeleteBackendAuthRequest.Builder> deleteBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return deleteBackendAuth(DeleteBackendAuthRequest.builder().applyMutation(deleteBackendAuthRequest).build());
    }

    /**
     * <p>
     * Removes the specified backend storage resource.
     * </p>
     *
     * @param deleteBackendStorageRequest
     *        The request body for DeleteBackendStorage.
     * @return Result of the DeleteBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendStorageResponse deleteBackendStorage(DeleteBackendStorageRequest deleteBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified backend storage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendStorageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBackendStorageRequest#builder()}
     * </p>
     *
     * @param deleteBackendStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest.Builder} to create
     *        a request. The request body for DeleteBackendStorage.
     * @return Result of the DeleteBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackendStorageResponse deleteBackendStorage(
            Consumer<DeleteBackendStorageRequest.Builder> deleteBackendStorageRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return deleteBackendStorage(DeleteBackendStorageRequest.builder().applyMutation(deleteBackendStorageRequest).build());
    }

    /**
     * <p>
     * Deletes the challenge token based on the given appId and sessionId.
     * </p>
     *
     * @param deleteTokenRequest
     * @return Result of the DeleteToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTokenResponse deleteToken(DeleteTokenRequest deleteTokenRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the challenge token based on the given appId and sessionId.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTokenRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTokenRequest#builder()}
     * </p>
     *
     * @param deleteTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.DeleteTokenRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTokenResponse deleteToken(Consumer<DeleteTokenRequest.Builder> deleteTokenRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return deleteToken(DeleteTokenRequest.builder().applyMutation(deleteTokenRequest).build());
    }

    /**
     * <p>
     * Generates a model schema for an existing backend API resource.
     * </p>
     *
     * @param generateBackendApiModelsRequest
     *        The request body for GenerateBackendAPIModels.
     * @return Result of the GenerateBackendAPIModels operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GenerateBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GenerateBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateBackendApiModelsResponse generateBackendAPIModels(
            GenerateBackendApiModelsRequest generateBackendApiModelsRequest) throws NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a model schema for an existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateBackendApiModelsRequest.Builder} avoiding
     * the need to create one manually via {@link GenerateBackendApiModelsRequest#builder()}
     * </p>
     *
     * @param generateBackendApiModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsRequest.Builder} to
     *        create a request. The request body for GenerateBackendAPIModels.
     * @return Result of the GenerateBackendAPIModels operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GenerateBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GenerateBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GenerateBackendApiModelsResponse generateBackendAPIModels(
            Consumer<GenerateBackendApiModelsRequest.Builder> generateBackendApiModelsRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return generateBackendAPIModels(GenerateBackendApiModelsRequest.builder().applyMutation(generateBackendApiModelsRequest)
                .build());
    }

    /**
     * <p>
     * Provides project-level details for your Amplify UI project.
     * </p>
     *
     * @param getBackendRequest
     *        The request body for GetBackend.
     * @return Result of the GetBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackend" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackendResponse getBackend(GetBackendRequest getBackendRequest) throws NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides project-level details for your Amplify UI project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendRequest#builder()}
     * </p>
     *
     * @param getBackendRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest.Builder} to create a
     *        request. The request body for GetBackend.
     * @return Result of the GetBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackend" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackendResponse getBackend(Consumer<GetBackendRequest.Builder> getBackendRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return getBackend(GetBackendRequest.builder().applyMutation(getBackendRequest).build());
    }

    /**
     * <p>
     * Gets the details for a backend API.
     * </p>
     *
     * @param getBackendApiRequest
     *        The request body for GetBackendAPI.
     * @return Result of the GetBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPI" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendApiResponse getBackendAPI(GetBackendApiRequest getBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for a backend API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendApiRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendApiRequest#builder()}
     * </p>
     *
     * @param getBackendApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest.Builder} to create a
     *        request. The request body for GetBackendAPI.
     * @return Result of the GetBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPI" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendApiResponse getBackendAPI(Consumer<GetBackendApiRequest.Builder> getBackendApiRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return getBackendAPI(GetBackendApiRequest.builder().applyMutation(getBackendApiRequest).build());
    }

    /**
     * <p>
     * Gets a model introspection schema for an existing backend API resource.
     * </p>
     *
     * @param getBackendApiModelsRequest
     *        The request body for GetBackendAPIModels.
     * @return Result of the GetBackendAPIModels operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackendApiModelsResponse getBackendAPIModels(GetBackendApiModelsRequest getBackendApiModelsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a model introspection schema for an existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendApiModelsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackendApiModelsRequest#builder()}
     * </p>
     *
     * @param getBackendApiModelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsRequest.Builder} to create
     *        a request. The request body for GetBackendAPIModels.
     * @return Result of the GetBackendAPIModels operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackendApiModelsResponse getBackendAPIModels(
            Consumer<GetBackendApiModelsRequest.Builder> getBackendApiModelsRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return getBackendAPIModels(GetBackendApiModelsRequest.builder().applyMutation(getBackendApiModelsRequest).build());
    }

    /**
     * <p>
     * Gets a backend auth details.
     * </p>
     *
     * @param getBackendAuthRequest
     *        The request body for GetBackendAuth.
     * @return Result of the GetBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendAuthResponse getBackendAuth(GetBackendAuthRequest getBackendAuthRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a backend auth details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendAuthRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendAuthRequest#builder()}
     * </p>
     *
     * @param getBackendAuthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthRequest.Builder} to create a
     *        request. The request body for GetBackendAuth.
     * @return Result of the GetBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendAuthResponse getBackendAuth(Consumer<GetBackendAuthRequest.Builder> getBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return getBackendAuth(GetBackendAuthRequest.builder().applyMutation(getBackendAuthRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific job.
     * </p>
     *
     * @param getBackendJobRequest
     * @return Result of the GetBackendJob operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendJob" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendJobResponse getBackendJob(GetBackendJobRequest getBackendJobRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendJobRequest#builder()}
     * </p>
     *
     * @param getBackendJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetBackendJob operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendJob" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackendJobResponse getBackendJob(Consumer<GetBackendJobRequest.Builder> getBackendJobRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return getBackendJob(GetBackendJobRequest.builder().applyMutation(getBackendJobRequest).build());
    }

    /**
     * <p>
     * Gets details for a backend storage resource.
     * </p>
     *
     * @param getBackendStorageRequest
     *        The request body for GetBackendStorage.
     * @return Result of the GetBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackendStorageResponse getBackendStorage(GetBackendStorageRequest getBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details for a backend storage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendStorageRequest.Builder} avoiding the need
     * to create one manually via {@link GetBackendStorageRequest#builder()}
     * </p>
     *
     * @param getBackendStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest.Builder} to create a
     *        request. The request body for GetBackendStorage.
     * @return Result of the GetBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackendStorageResponse getBackendStorage(Consumer<GetBackendStorageRequest.Builder> getBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return getBackendStorage(GetBackendStorageRequest.builder().applyMutation(getBackendStorageRequest).build());
    }

    /**
     * <p>
     * Gets the challenge token based on the given appId and sessionId.
     * </p>
     *
     * @param getTokenRequest
     * @return Result of the GetToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetToken" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTokenResponse getToken(GetTokenRequest getTokenRequest) throws NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the challenge token based on the given appId and sessionId.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTokenRequest.Builder} avoiding the need to
     * create one manually via {@link GetTokenRequest#builder()}
     * </p>
     *
     * @param getTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.GetTokenRequest.Builder} to create a request.
     * @return Result of the GetToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetToken" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTokenResponse getToken(Consumer<GetTokenRequest.Builder> getTokenRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return getToken(GetTokenRequest.builder().applyMutation(getTokenRequest).build());
    }

    /**
     * <p>
     * Imports an existing backend authentication resource.
     * </p>
     *
     * @param importBackendAuthRequest
     *        The request body for ImportBackendAuth.
     * @return Result of the ImportBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ImportBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportBackendAuthResponse importBackendAuth(ImportBackendAuthRequest importBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports an existing backend authentication resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportBackendAuthRequest.Builder} avoiding the need
     * to create one manually via {@link ImportBackendAuthRequest#builder()}
     * </p>
     *
     * @param importBackendAuthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest.Builder} to create a
     *        request. The request body for ImportBackendAuth.
     * @return Result of the ImportBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ImportBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportBackendAuthResponse importBackendAuth(Consumer<ImportBackendAuthRequest.Builder> importBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return importBackendAuth(ImportBackendAuthRequest.builder().applyMutation(importBackendAuthRequest).build());
    }

    /**
     * <p>
     * Imports an existing backend storage resource.
     * </p>
     *
     * @param importBackendStorageRequest
     *        The request body for ImportBackendStorage.
     * @return Result of the ImportBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ImportBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportBackendStorageResponse importBackendStorage(ImportBackendStorageRequest importBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports an existing backend storage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportBackendStorageRequest.Builder} avoiding the
     * need to create one manually via {@link ImportBackendStorageRequest#builder()}
     * </p>
     *
     * @param importBackendStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest.Builder} to create
     *        a request. The request body for ImportBackendStorage.
     * @return Result of the ImportBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ImportBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportBackendStorageResponse importBackendStorage(
            Consumer<ImportBackendStorageRequest.Builder> importBackendStorageRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return importBackendStorage(ImportBackendStorageRequest.builder().applyMutation(importBackendStorageRequest).build());
    }

    /**
     * <p>
     * Lists the jobs for the backend of an Amplify app.
     * </p>
     *
     * @param listBackendJobsRequest
     *        The request body for ListBackendJobs.
     * @return Result of the ListBackendJobs operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendJobsResponse listBackendJobs(ListBackendJobsRequest listBackendJobsRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the jobs for the backend of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackendJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackendJobsRequest#builder()}
     * </p>
     *
     * @param listBackendJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest.Builder} to create a
     *        request. The request body for ListBackendJobs.
     * @return Result of the ListBackendJobs operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendJobsResponse listBackendJobs(Consumer<ListBackendJobsRequest.Builder> listBackendJobsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return listBackendJobs(ListBackendJobsRequest.builder().applyMutation(listBackendJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsIterable responses = client.listBackendJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsIterable responses = client
     *             .listBackendJobsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsIterable responses = client.listBackendJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackendJobsRequest
     *        The request body for ListBackendJobs.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendJobsIterable listBackendJobsPaginator(ListBackendJobsRequest listBackendJobsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return new ListBackendJobsIterable(this, listBackendJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsIterable responses = client.listBackendJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsIterable responses = client
     *             .listBackendJobsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsIterable responses = client.listBackendJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackendJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackendJobsRequest#builder()}
     * </p>
     *
     * @param listBackendJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest.Builder} to create a
     *        request. The request body for ListBackendJobs.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendJobsIterable listBackendJobsPaginator(Consumer<ListBackendJobsRequest.Builder> listBackendJobsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return listBackendJobsPaginator(ListBackendJobsRequest.builder().applyMutation(listBackendJobsRequest).build());
    }

    /**
     * <p>
     * The list of S3 buckets in your account.
     * </p>
     *
     * @param listS3BucketsRequest
     *        The request body for S3Buckets.
     * @return Result of the ListS3Buckets operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListS3Buckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListS3Buckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListS3BucketsResponse listS3Buckets(ListS3BucketsRequest listS3BucketsRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The list of S3 buckets in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListS3BucketsRequest.Builder} avoiding the need to
     * create one manually via {@link ListS3BucketsRequest#builder()}
     * </p>
     *
     * @param listS3BucketsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest.Builder} to create a
     *        request. The request body for S3Buckets.
     * @return Result of the ListS3Buckets operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListS3Buckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListS3Buckets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListS3BucketsResponse listS3Buckets(Consumer<ListS3BucketsRequest.Builder> listS3BucketsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return listS3Buckets(ListS3BucketsRequest.builder().applyMutation(listS3BucketsRequest).build());
    }

    /**
     * <p>
     * Removes all backend environments from your Amplify project.
     * </p>
     *
     * @param removeAllBackendsRequest
     *        The request body for RemoveAllBackends.
     * @return Result of the RemoveAllBackends operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.RemoveAllBackends
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveAllBackends"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAllBackendsResponse removeAllBackends(RemoveAllBackendsRequest removeAllBackendsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes all backend environments from your Amplify project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAllBackendsRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveAllBackendsRequest#builder()}
     * </p>
     *
     * @param removeAllBackendsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest.Builder} to create a
     *        request. The request body for RemoveAllBackends.
     * @return Result of the RemoveAllBackends operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.RemoveAllBackends
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveAllBackends"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAllBackendsResponse removeAllBackends(Consumer<RemoveAllBackendsRequest.Builder> removeAllBackendsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return removeAllBackends(RemoveAllBackendsRequest.builder().applyMutation(removeAllBackendsRequest).build());
    }

    /**
     * <p>
     * Removes the AWS resources required to access the Amplify Admin UI.
     * </p>
     *
     * @param removeBackendConfigRequest
     * @return Result of the RemoveBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.RemoveBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveBackendConfigResponse removeBackendConfig(RemoveBackendConfigRequest removeBackendConfigRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the AWS resources required to access the Amplify Admin UI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveBackendConfigRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveBackendConfigRequest#builder()}
     * </p>
     *
     * @param removeBackendConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.RemoveBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveBackendConfigResponse removeBackendConfig(
            Consumer<RemoveBackendConfigRequest.Builder> removeBackendConfigRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return removeBackendConfig(RemoveBackendConfigRequest.builder().applyMutation(removeBackendConfigRequest).build());
    }

    /**
     * <p>
     * Updates an existing backend API resource.
     * </p>
     *
     * @param updateBackendApiRequest
     *        The request body for UpdateBackendAPI.
     * @return Result of the UpdateBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendApiResponse updateBackendAPI(UpdateBackendApiRequest updateBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendApiRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackendApiRequest#builder()}
     * </p>
     *
     * @param updateBackendApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest.Builder} to create a
     *        request. The request body for UpdateBackendAPI.
     * @return Result of the UpdateBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendApiResponse updateBackendAPI(Consumer<UpdateBackendApiRequest.Builder> updateBackendApiRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return updateBackendAPI(UpdateBackendApiRequest.builder().applyMutation(updateBackendApiRequest).build());
    }

    /**
     * <p>
     * Updates an existing backend authentication resource.
     * </p>
     *
     * @param updateBackendAuthRequest
     *        The request body for UpdateBackendAuth.
     * @return Result of the UpdateBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendAuthResponse updateBackendAuth(UpdateBackendAuthRequest updateBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing backend authentication resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendAuthRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackendAuthRequest#builder()}
     * </p>
     *
     * @param updateBackendAuthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest.Builder} to create a
     *        request. The request body for UpdateBackendAuth.
     * @return Result of the UpdateBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendAuthResponse updateBackendAuth(Consumer<UpdateBackendAuthRequest.Builder> updateBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return updateBackendAuth(UpdateBackendAuthRequest.builder().applyMutation(updateBackendAuthRequest).build());
    }

    /**
     * <p>
     * Updates the AWS resources required to access the Amplify Admin UI.
     * </p>
     *
     * @param updateBackendConfigRequest
     *        The request body for UpdateBackendConfig.
     * @return Result of the UpdateBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendConfigResponse updateBackendConfig(UpdateBackendConfigRequest updateBackendConfigRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the AWS resources required to access the Amplify Admin UI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBackendConfigRequest#builder()}
     * </p>
     *
     * @param updateBackendConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest.Builder} to create
     *        a request. The request body for UpdateBackendConfig.
     * @return Result of the UpdateBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendConfigResponse updateBackendConfig(
            Consumer<UpdateBackendConfigRequest.Builder> updateBackendConfigRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return updateBackendConfig(UpdateBackendConfigRequest.builder().applyMutation(updateBackendConfigRequest).build());
    }

    /**
     * <p>
     * Updates a specific job.
     * </p>
     *
     * @param updateBackendJobRequest
     *        The request body for GetBackendJob.
     * @return Result of the UpdateBackendJob operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendJob"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendJobResponse updateBackendJob(UpdateBackendJobRequest updateBackendJobRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specific job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendJobRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackendJobRequest#builder()}
     * </p>
     *
     * @param updateBackendJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest.Builder} to create a
     *        request. The request body for GetBackendJob.
     * @return Result of the UpdateBackendJob operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendJob"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendJobResponse updateBackendJob(Consumer<UpdateBackendJobRequest.Builder> updateBackendJobRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        return updateBackendJob(UpdateBackendJobRequest.builder().applyMutation(updateBackendJobRequest).build());
    }

    /**
     * <p>
     * Updates an existing backend storage resource.
     * </p>
     *
     * @param updateBackendStorageRequest
     *        The request body for UpdateBackendStorage.
     * @return Result of the UpdateBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendStorageResponse updateBackendStorage(UpdateBackendStorageRequest updateBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing backend storage resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendStorageRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBackendStorageRequest#builder()}
     * </p>
     *
     * @param updateBackendStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageRequest.Builder} to create
     *        a request. The request body for UpdateBackendStorage.
     * @return Result of the UpdateBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBackendStorageResponse updateBackendStorage(
            Consumer<UpdateBackendStorageRequest.Builder> updateBackendStorageRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        return updateBackendStorage(UpdateBackendStorageRequest.builder().applyMutation(updateBackendStorageRequest).build());
    }

    /**
     * Create a {@link AmplifyBackendClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AmplifyBackendClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AmplifyBackendClient}.
     */
    static AmplifyBackendClientBuilder builder() {
        return new DefaultAmplifyBackendClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default AmplifyBackendServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
