/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.amplifybackend.internal.AmplifyBackendServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendException;
import software.amazon.awssdk.services.amplifybackend.model.BadRequestException;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.GatewayTimeoutException;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse;
import software.amazon.awssdk.services.amplifybackend.model.NotFoundException;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsResponse;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.TooManyRequestsException;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.transform.CloneBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendConfigRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GenerateBackendApiModelsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendApiModelsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendJobRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ImportBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ImportBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ListBackendJobsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ListS3BucketsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.RemoveAllBackendsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.RemoveBackendConfigRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendConfigRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendJobRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendStorageRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link AmplifyBackendClient}.
 *
 * @see AmplifyBackendClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAmplifyBackendClient implements AmplifyBackendClient {
    private static final Logger log = Logger.loggerFor(DefaultAmplifyBackendClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAmplifyBackendClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * This operation clones an existing backend.
     * </p>
     *
     * @param cloneBackendRequest
     *        The request body for CloneBackend.
     * @return Result of the CloneBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CloneBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CloneBackend" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CloneBackendResponse cloneBackend(CloneBackendRequest cloneBackendRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CloneBackendResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CloneBackendResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cloneBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cloneBackendRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CloneBackend");

            return clientHandler.execute(new ClientExecutionParams<CloneBackendRequest, CloneBackendResponse>()
                    .withOperationName("CloneBackend").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cloneBackendRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CloneBackendRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app
     * creation.
     * </p>
     *
     * @param createBackendRequest
     *        The request body for CreateBackend.
     * @return Result of the CreateBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackend" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBackendResponse createBackend(CreateBackendRequest createBackendRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackendResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBackendResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackendRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackend");

            return clientHandler.execute(new ClientExecutionParams<CreateBackendRequest, CreateBackendResponse>()
                    .withOperationName("CreateBackend").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackendRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackendRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new backend API resource.
     * </p>
     *
     * @param createBackendApiRequest
     *        The request body for CreateBackendAPI.
     * @return Result of the CreateBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBackendApiResponse createBackendAPI(CreateBackendApiRequest createBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackendApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBackendApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackendApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackendApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackendAPI");

            return clientHandler.execute(new ClientExecutionParams<CreateBackendApiRequest, CreateBackendApiResponse>()
                    .withOperationName("CreateBackendAPI").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackendApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackendApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new backend authentication resource.
     * </p>
     *
     * @param createBackendAuthRequest
     *        The request body for CreateBackendAuth.
     * @return Result of the CreateBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBackendAuthResponse createBackendAuth(CreateBackendAuthRequest createBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackendAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBackendAuthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackendAuthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackendAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackendAuth");

            return clientHandler.execute(new ClientExecutionParams<CreateBackendAuthRequest, CreateBackendAuthResponse>()
                    .withOperationName("CreateBackendAuth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackendAuthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackendAuthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a config object for a backend.
     * </p>
     *
     * @param createBackendConfigRequest
     *        The request body for CreateBackendConfig.
     * @return Result of the CreateBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBackendConfigResponse createBackendConfig(CreateBackendConfigRequest createBackendConfigRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackendConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBackendConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackendConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackendConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackendConfig");

            return clientHandler.execute(new ClientExecutionParams<CreateBackendConfigRequest, CreateBackendConfigResponse>()
                    .withOperationName("CreateBackendConfig").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackendConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackendConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a backend storage resource.
     * </p>
     *
     * @param createBackendStorageRequest
     *        The request body for CreateBackendStorage.
     * @return Result of the CreateBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBackendStorageResponse createBackendStorage(CreateBackendStorageRequest createBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackendStorageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBackendStorageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackendStorageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackendStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackendStorage");

            return clientHandler.execute(new ClientExecutionParams<CreateBackendStorageRequest, CreateBackendStorageResponse>()
                    .withOperationName("CreateBackendStorage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackendStorageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackendStorageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     * </p>
     *
     * @param createTokenRequest
     * @return Result of the CreateToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTokenResponse createToken(CreateTokenRequest createTokenRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTokenResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateToken");

            return clientHandler.execute(new ClientExecutionParams<CreateTokenRequest, CreateTokenResponse>()
                    .withOperationName("CreateToken").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTokenRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an existing environment from your Amplify project.
     * </p>
     *
     * @param deleteBackendRequest
     * @return Result of the DeleteBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackend" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBackendResponse deleteBackend(DeleteBackendRequest deleteBackendRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackendResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBackendResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackendRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackend");

            return clientHandler.execute(new ClientExecutionParams<DeleteBackendRequest, DeleteBackendResponse>()
                    .withOperationName("DeleteBackend").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBackendRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBackendRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing backend API resource.
     * </p>
     *
     * @param deleteBackendApiRequest
     *        The request body for DeleteBackendAPI.
     * @return Result of the DeleteBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBackendApiResponse deleteBackendAPI(DeleteBackendApiRequest deleteBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackendApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBackendApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackendApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackendApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackendAPI");

            return clientHandler.execute(new ClientExecutionParams<DeleteBackendApiRequest, DeleteBackendApiResponse>()
                    .withOperationName("DeleteBackendAPI").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBackendApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBackendApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing backend authentication resource.
     * </p>
     *
     * @param deleteBackendAuthRequest
     *        The request body for DeleteBackendAuth.
     * @return Result of the DeleteBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBackendAuthResponse deleteBackendAuth(DeleteBackendAuthRequest deleteBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackendAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBackendAuthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackendAuthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackendAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackendAuth");

            return clientHandler.execute(new ClientExecutionParams<DeleteBackendAuthRequest, DeleteBackendAuthResponse>()
                    .withOperationName("DeleteBackendAuth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBackendAuthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBackendAuthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified backend storage resource.
     * </p>
     *
     * @param deleteBackendStorageRequest
     *        The request body for DeleteBackendStorage.
     * @return Result of the DeleteBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBackendStorageResponse deleteBackendStorage(DeleteBackendStorageRequest deleteBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackendStorageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBackendStorageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackendStorageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackendStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackendStorage");

            return clientHandler.execute(new ClientExecutionParams<DeleteBackendStorageRequest, DeleteBackendStorageResponse>()
                    .withOperationName("DeleteBackendStorage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBackendStorageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBackendStorageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the challenge token based on the given appId and sessionId.
     * </p>
     *
     * @param deleteTokenRequest
     * @return Result of the DeleteToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteTokenResponse deleteToken(DeleteTokenRequest deleteTokenRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTokenResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteToken");

            return clientHandler.execute(new ClientExecutionParams<DeleteTokenRequest, DeleteTokenResponse>()
                    .withOperationName("DeleteToken").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTokenRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a model schema for an existing backend API resource.
     * </p>
     *
     * @param generateBackendApiModelsRequest
     *        The request body for GenerateBackendAPIModels.
     * @return Result of the GenerateBackendAPIModels operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GenerateBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GenerateBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GenerateBackendApiModelsResponse generateBackendAPIModels(
            GenerateBackendApiModelsRequest generateBackendApiModelsRequest) throws NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GenerateBackendApiModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GenerateBackendApiModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(generateBackendApiModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, generateBackendApiModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateBackendAPIModels");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateBackendApiModelsRequest, GenerateBackendApiModelsResponse>()
                            .withOperationName("GenerateBackendAPIModels").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(generateBackendApiModelsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateBackendApiModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides project-level details for your Amplify UI project.
     * </p>
     *
     * @param getBackendRequest
     *        The request body for GetBackend.
     * @return Result of the GetBackend operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackend" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBackendResponse getBackend(GetBackendRequest getBackendRequest) throws NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackendResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBackendResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackendRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackend");

            return clientHandler.execute(new ClientExecutionParams<GetBackendRequest, GetBackendResponse>()
                    .withOperationName("GetBackend").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getBackendRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackendRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the details for a backend API.
     * </p>
     *
     * @param getBackendApiRequest
     *        The request body for GetBackendAPI.
     * @return Result of the GetBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPI" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBackendApiResponse getBackendAPI(GetBackendApiRequest getBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackendApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBackendApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackendApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackendApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackendAPI");

            return clientHandler.execute(new ClientExecutionParams<GetBackendApiRequest, GetBackendApiResponse>()
                    .withOperationName("GetBackendAPI").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackendApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackendApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a model introspection schema for an existing backend API resource.
     * </p>
     *
     * @param getBackendApiModelsRequest
     *        The request body for GetBackendAPIModels.
     * @return Result of the GetBackendAPIModels operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBackendApiModelsResponse getBackendAPIModels(GetBackendApiModelsRequest getBackendApiModelsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackendApiModelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBackendApiModelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackendApiModelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackendApiModelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackendAPIModels");

            return clientHandler.execute(new ClientExecutionParams<GetBackendApiModelsRequest, GetBackendApiModelsResponse>()
                    .withOperationName("GetBackendAPIModels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackendApiModelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackendApiModelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a backend auth details.
     * </p>
     *
     * @param getBackendAuthRequest
     *        The request body for GetBackendAuth.
     * @return Result of the GetBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAuth" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBackendAuthResponse getBackendAuth(GetBackendAuthRequest getBackendAuthRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackendAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBackendAuthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackendAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackendAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackendAuth");

            return clientHandler.execute(new ClientExecutionParams<GetBackendAuthRequest, GetBackendAuthResponse>()
                    .withOperationName("GetBackendAuth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackendAuthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackendAuthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific job.
     * </p>
     *
     * @param getBackendJobRequest
     * @return Result of the GetBackendJob operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBackendJobResponse getBackendJob(GetBackendJobRequest getBackendJobRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackendJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBackendJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackendJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackendJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackendJob");

            return clientHandler.execute(new ClientExecutionParams<GetBackendJobRequest, GetBackendJobResponse>()
                    .withOperationName("GetBackendJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackendJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackendJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets details for a backend storage resource.
     * </p>
     *
     * @param getBackendStorageRequest
     *        The request body for GetBackendStorage.
     * @return Result of the GetBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBackendStorageResponse getBackendStorage(GetBackendStorageRequest getBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackendStorageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBackendStorageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackendStorageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackendStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackendStorage");

            return clientHandler.execute(new ClientExecutionParams<GetBackendStorageRequest, GetBackendStorageResponse>()
                    .withOperationName("GetBackendStorage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackendStorageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackendStorageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the challenge token based on the given appId and sessionId.
     * </p>
     *
     * @param getTokenRequest
     * @return Result of the GetToken operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.GetToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetToken" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTokenResponse getToken(GetTokenRequest getTokenRequest) throws NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTokenResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetToken");

            return clientHandler.execute(new ClientExecutionParams<GetTokenRequest, GetTokenResponse>()
                    .withOperationName("GetToken").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getTokenRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports an existing backend authentication resource.
     * </p>
     *
     * @param importBackendAuthRequest
     *        The request body for ImportBackendAuth.
     * @return Result of the ImportBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ImportBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportBackendAuthResponse importBackendAuth(ImportBackendAuthRequest importBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportBackendAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportBackendAuthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importBackendAuthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importBackendAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportBackendAuth");

            return clientHandler.execute(new ClientExecutionParams<ImportBackendAuthRequest, ImportBackendAuthResponse>()
                    .withOperationName("ImportBackendAuth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importBackendAuthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportBackendAuthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports an existing backend storage resource.
     * </p>
     *
     * @param importBackendStorageRequest
     *        The request body for ImportBackendStorage.
     * @return Result of the ImportBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ImportBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportBackendStorageResponse importBackendStorage(ImportBackendStorageRequest importBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportBackendStorageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportBackendStorageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importBackendStorageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importBackendStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportBackendStorage");

            return clientHandler.execute(new ClientExecutionParams<ImportBackendStorageRequest, ImportBackendStorageResponse>()
                    .withOperationName("ImportBackendStorage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importBackendStorageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportBackendStorageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the jobs for the backend of an Amplify app.
     * </p>
     *
     * @param listBackendJobsRequest
     *        The request body for ListBackendJobs.
     * @return Result of the ListBackendJobs operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBackendJobsResponse listBackendJobs(ListBackendJobsRequest listBackendJobsRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackendJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBackendJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackendJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackendJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackendJobs");

            return clientHandler.execute(new ClientExecutionParams<ListBackendJobsRequest, ListBackendJobsResponse>()
                    .withOperationName("ListBackendJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBackendJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBackendJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The list of S3 buckets in your account.
     * </p>
     *
     * @param listS3BucketsRequest
     *        The request body for S3Buckets.
     * @return Result of the ListS3Buckets operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.ListS3Buckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListS3Buckets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListS3BucketsResponse listS3Buckets(ListS3BucketsRequest listS3BucketsRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListS3BucketsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListS3BucketsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listS3BucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listS3BucketsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListS3Buckets");

            return clientHandler.execute(new ClientExecutionParams<ListS3BucketsRequest, ListS3BucketsResponse>()
                    .withOperationName("ListS3Buckets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listS3BucketsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListS3BucketsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes all backend environments from your Amplify project.
     * </p>
     *
     * @param removeAllBackendsRequest
     *        The request body for RemoveAllBackends.
     * @return Result of the RemoveAllBackends operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.RemoveAllBackends
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveAllBackends"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveAllBackendsResponse removeAllBackends(RemoveAllBackendsRequest removeAllBackendsRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveAllBackendsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveAllBackendsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeAllBackendsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeAllBackendsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveAllBackends");

            return clientHandler.execute(new ClientExecutionParams<RemoveAllBackendsRequest, RemoveAllBackendsResponse>()
                    .withOperationName("RemoveAllBackends").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeAllBackendsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveAllBackendsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the AWS resources required to access the Amplify Admin UI.
     * </p>
     *
     * @param removeBackendConfigRequest
     * @return Result of the RemoveBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.RemoveBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveBackendConfigResponse removeBackendConfig(RemoveBackendConfigRequest removeBackendConfigRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveBackendConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveBackendConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeBackendConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeBackendConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveBackendConfig");

            return clientHandler.execute(new ClientExecutionParams<RemoveBackendConfigRequest, RemoveBackendConfigResponse>()
                    .withOperationName("RemoveBackendConfig").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(removeBackendConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveBackendConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing backend API resource.
     * </p>
     *
     * @param updateBackendApiRequest
     *        The request body for UpdateBackendAPI.
     * @return Result of the UpdateBackendAPI operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBackendApiResponse updateBackendAPI(UpdateBackendApiRequest updateBackendApiRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBackendApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBackendApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBackendApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBackendApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBackendAPI");

            return clientHandler.execute(new ClientExecutionParams<UpdateBackendApiRequest, UpdateBackendApiResponse>()
                    .withOperationName("UpdateBackendAPI").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBackendApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBackendApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing backend authentication resource.
     * </p>
     *
     * @param updateBackendAuthRequest
     *        The request body for UpdateBackendAuth.
     * @return Result of the UpdateBackendAuth operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBackendAuthResponse updateBackendAuth(UpdateBackendAuthRequest updateBackendAuthRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBackendAuthResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBackendAuthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBackendAuthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBackendAuthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBackendAuth");

            return clientHandler.execute(new ClientExecutionParams<UpdateBackendAuthRequest, UpdateBackendAuthResponse>()
                    .withOperationName("UpdateBackendAuth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBackendAuthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBackendAuthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the AWS resources required to access the Amplify Admin UI.
     * </p>
     *
     * @param updateBackendConfigRequest
     *        The request body for UpdateBackendConfig.
     * @return Result of the UpdateBackendConfig operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBackendConfigResponse updateBackendConfig(UpdateBackendConfigRequest updateBackendConfigRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBackendConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBackendConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBackendConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBackendConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBackendConfig");

            return clientHandler.execute(new ClientExecutionParams<UpdateBackendConfigRequest, UpdateBackendConfigResponse>()
                    .withOperationName("UpdateBackendConfig").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBackendConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBackendConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a specific job.
     * </p>
     *
     * @param updateBackendJobRequest
     *        The request body for GetBackendJob.
     * @return Result of the UpdateBackendJob operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBackendJobResponse updateBackendJob(UpdateBackendJobRequest updateBackendJobRequest) throws NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException,
            AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBackendJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBackendJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBackendJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBackendJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBackendJob");

            return clientHandler.execute(new ClientExecutionParams<UpdateBackendJobRequest, UpdateBackendJobResponse>()
                    .withOperationName("UpdateBackendJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBackendJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBackendJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing backend storage resource.
     * </p>
     *
     * @param updateBackendStorageRequest
     *        The request body for UpdateBackendStorage.
     * @return Result of the UpdateBackendStorage operation returned by the service.
     * @throws NotFoundException
     *         404 response
     * @throws GatewayTimeoutException
     *         504 response
     * @throws TooManyRequestsException
     *         429 response
     * @throws BadRequestException
     *         400 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyBackendException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyBackendClient.UpdateBackendStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendStorage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBackendStorageResponse updateBackendStorage(UpdateBackendStorageRequest updateBackendStorageRequest)
            throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException,
            AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBackendStorageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBackendStorageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBackendStorageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBackendStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBackendStorage");

            return clientHandler.execute(new ClientExecutionParams<UpdateBackendStorageRequest, UpdateBackendStorageResponse>()
                    .withOperationName("UpdateBackendStorage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBackendStorageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBackendStorageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        AmplifyBackendServiceClientConfigurationBuilder serviceConfigBuilder = new AmplifyBackendServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AmplifyBackendException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GatewayTimeoutException")
                                .exceptionBuilderSupplier(GatewayTimeoutException::builder).httpStatusCode(504).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    @Override
    public final AmplifyBackendServiceClientConfiguration serviceClientConfiguration() {
        return new AmplifyBackendServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
