/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTokenResponse extends AmplifyBackendResponse implements
        ToCopyableBuilder<GetTokenResponse.Builder, GetTokenResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(GetTokenResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> CHALLENGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChallengeCode").getter(getter(GetTokenResponse::challengeCode)).setter(setter(Builder::challengeCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("challengeCode").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(GetTokenResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ttl")
            .getter(getter(GetTokenResponse::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            CHALLENGE_CODE_FIELD, SESSION_ID_FIELD, TTL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String challengeCode;

    private final String sessionId;

    private final String ttl;

    private GetTokenResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.challengeCode = builder.challengeCode;
        this.sessionId = builder.sessionId;
        this.ttl = builder.ttl;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The one-time challenge code for authenticating into the Amplify Admin UI.
     * </p>
     * 
     * @return The one-time challenge code for authenticating into the Amplify Admin UI.
     */
    public final String challengeCode() {
        return challengeCode;
    }

    /**
     * <p>
     * A unique ID provided when creating a new challenge token.
     * </p>
     * 
     * @return A unique ID provided when creating a new challenge token.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The expiry time for the one-time generated token code.
     * </p>
     * 
     * @return The expiry time for the one-time generated token code.
     */
    public final String ttl() {
        return ttl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(challengeCode());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTokenResponse)) {
            return false;
        }
        GetTokenResponse other = (GetTokenResponse) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(challengeCode(), other.challengeCode())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(ttl(), other.ttl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTokenResponse").add("AppId", appId()).add("ChallengeCode", challengeCode())
                .add("SessionId", sessionId()).add("Ttl", ttl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "ChallengeCode":
            return Optional.ofNullable(clazz.cast(challengeCode()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("challengeCode", CHALLENGE_CODE_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("ttl", TTL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTokenResponse, T> g) {
        return obj -> g.apply((GetTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyBackendResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTokenResponse> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The one-time challenge code for authenticating into the Amplify Admin UI.
         * </p>
         * 
         * @param challengeCode
         *        The one-time challenge code for authenticating into the Amplify Admin UI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder challengeCode(String challengeCode);

        /**
         * <p>
         * A unique ID provided when creating a new challenge token.
         * </p>
         * 
         * @param sessionId
         *        A unique ID provided when creating a new challenge token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The expiry time for the one-time generated token code.
         * </p>
         * 
         * @param ttl
         *        The expiry time for the one-time generated token code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(String ttl);
    }

    static final class BuilderImpl extends AmplifyBackendResponse.BuilderImpl implements Builder {
        private String appId;

        private String challengeCode;

        private String sessionId;

        private String ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTokenResponse model) {
            super(model);
            appId(model.appId);
            challengeCode(model.challengeCode);
            sessionId(model.sessionId);
            ttl(model.ttl);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getChallengeCode() {
            return challengeCode;
        }

        public final void setChallengeCode(String challengeCode) {
            this.challengeCode = challengeCode;
        }

        @Override
        public final Builder challengeCode(String challengeCode) {
            this.challengeCode = challengeCode;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTtl() {
            return ttl;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        @Override
        public GetTokenResponse build() {
            return new GetTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
