/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings of your MFA configuration for the backend of your Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Settings implements SdkPojo, Serializable, ToCopyableBuilder<Settings.Builder, Settings> {
    private static final SdkField<List<String>> MFA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MfaTypes")
            .getter(getter(Settings::mfaTypesAsStrings))
            .setter(setter(Builder::mfaTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SMS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsMessage").getter(getter(Settings::smsMessage)).setter(setter(Builder::smsMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smsMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MFA_TYPES_FIELD,
            SMS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> mfaTypes;

    private final String smsMessage;

    private Settings(BuilderImpl builder) {
        this.mfaTypes = builder.mfaTypes;
        this.smsMessage = builder.smsMessage;
    }

    /**
     * <p>
     * The supported MFA types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMfaTypes} method.
     * </p>
     * 
     * @return The supported MFA types.
     */
    public final List<MfaTypesElement> mfaTypes() {
        return ListOfMfaTypesElementCopier.copyStringToEnum(mfaTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the MfaTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMfaTypes() {
        return mfaTypes != null && !(mfaTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported MFA types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMfaTypes} method.
     * </p>
     * 
     * @return The supported MFA types.
     */
    public final List<String> mfaTypesAsStrings() {
        return mfaTypes;
    }

    /**
     * <p>
     * The body of the SMS message.
     * </p>
     * 
     * @return The body of the SMS message.
     */
    public final String smsMessage() {
        return smsMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMfaTypes() ? mfaTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Settings)) {
            return false;
        }
        Settings other = (Settings) obj;
        return hasMfaTypes() == other.hasMfaTypes() && Objects.equals(mfaTypesAsStrings(), other.mfaTypesAsStrings())
                && Objects.equals(smsMessage(), other.smsMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Settings").add("MfaTypes", hasMfaTypes() ? mfaTypesAsStrings() : null)
                .add("SmsMessage", smsMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MfaTypes":
            return Optional.ofNullable(clazz.cast(mfaTypesAsStrings()));
        case "SmsMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mfaTypes", MFA_TYPES_FIELD);
        map.put("smsMessage", SMS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Settings, T> g) {
        return obj -> g.apply((Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Settings> {
        /**
         * <p>
         * The supported MFA types.
         * </p>
         * 
         * @param mfaTypes
         *        The supported MFA types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaTypesWithStrings(Collection<String> mfaTypes);

        /**
         * <p>
         * The supported MFA types.
         * </p>
         * 
         * @param mfaTypes
         *        The supported MFA types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaTypesWithStrings(String... mfaTypes);

        /**
         * <p>
         * The supported MFA types.
         * </p>
         * 
         * @param mfaTypes
         *        The supported MFA types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaTypes(Collection<MfaTypesElement> mfaTypes);

        /**
         * <p>
         * The supported MFA types.
         * </p>
         * 
         * @param mfaTypes
         *        The supported MFA types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaTypes(MfaTypesElement... mfaTypes);

        /**
         * <p>
         * The body of the SMS message.
         * </p>
         * 
         * @param smsMessage
         *        The body of the SMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(String smsMessage);
    }

    static final class BuilderImpl implements Builder {
        private List<String> mfaTypes = DefaultSdkAutoConstructList.getInstance();

        private String smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Settings model) {
            mfaTypesWithStrings(model.mfaTypes);
            smsMessage(model.smsMessage);
        }

        public final Collection<String> getMfaTypes() {
            if (mfaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return mfaTypes;
        }

        public final void setMfaTypes(Collection<String> mfaTypes) {
            this.mfaTypes = ListOfMfaTypesElementCopier.copy(mfaTypes);
        }

        @Override
        public final Builder mfaTypesWithStrings(Collection<String> mfaTypes) {
            this.mfaTypes = ListOfMfaTypesElementCopier.copy(mfaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaTypesWithStrings(String... mfaTypes) {
            mfaTypesWithStrings(Arrays.asList(mfaTypes));
            return this;
        }

        @Override
        public final Builder mfaTypes(Collection<MfaTypesElement> mfaTypes) {
            this.mfaTypes = ListOfMfaTypesElementCopier.copyEnumToString(mfaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaTypes(MfaTypesElement... mfaTypes) {
            mfaTypes(Arrays.asList(mfaTypes));
            return this;
        }

        public final String getSmsMessage() {
            return smsMessage;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        @Override
        public Settings build() {
            return new Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
