/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body for CreateBackendAuth.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackendAuthRequest extends AmplifyBackendRequest implements
        ToCopyableBuilder<CreateBackendAuthRequest.Builder, CreateBackendAuthRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(CreateBackendAuthRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackendEnvironmentName").getter(getter(CreateBackendAuthRequest::backendEnvironmentName))
            .setter(setter(Builder::backendEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build())
            .build();

    private static final SdkField<CreateBackendAuthResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<CreateBackendAuthResourceConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceConfig")
            .getter(getter(CreateBackendAuthRequest::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(CreateBackendAuthResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(CreateBackendAuthRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BACKEND_ENVIRONMENT_NAME_FIELD, RESOURCE_CONFIG_FIELD, RESOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String backendEnvironmentName;

    private final CreateBackendAuthResourceConfig resourceConfig;

    private final String resourceName;

    private CreateBackendAuthRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.resourceConfig = builder.resourceConfig;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment.
     * </p>
     * 
     * @return The name of the backend environment.
     */
    public final String backendEnvironmentName() {
        return backendEnvironmentName;
    }

    /**
     * <p>
     * The resource configuration for this request object.
     * </p>
     * 
     * @return The resource configuration for this request object.
     */
    public final CreateBackendAuthResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * The name of this resource.
     * </p>
     * 
     * @return The name of this resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthRequest)) {
            return false;
        }
        CreateBackendAuthRequest other = (CreateBackendAuthRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(backendEnvironmentName(), other.backendEnvironmentName())
                && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackendAuthRequest").add("AppId", appId())
                .add("BackendEnvironmentName", backendEnvironmentName()).add("ResourceConfig", resourceConfig())
                .add("ResourceName", resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "BackendEnvironmentName":
            return Optional.ofNullable(clazz.cast(backendEnvironmentName()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("backendEnvironmentName", BACKEND_ENVIRONMENT_NAME_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("resourceName", RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthRequest, T> g) {
        return obj -> g.apply((CreateBackendAuthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmplifyBackendRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackendAuthRequest> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment.
         * </p>
         * 
         * @param backendEnvironmentName
         *        The name of the backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentName(String backendEnvironmentName);

        /**
         * <p>
         * The resource configuration for this request object.
         * </p>
         * 
         * @param resourceConfig
         *        The resource configuration for this request object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(CreateBackendAuthResourceConfig resourceConfig);

        /**
         * <p>
         * The resource configuration for this request object.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateBackendAuthResourceConfig.Builder}
         * avoiding the need to create one manually via {@link CreateBackendAuthResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateBackendAuthResourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceConfig(CreateBackendAuthResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link CreateBackendAuthResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(CreateBackendAuthResourceConfig)
         */
        default Builder resourceConfig(Consumer<CreateBackendAuthResourceConfig.Builder> resourceConfig) {
            return resourceConfig(CreateBackendAuthResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * The name of this resource.
         * </p>
         * 
         * @param resourceName
         *        The name of this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyBackendRequest.BuilderImpl implements Builder {
        private String appId;

        private String backendEnvironmentName;

        private CreateBackendAuthResourceConfig resourceConfig;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthRequest model) {
            super(model);
            appId(model.appId);
            backendEnvironmentName(model.backendEnvironmentName);
            resourceConfig(model.resourceConfig);
            resourceName(model.resourceName);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendEnvironmentName() {
            return backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final CreateBackendAuthResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(CreateBackendAuthResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(CreateBackendAuthResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackendAuthRequest build() {
            return new CreateBackendAuthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
