/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackendResponse extends AmplifyBackendResponse implements
        ToCopyableBuilder<GetBackendResponse.Builder, GetBackendResponse> {
    private static final SdkField<String> AMPLIFY_FEATURE_FLAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmplifyFeatureFlags").getter(getter(GetBackendResponse::amplifyFeatureFlags))
            .setter(setter(Builder::amplifyFeatureFlags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amplifyFeatureFlags").build())
            .build();

    private static final SdkField<String> AMPLIFY_META_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmplifyMetaConfig").getter(getter(GetBackendResponse::amplifyMetaConfig))
            .setter(setter(Builder::amplifyMetaConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amplifyMetaConfig").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(GetBackendResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppName").getter(getter(GetBackendResponse::appName)).setter(setter(Builder::appName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appName").build()).build();

    private static final SdkField<List<String>> BACKEND_ENVIRONMENT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BackendEnvironmentList")
            .getter(getter(GetBackendResponse::backendEnvironmentList))
            .setter(setter(Builder::backendEnvironmentList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackendEnvironmentName").getter(getter(GetBackendResponse::backendEnvironmentName))
            .setter(setter(Builder::backendEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build())
            .build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(GetBackendResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLIFY_FEATURE_FLAGS_FIELD,
            AMPLIFY_META_CONFIG_FIELD, APP_ID_FIELD, APP_NAME_FIELD, BACKEND_ENVIRONMENT_LIST_FIELD,
            BACKEND_ENVIRONMENT_NAME_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String amplifyFeatureFlags;

    private final String amplifyMetaConfig;

    private final String appId;

    private final String appName;

    private final List<String> backendEnvironmentList;

    private final String backendEnvironmentName;

    private final String error;

    private GetBackendResponse(BuilderImpl builder) {
        super(builder);
        this.amplifyFeatureFlags = builder.amplifyFeatureFlags;
        this.amplifyMetaConfig = builder.amplifyMetaConfig;
        this.appId = builder.appId;
        this.appName = builder.appName;
        this.backendEnvironmentList = builder.backendEnvironmentList;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.error = builder.error;
    }

    /**
     * <p>
     * A stringified version of the cli.json file for your Amplify project.
     * </p>
     * 
     * @return A stringified version of the cli.json file for your Amplify project.
     */
    public final String amplifyFeatureFlags() {
        return amplifyFeatureFlags;
    }

    /**
     * <p>
     * A stringified version of the current configs for your Amplify project.
     * </p>
     * 
     * @return A stringified version of the current configs for your Amplify project.
     */
    public final String amplifyMetaConfig() {
        return amplifyMetaConfig;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the app.
     * </p>
     * 
     * @return The name of the app.
     */
    public final String appName() {
        return appName;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackendEnvironmentList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBackendEnvironmentList() {
        return backendEnvironmentList != null && !(backendEnvironmentList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of backend environments in an array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackendEnvironmentList} method.
     * </p>
     * 
     * @return A list of backend environments in an array.
     */
    public final List<String> backendEnvironmentList() {
        return backendEnvironmentList;
    }

    /**
     * <p>
     * The name of the backend environment.
     * </p>
     * 
     * @return The name of the backend environment.
     */
    public final String backendEnvironmentName() {
        return backendEnvironmentName;
    }

    /**
     * <p>
     * If the request failed, this is the returned error.
     * </p>
     * 
     * @return If the request failed, this is the returned error.
     */
    public final String error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amplifyFeatureFlags());
        hashCode = 31 * hashCode + Objects.hashCode(amplifyMetaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(appName());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackendEnvironmentList() ? backendEnvironmentList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendResponse)) {
            return false;
        }
        GetBackendResponse other = (GetBackendResponse) obj;
        return Objects.equals(amplifyFeatureFlags(), other.amplifyFeatureFlags())
                && Objects.equals(amplifyMetaConfig(), other.amplifyMetaConfig()) && Objects.equals(appId(), other.appId())
                && Objects.equals(appName(), other.appName()) && hasBackendEnvironmentList() == other.hasBackendEnvironmentList()
                && Objects.equals(backendEnvironmentList(), other.backendEnvironmentList())
                && Objects.equals(backendEnvironmentName(), other.backendEnvironmentName())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBackendResponse").add("AmplifyFeatureFlags", amplifyFeatureFlags())
                .add("AmplifyMetaConfig", amplifyMetaConfig()).add("AppId", appId()).add("AppName", appName())
                .add("BackendEnvironmentList", hasBackendEnvironmentList() ? backendEnvironmentList() : null)
                .add("BackendEnvironmentName", backendEnvironmentName()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmplifyFeatureFlags":
            return Optional.ofNullable(clazz.cast(amplifyFeatureFlags()));
        case "AmplifyMetaConfig":
            return Optional.ofNullable(clazz.cast(amplifyMetaConfig()));
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "AppName":
            return Optional.ofNullable(clazz.cast(appName()));
        case "BackendEnvironmentList":
            return Optional.ofNullable(clazz.cast(backendEnvironmentList()));
        case "BackendEnvironmentName":
            return Optional.ofNullable(clazz.cast(backendEnvironmentName()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amplifyFeatureFlags", AMPLIFY_FEATURE_FLAGS_FIELD);
        map.put("amplifyMetaConfig", AMPLIFY_META_CONFIG_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("appName", APP_NAME_FIELD);
        map.put("backendEnvironmentList", BACKEND_ENVIRONMENT_LIST_FIELD);
        map.put("backendEnvironmentName", BACKEND_ENVIRONMENT_NAME_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBackendResponse, T> g) {
        return obj -> g.apply((GetBackendResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmplifyBackendResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBackendResponse> {
        /**
         * <p>
         * A stringified version of the cli.json file for your Amplify project.
         * </p>
         * 
         * @param amplifyFeatureFlags
         *        A stringified version of the cli.json file for your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amplifyFeatureFlags(String amplifyFeatureFlags);

        /**
         * <p>
         * A stringified version of the current configs for your Amplify project.
         * </p>
         * 
         * @param amplifyMetaConfig
         *        A stringified version of the current configs for your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amplifyMetaConfig(String amplifyMetaConfig);

        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the app.
         * </p>
         * 
         * @param appName
         *        The name of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appName(String appName);

        /**
         * <p>
         * A list of backend environments in an array.
         * </p>
         * 
         * @param backendEnvironmentList
         *        A list of backend environments in an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentList(Collection<String> backendEnvironmentList);

        /**
         * <p>
         * A list of backend environments in an array.
         * </p>
         * 
         * @param backendEnvironmentList
         *        A list of backend environments in an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentList(String... backendEnvironmentList);

        /**
         * <p>
         * The name of the backend environment.
         * </p>
         * 
         * @param backendEnvironmentName
         *        The name of the backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentName(String backendEnvironmentName);

        /**
         * <p>
         * If the request failed, this is the returned error.
         * </p>
         * 
         * @param error
         *        If the request failed, this is the returned error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);
    }

    static final class BuilderImpl extends AmplifyBackendResponse.BuilderImpl implements Builder {
        private String amplifyFeatureFlags;

        private String amplifyMetaConfig;

        private String appId;

        private String appName;

        private List<String> backendEnvironmentList = DefaultSdkAutoConstructList.getInstance();

        private String backendEnvironmentName;

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendResponse model) {
            super(model);
            amplifyFeatureFlags(model.amplifyFeatureFlags);
            amplifyMetaConfig(model.amplifyMetaConfig);
            appId(model.appId);
            appName(model.appName);
            backendEnvironmentList(model.backendEnvironmentList);
            backendEnvironmentName(model.backendEnvironmentName);
            error(model.error);
        }

        public final String getAmplifyFeatureFlags() {
            return amplifyFeatureFlags;
        }

        public final void setAmplifyFeatureFlags(String amplifyFeatureFlags) {
            this.amplifyFeatureFlags = amplifyFeatureFlags;
        }

        @Override
        public final Builder amplifyFeatureFlags(String amplifyFeatureFlags) {
            this.amplifyFeatureFlags = amplifyFeatureFlags;
            return this;
        }

        public final String getAmplifyMetaConfig() {
            return amplifyMetaConfig;
        }

        public final void setAmplifyMetaConfig(String amplifyMetaConfig) {
            this.amplifyMetaConfig = amplifyMetaConfig;
        }

        @Override
        public final Builder amplifyMetaConfig(String amplifyMetaConfig) {
            this.amplifyMetaConfig = amplifyMetaConfig;
            return this;
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppName() {
            return appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final Collection<String> getBackendEnvironmentList() {
            if (backendEnvironmentList instanceof SdkAutoConstructList) {
                return null;
            }
            return backendEnvironmentList;
        }

        public final void setBackendEnvironmentList(Collection<String> backendEnvironmentList) {
            this.backendEnvironmentList = ListOf__stringCopier.copy(backendEnvironmentList);
        }

        @Override
        public final Builder backendEnvironmentList(Collection<String> backendEnvironmentList) {
            this.backendEnvironmentList = ListOf__stringCopier.copy(backendEnvironmentList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendEnvironmentList(String... backendEnvironmentList) {
            backendEnvironmentList(Arrays.asList(backendEnvironmentList));
            return this;
        }

        public final String getBackendEnvironmentName() {
            return backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public GetBackendResponse build() {
            return new GetBackendResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
