/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request body for ImportBackendAuth.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportBackendAuthRequest extends AmplifyBackendRequest implements
        ToCopyableBuilder<ImportBackendAuthRequest.Builder, ImportBackendAuthRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(ImportBackendAuthRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackendEnvironmentName").getter(getter(ImportBackendAuthRequest::backendEnvironmentName))
            .setter(setter(Builder::backendEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backendEnvironmentName").build())
            .build();

    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(ImportBackendAuthRequest::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityPoolId").build()).build();

    private static final SdkField<String> NATIVE_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NativeClientId").getter(getter(ImportBackendAuthRequest::nativeClientId))
            .setter(setter(Builder::nativeClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nativeClientId").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(ImportBackendAuthRequest::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolId").build()).build();

    private static final SdkField<String> WEB_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebClientId").getter(getter(ImportBackendAuthRequest::webClientId)).setter(setter(Builder::webClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webClientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BACKEND_ENVIRONMENT_NAME_FIELD, IDENTITY_POOL_ID_FIELD, NATIVE_CLIENT_ID_FIELD, USER_POOL_ID_FIELD,
            WEB_CLIENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appId;

    private final String backendEnvironmentName;

    private final String identityPoolId;

    private final String nativeClientId;

    private final String userPoolId;

    private final String webClientId;

    private ImportBackendAuthRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.identityPoolId = builder.identityPoolId;
        this.nativeClientId = builder.nativeClientId;
        this.userPoolId = builder.userPoolId;
        this.webClientId = builder.webClientId;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment.
     * </p>
     * 
     * @return The name of the backend environment.
     */
    public final String backendEnvironmentName() {
        return backendEnvironmentName;
    }

    /**
     * <p>
     * The ID of the Amazon Cognito identity pool.
     * </p>
     * 
     * @return The ID of the Amazon Cognito identity pool.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The ID of the Amazon Cognito native client.
     * </p>
     * 
     * @return The ID of the Amazon Cognito native client.
     */
    public final String nativeClientId() {
        return nativeClientId;
    }

    /**
     * <p>
     * The ID of the Amazon Cognito user pool.
     * </p>
     * 
     * @return The ID of the Amazon Cognito user pool.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The ID of the Amazon Cognito web client.
     * </p>
     * 
     * @return The ID of the Amazon Cognito web client.
     */
    public final String webClientId() {
        return webClientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(nativeClientId());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(webClientId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportBackendAuthRequest)) {
            return false;
        }
        ImportBackendAuthRequest other = (ImportBackendAuthRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(backendEnvironmentName(), other.backendEnvironmentName())
                && Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(nativeClientId(), other.nativeClientId()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(webClientId(), other.webClientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportBackendAuthRequest").add("AppId", appId())
                .add("BackendEnvironmentName", backendEnvironmentName()).add("IdentityPoolId", identityPoolId())
                .add("NativeClientId", nativeClientId()).add("UserPoolId", userPoolId()).add("WebClientId", webClientId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "BackendEnvironmentName":
            return Optional.ofNullable(clazz.cast(backendEnvironmentName()));
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "NativeClientId":
            return Optional.ofNullable(clazz.cast(nativeClientId()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "WebClientId":
            return Optional.ofNullable(clazz.cast(webClientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("appId", APP_ID_FIELD);
        map.put("backendEnvironmentName", BACKEND_ENVIRONMENT_NAME_FIELD);
        map.put("identityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("nativeClientId", NATIVE_CLIENT_ID_FIELD);
        map.put("userPoolId", USER_POOL_ID_FIELD);
        map.put("webClientId", WEB_CLIENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportBackendAuthRequest, T> g) {
        return obj -> g.apply((ImportBackendAuthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AmplifyBackendRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportBackendAuthRequest> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment.
         * </p>
         * 
         * @param backendEnvironmentName
         *        The name of the backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentName(String backendEnvironmentName);

        /**
         * <p>
         * The ID of the Amazon Cognito identity pool.
         * </p>
         * 
         * @param identityPoolId
         *        The ID of the Amazon Cognito identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The ID of the Amazon Cognito native client.
         * </p>
         * 
         * @param nativeClientId
         *        The ID of the Amazon Cognito native client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nativeClientId(String nativeClientId);

        /**
         * <p>
         * The ID of the Amazon Cognito user pool.
         * </p>
         * 
         * @param userPoolId
         *        The ID of the Amazon Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The ID of the Amazon Cognito web client.
         * </p>
         * 
         * @param webClientId
         *        The ID of the Amazon Cognito web client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webClientId(String webClientId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyBackendRequest.BuilderImpl implements Builder {
        private String appId;

        private String backendEnvironmentName;

        private String identityPoolId;

        private String nativeClientId;

        private String userPoolId;

        private String webClientId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportBackendAuthRequest model) {
            super(model);
            appId(model.appId);
            backendEnvironmentName(model.backendEnvironmentName);
            identityPoolId(model.identityPoolId);
            nativeClientId(model.nativeClientId);
            userPoolId(model.userPoolId);
            webClientId(model.webClientId);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendEnvironmentName() {
            return backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getNativeClientId() {
            return nativeClientId;
        }

        public final void setNativeClientId(String nativeClientId) {
            this.nativeClientId = nativeClientId;
        }

        @Override
        public final Builder nativeClientId(String nativeClientId) {
            this.nativeClientId = nativeClientId;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getWebClientId() {
            return webClientId;
        }

        public final void setWebClientId(String webClientId) {
            this.webClientId = webClientId;
        }

        @Override
        public final Builder webClientId(String webClientId) {
            this.webClientId = webClientId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportBackendAuthRequest build() {
            return new ImportBackendAuthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
