/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the password policy for your Amazon Cognito user pool configured as a part of your Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendAuthPasswordPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateBackendAuthPasswordPolicyConfig.Builder, UpdateBackendAuthPasswordPolicyConfig> {
    private static final SdkField<List<String>> ADDITIONAL_CONSTRAINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalConstraints")
            .getter(getter(UpdateBackendAuthPasswordPolicyConfig::additionalConstraintsAsStrings))
            .setter(setter(Builder::additionalConstraintsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> MINIMUM_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinimumLength").getter(getter(UpdateBackendAuthPasswordPolicyConfig::minimumLength))
            .setter(setter(Builder::minimumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_CONSTRAINTS_FIELD,
            MINIMUM_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> additionalConstraints;

    private final Double minimumLength;

    private UpdateBackendAuthPasswordPolicyConfig(BuilderImpl builder) {
        this.additionalConstraints = builder.additionalConstraints;
        this.minimumLength = builder.minimumLength;
    }

    /**
     * <p>
     * Describes additional constraints on password requirements to sign in to the auth resource, configured as a part
     * of your Amplify project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalConstraints} method.
     * </p>
     * 
     * @return Describes additional constraints on password requirements to sign in to the auth resource, configured as
     *         a part of your Amplify project.
     */
    public final List<AdditionalConstraintsElement> additionalConstraints() {
        return ListOfAdditionalConstraintsElementCopier.copyStringToEnum(additionalConstraints);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalConstraints property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalConstraints() {
        return additionalConstraints != null && !(additionalConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes additional constraints on password requirements to sign in to the auth resource, configured as a part
     * of your Amplify project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalConstraints} method.
     * </p>
     * 
     * @return Describes additional constraints on password requirements to sign in to the auth resource, configured as
     *         a part of your Amplify project.
     */
    public final List<String> additionalConstraintsAsStrings() {
        return additionalConstraints;
    }

    /**
     * <p>
     * Describes the minimum length of the password required to sign in to the auth resource, configured as a part of
     * your Amplify project.
     * </p>
     * 
     * @return Describes the minimum length of the password required to sign in to the auth resource, configured as a
     *         part of your Amplify project.
     */
    public final Double minimumLength() {
        return minimumLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalConstraints() ? additionalConstraintsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minimumLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthPasswordPolicyConfig)) {
            return false;
        }
        UpdateBackendAuthPasswordPolicyConfig other = (UpdateBackendAuthPasswordPolicyConfig) obj;
        return hasAdditionalConstraints() == other.hasAdditionalConstraints()
                && Objects.equals(additionalConstraintsAsStrings(), other.additionalConstraintsAsStrings())
                && Objects.equals(minimumLength(), other.minimumLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendAuthPasswordPolicyConfig")
                .add("AdditionalConstraints", hasAdditionalConstraints() ? additionalConstraintsAsStrings() : null)
                .add("MinimumLength", minimumLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalConstraints":
            return Optional.ofNullable(clazz.cast(additionalConstraintsAsStrings()));
        case "MinimumLength":
            return Optional.ofNullable(clazz.cast(minimumLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalConstraints", ADDITIONAL_CONSTRAINTS_FIELD);
        map.put("minimumLength", MINIMUM_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthPasswordPolicyConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthPasswordPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateBackendAuthPasswordPolicyConfig> {
        /**
         * <p>
         * Describes additional constraints on password requirements to sign in to the auth resource, configured as a
         * part of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Describes additional constraints on password requirements to sign in to the auth resource, configured
         *        as a part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraintsWithStrings(Collection<String> additionalConstraints);

        /**
         * <p>
         * Describes additional constraints on password requirements to sign in to the auth resource, configured as a
         * part of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Describes additional constraints on password requirements to sign in to the auth resource, configured
         *        as a part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraintsWithStrings(String... additionalConstraints);

        /**
         * <p>
         * Describes additional constraints on password requirements to sign in to the auth resource, configured as a
         * part of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Describes additional constraints on password requirements to sign in to the auth resource, configured
         *        as a part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraints(Collection<AdditionalConstraintsElement> additionalConstraints);

        /**
         * <p>
         * Describes additional constraints on password requirements to sign in to the auth resource, configured as a
         * part of your Amplify project.
         * </p>
         * 
         * @param additionalConstraints
         *        Describes additional constraints on password requirements to sign in to the auth resource, configured
         *        as a part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConstraints(AdditionalConstraintsElement... additionalConstraints);

        /**
         * <p>
         * Describes the minimum length of the password required to sign in to the auth resource, configured as a part
         * of your Amplify project.
         * </p>
         * 
         * @param minimumLength
         *        Describes the minimum length of the password required to sign in to the auth resource, configured as a
         *        part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLength(Double minimumLength);
    }

    static final class BuilderImpl implements Builder {
        private List<String> additionalConstraints = DefaultSdkAutoConstructList.getInstance();

        private Double minimumLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthPasswordPolicyConfig model) {
            additionalConstraintsWithStrings(model.additionalConstraints);
            minimumLength(model.minimumLength);
        }

        public final Collection<String> getAdditionalConstraints() {
            if (additionalConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalConstraints;
        }

        public final void setAdditionalConstraints(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
        }

        @Override
        public final Builder additionalConstraintsWithStrings(Collection<String> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copy(additionalConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConstraintsWithStrings(String... additionalConstraints) {
            additionalConstraintsWithStrings(Arrays.asList(additionalConstraints));
            return this;
        }

        @Override
        public final Builder additionalConstraints(Collection<AdditionalConstraintsElement> additionalConstraints) {
            this.additionalConstraints = ListOfAdditionalConstraintsElementCopier.copyEnumToString(additionalConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConstraints(AdditionalConstraintsElement... additionalConstraints) {
            additionalConstraints(Arrays.asList(additionalConstraints));
            return this;
        }

        public final Double getMinimumLength() {
            return minimumLength;
        }

        public final void setMinimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
        }

        @Override
        public final Builder minimumLength(Double minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        @Override
        public UpdateBackendAuthPasswordPolicyConfig build() {
            return new UpdateBackendAuthPasswordPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
