/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderException;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.InternalServerException;
import software.amazon.awssdk.services.amplifyuibuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ResourceConflictException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable;

/**
 * Service client for accessing AWS Amplify UI Builder. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Amplify UI Builder API provides a programmatic interface for creating and configuring user interface (UI)
 * component libraries and themes for use in your Amplify applications. You can then connect these UI components to an
 * application's backend Amazon Web Services resources.
 * </p>
 * <p>
 * You can also use the Amplify Studio visual designer to create UI components and model data for an app. For more
 * information, see <a href="https://docs.amplify.aws/console/adminui/intro">Introduction</a> in the <i>Amplify
 * Docs</i>.
 * </p>
 * <p>
 * The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development.
 * For more information, see the <a href="https://docs.amplify.aws/">Amplify Framework</a>. For more information about
 * deploying an Amplify application to Amazon Web Services, see the <a
 * href="https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html">Amplify Console User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AmplifyUiBuilderClient extends SdkClient {
    String SERVICE_NAME = "amplifyuibuilder";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "amplifyuibuilder";

    /**
     * Create a {@link AmplifyUiBuilderClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AmplifyUiBuilderClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AmplifyUiBuilderClient}.
     */
    static AmplifyUiBuilderClientBuilder builder() {
        return new DefaultAmplifyUiBuilderClientBuilder();
    }

    /**
     * <p>
     * Creates a new component for an Amplify app.
     * </p>
     *
     * @param createComponentRequest
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new component for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateComponentRequest#builder()}
     * </p>
     *
     * @param createComponentRequest
     *        A {@link Consumer} that will call methods on {@link CreateComponentRequest.Builder} to create a request.
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentResponse createComponent(Consumer<CreateComponentRequest.Builder> createComponentRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return createComponent(CreateComponentRequest.builder().applyMutation(createComponentRequest).build());
    }

    /**
     * <p>
     * Creates a theme to apply to the components in an Amplify app.
     * </p>
     *
     * @param createThemeRequest
     * @return Result of the CreateTheme operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateThemeResponse createTheme(CreateThemeRequest createThemeRequest) throws ServiceQuotaExceededException,
            ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a theme to apply to the components in an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateThemeRequest#builder()}
     * </p>
     *
     * @param createThemeRequest
     *        A {@link Consumer} that will call methods on {@link CreateThemeRequest.Builder} to create a request.
     * @return Result of the CreateTheme operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateThemeResponse createTheme(Consumer<CreateThemeRequest.Builder> createThemeRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return createTheme(CreateThemeRequest.builder().applyMutation(createThemeRequest).build());
    }

    /**
     * <p>
     * Deletes a component from an Amplify app.
     * </p>
     *
     * @param deleteComponentRequest
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a component from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteComponentRequest.Builder} to create a request.
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(Consumer<DeleteComponentRequest.Builder> deleteComponentRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a theme from an Amplify app.
     * </p>
     *
     * @param deleteThemeRequest
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteThemeResponse deleteTheme(DeleteThemeRequest deleteThemeRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a theme from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThemeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteThemeRequest#builder()}
     * </p>
     *
     * @param deleteThemeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThemeRequest.Builder} to create a request.
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteThemeResponse deleteTheme(Consumer<DeleteThemeRequest.Builder> deleteThemeRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return deleteTheme(DeleteThemeRequest.builder().applyMutation(deleteThemeRequest).build());
    }

    /**
     * <p>
     * Exchanges an access code for a token.
     * </p>
     *
     * @param exchangeCodeForTokenRequest
     * @return Result of the ExchangeCodeForToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExchangeCodeForToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken"
     *      target="_top">AWS API Documentation</a>
     */
    default ExchangeCodeForTokenResponse exchangeCodeForToken(ExchangeCodeForTokenRequest exchangeCodeForTokenRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exchanges an access code for a token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExchangeCodeForTokenRequest.Builder} avoiding the
     * need to create one manually via {@link ExchangeCodeForTokenRequest#builder()}
     * </p>
     *
     * @param exchangeCodeForTokenRequest
     *        A {@link Consumer} that will call methods on {@link ExchangeCodeForTokenRequest.Builder} to create a
     *        request.
     * @return Result of the ExchangeCodeForToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExchangeCodeForToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken"
     *      target="_top">AWS API Documentation</a>
     */
    default ExchangeCodeForTokenResponse exchangeCodeForToken(
            Consumer<ExchangeCodeForTokenRequest.Builder> exchangeCodeForTokenRequest) throws InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return exchangeCodeForToken(ExchangeCodeForTokenRequest.builder().applyMutation(exchangeCodeForTokenRequest).build());
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportComponentsRequest
     * @return Result of the ExportComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsResponse exportComponents(ExportComponentsRequest exportComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportComponentsRequest.Builder} avoiding the need
     * to create one manually via {@link ExportComponentsRequest#builder()}
     * </p>
     *
     * @param exportComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ExportComponentsRequest.Builder} to create a request.
     * @return Result of the ExportComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsResponse exportComponents(Consumer<ExportComponentsRequest.Builder> exportComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportComponents(ExportComponentsRequest.builder().applyMutation(exportComponentsRequest).build());
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportThemesRequest
     * @return Result of the ExportThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesResponse exportThemes(ExportThemesRequest exportThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ExportThemesRequest#builder()}
     * </p>
     *
     * @param exportThemesRequest
     *        A {@link Consumer} that will call methods on {@link ExportThemesRequest.Builder} to create a request.
     * @return Result of the ExportThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesResponse exportThemes(Consumer<ExportThemesRequest.Builder> exportThemesRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportThemes(ExportThemesRequest.builder().applyMutation(exportThemesRequest).build());
    }

    /**
     * <p>
     * Returns an existing component for an Amplify app.
     * </p>
     *
     * @param getComponentRequest
     * @return Result of the GetComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing component for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentRequest.Builder} to create a request.
     * @return Result of the GetComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComponentResponse getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Returns an existing theme for an Amplify app.
     * </p>
     *
     * @param getThemeRequest
     * @return Result of the GetTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default GetThemeResponse getTheme(GetThemeRequest getThemeRequest) throws InternalServerException, InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing theme for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetThemeRequest.Builder} avoiding the need to
     * create one manually via {@link GetThemeRequest#builder()}
     * </p>
     *
     * @param getThemeRequest
     *        A {@link Consumer} that will call methods on {@link GetThemeRequest.Builder} to create a request.
     * @return Result of the GetTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default GetThemeResponse getTheme(Consumer<GetThemeRequest.Builder> getThemeRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return getTheme(GetThemeRequest.builder().applyMutation(getThemeRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return Result of the ListComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsResponse listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listThemesRequest
     * @return Result of the ListThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesResponse listThemes(ListThemesRequest listThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThemesRequest#builder()}
     * </p>
     *
     * @param listThemesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemesRequest.Builder} to create a request.
     * @return Result of the ListThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesResponse listThemes(Consumer<ListThemesRequest.Builder> listThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return listThemes(ListThemesRequest.builder().applyMutation(listThemesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client
     *             .listThemesPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation.</b>
     * </p>
     *
     * @param listThemesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesIterable listThemesPaginator(ListThemesRequest listThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client
     *             .listThemesPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThemesRequest#builder()}
     * </p>
     *
     * @param listThemesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesIterable listThemesPaginator(Consumer<ListThemesRequest.Builder> listThemesRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return listThemesPaginator(ListThemesRequest.builder().applyMutation(listThemesRequest).build());
    }

    /**
     * <p>
     * Refreshes a previously issued access token that might have expired.
     * </p>
     *
     * @param refreshTokenRequest
     * @return Result of the RefreshToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.RefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken" target="_top">AWS
     *      API Documentation</a>
     */
    default RefreshTokenResponse refreshToken(RefreshTokenRequest refreshTokenRequest) throws InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Refreshes a previously issued access token that might have expired.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshTokenRequest.Builder} avoiding the need to
     * create one manually via {@link RefreshTokenRequest#builder()}
     * </p>
     *
     * @param refreshTokenRequest
     *        A {@link Consumer} that will call methods on {@link RefreshTokenRequest.Builder} to create a request.
     * @return Result of the RefreshToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.RefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken" target="_top">AWS
     *      API Documentation</a>
     */
    default RefreshTokenResponse refreshToken(Consumer<RefreshTokenRequest.Builder> refreshTokenRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return refreshToken(RefreshTokenRequest.builder().applyMutation(refreshTokenRequest).build());
    }

    /**
     * <p>
     * Updates an existing component.
     * </p>
     *
     * @param updateComponentRequest
     * @return Result of the UpdateComponent operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentResponse updateComponent(UpdateComponentRequest updateComponentRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateComponentRequest#builder()}
     * </p>
     *
     * @param updateComponentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateComponentRequest.Builder} to create a request.
     * @return Result of the UpdateComponent operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentResponse updateComponent(Consumer<UpdateComponentRequest.Builder> updateComponentRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return updateComponent(UpdateComponentRequest.builder().applyMutation(updateComponentRequest).build());
    }

    /**
     * <p>
     * Updates an existing theme.
     * </p>
     *
     * @param updateThemeRequest
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateThemeResponse updateTheme(UpdateThemeRequest updateThemeRequest) throws ResourceConflictException,
            InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateThemeRequest#builder()}
     * </p>
     *
     * @param updateThemeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThemeRequest.Builder} to create a request.
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateThemeResponse updateTheme(Consumer<UpdateThemeRequest.Builder> updateThemeRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return updateTheme(UpdateThemeRequest.builder().applyMutation(updateThemeRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
