/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data binding configuration for a specific property using data stored in Amazon Web Services. For
 * Amazon Web Services connected properties, you can bind a property to data stored in an Amazon S3 bucket, an Amplify
 * DataStore model or an authenticated user attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentBindingPropertiesValueProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentBindingPropertiesValueProperties.Builder, ComponentBindingPropertiesValueProperties> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("bucket")
            .getter(getter(ComponentBindingPropertiesValueProperties::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(ComponentBindingPropertiesValueProperties::defaultValue))
            .setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(ComponentBindingPropertiesValueProperties::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(ComponentBindingPropertiesValueProperties::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("model")
            .getter(getter(ComponentBindingPropertiesValueProperties::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<List<Predicate>> PREDICATES_FIELD = SdkField
            .<List<Predicate>> builder(MarshallingType.LIST)
            .memberName("predicates")
            .getter(getter(ComponentBindingPropertiesValueProperties::predicates))
            .setter(setter(Builder::predicates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Predicate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAttribute").getter(getter(ComponentBindingPropertiesValueProperties::userAttribute))
            .setter(setter(Builder::userAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            DEFAULT_VALUE_FIELD, FIELD_FIELD, KEY_FIELD, MODEL_FIELD, PREDICATES_FIELD, USER_ATTRIBUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String defaultValue;

    private final String field;

    private final String key;

    private final String model;

    private final List<Predicate> predicates;

    private final String userAttribute;

    private ComponentBindingPropertiesValueProperties(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.defaultValue = builder.defaultValue;
        this.field = builder.field;
        this.key = builder.key;
        this.model = builder.model;
        this.predicates = builder.predicates;
        this.userAttribute = builder.userAttribute;
    }

    /**
     * <p>
     * An Amazon S3 bucket.
     * </p>
     * 
     * @return An Amazon S3 bucket.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The default value to assign to the property.
     * </p>
     * 
     * @return The default value to assign to the property.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The field to bind the data to.
     * </p>
     * 
     * @return The field to bind the data to.
     */
    public final String field() {
        return field;
    }

    /**
     * <p>
     * The storage key for an Amazon S3 bucket.
     * </p>
     * 
     * @return The storage key for an Amazon S3 bucket.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * An Amplify DataStore model.
     * </p>
     * 
     * @return An Amplify DataStore model.
     */
    public final String model() {
        return model;
    }

    /**
     * For responses, this returns true if the service returned a value for the Predicates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPredicates() {
        return predicates != null && !(predicates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of predicates for binding a component's properties to data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredicates} method.
     * </p>
     * 
     * @return A list of predicates for binding a component's properties to data.
     */
    public final List<Predicate> predicates() {
        return predicates;
    }

    /**
     * <p>
     * An authenticated user attribute.
     * </p>
     * 
     * @return An authenticated user attribute.
     */
    public final String userAttribute() {
        return userAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(hasPredicates() ? predicates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentBindingPropertiesValueProperties)) {
            return false;
        }
        ComponentBindingPropertiesValueProperties other = (ComponentBindingPropertiesValueProperties) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(field(), other.field()) && Objects.equals(key(), other.key())
                && Objects.equals(model(), other.model()) && hasPredicates() == other.hasPredicates()
                && Objects.equals(predicates(), other.predicates()) && Objects.equals(userAttribute(), other.userAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentBindingPropertiesValueProperties").add("Bucket", bucket())
                .add("DefaultValue", defaultValue()).add("Field", field()).add("Key", key()).add("Model", model())
                .add("Predicates", hasPredicates() ? predicates() : null).add("UserAttribute", userAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "field":
            return Optional.ofNullable(clazz.cast(field()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "predicates":
            return Optional.ofNullable(clazz.cast(predicates()));
        case "userAttribute":
            return Optional.ofNullable(clazz.cast(userAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentBindingPropertiesValueProperties, T> g) {
        return obj -> g.apply((ComponentBindingPropertiesValueProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentBindingPropertiesValueProperties> {
        /**
         * <p>
         * An Amazon S3 bucket.
         * </p>
         * 
         * @param bucket
         *        An Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The default value to assign to the property.
         * </p>
         * 
         * @param defaultValue
         *        The default value to assign to the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The field to bind the data to.
         * </p>
         * 
         * @param field
         *        The field to bind the data to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * The storage key for an Amazon S3 bucket.
         * </p>
         * 
         * @param key
         *        The storage key for an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * An Amplify DataStore model.
         * </p>
         * 
         * @param model
         *        An Amplify DataStore model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * A list of predicates for binding a component's properties to data.
         * </p>
         * 
         * @param predicates
         *        A list of predicates for binding a component's properties to data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicates(Collection<Predicate> predicates);

        /**
         * <p>
         * A list of predicates for binding a component's properties to data.
         * </p>
         * 
         * @param predicates
         *        A list of predicates for binding a component's properties to data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicates(Predicate... predicates);

        /**
         * <p>
         * A list of predicates for binding a component's properties to data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Predicate>.Builder} avoiding the need to
         * create one manually via {@link List<Predicate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Predicate>.Builder#build()} is called immediately and its
         * result is passed to {@link #predicates(List<Predicate>)}.
         * 
         * @param predicates
         *        a consumer that will call methods on {@link List<Predicate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicates(List<Predicate>)
         */
        Builder predicates(Consumer<Predicate.Builder>... predicates);

        /**
         * <p>
         * An authenticated user attribute.
         * </p>
         * 
         * @param userAttribute
         *        An authenticated user attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttribute(String userAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String defaultValue;

        private String field;

        private String key;

        private String model;

        private List<Predicate> predicates = DefaultSdkAutoConstructList.getInstance();

        private String userAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentBindingPropertiesValueProperties model) {
            bucket(model.bucket);
            defaultValue(model.defaultValue);
            field(model.field);
            key(model.key);
            model(model.model);
            predicates(model.predicates);
            userAttribute(model.userAttribute);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        @Transient
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Transient
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        @Transient
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        @Transient
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final List<Predicate.Builder> getPredicates() {
            List<Predicate.Builder> result = PredicateListCopier.copyToBuilder(this.predicates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredicates(Collection<Predicate.BuilderImpl> predicates) {
            this.predicates = PredicateListCopier.copyFromBuilder(predicates);
        }

        @Override
        @Transient
        public final Builder predicates(Collection<Predicate> predicates) {
            this.predicates = PredicateListCopier.copy(predicates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder predicates(Predicate... predicates) {
            predicates(Arrays.asList(predicates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder predicates(Consumer<Predicate.Builder>... predicates) {
            predicates(Stream.of(predicates).map(c -> Predicate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserAttribute() {
            return userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        @Transient
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        @Override
        public ComponentBindingPropertiesValueProperties build() {
            return new ComponentBindingPropertiesValueProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
