/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for all of a component's properties. Use <code>ComponentProperty</code> to specify the
 * values to render or bind by default.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentProperty.Builder, ComponentProperty> {
    private static final SdkField<ComponentPropertyBindingProperties> BINDING_PROPERTIES_FIELD = SdkField
            .<ComponentPropertyBindingProperties> builder(MarshallingType.SDK_POJO).memberName("bindingProperties")
            .getter(getter(ComponentProperty::bindingProperties)).setter(setter(Builder::bindingProperties))
            .constructor(ComponentPropertyBindingProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingProperties").build()).build();

    private static final SdkField<Map<String, FormBindingElement>> BINDINGS_FIELD = SdkField
            .<Map<String, FormBindingElement>> builder(MarshallingType.MAP)
            .memberName("bindings")
            .getter(getter(ComponentProperty::bindings))
            .setter(setter(Builder::bindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FormBindingElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormBindingElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ComponentPropertyBindingProperties> COLLECTION_BINDING_PROPERTIES_FIELD = SdkField
            .<ComponentPropertyBindingProperties> builder(MarshallingType.SDK_POJO)
            .memberName("collectionBindingProperties")
            .getter(getter(ComponentProperty::collectionBindingProperties))
            .setter(setter(Builder::collectionBindingProperties))
            .constructor(ComponentPropertyBindingProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionBindingProperties")
                    .build()).build();

    private static final SdkField<List<ComponentProperty>> CONCAT_FIELD = SdkField
            .<List<ComponentProperty>> builder(MarshallingType.LIST)
            .memberName("concat")
            .getter(getter(ComponentProperty::concat))
            .setter(setter(Builder::concat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concat").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ComponentConditionProperty> CONDITION_FIELD = SdkField
            .<ComponentConditionProperty> builder(MarshallingType.SDK_POJO).memberName("condition")
            .getter(getter(ComponentProperty::condition)).setter(setter(Builder::condition))
            .constructor(ComponentConditionProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final SdkField<Boolean> CONFIGURED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("configured").getter(getter(ComponentProperty::configured)).setter(setter(Builder::configured))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configured").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(ComponentProperty::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("event")
            .getter(getter(ComponentProperty::event)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<String> IMPORTED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedValue").getter(getter(ComponentProperty::importedValue)).setter(setter(Builder::importedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedValue").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("model")
            .getter(getter(ComponentProperty::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ComponentProperty::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAttribute").getter(getter(ComponentProperty::userAttribute)).setter(setter(Builder::userAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(ComponentProperty::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BINDING_PROPERTIES_FIELD,
            BINDINGS_FIELD, COLLECTION_BINDING_PROPERTIES_FIELD, CONCAT_FIELD, CONDITION_FIELD, CONFIGURED_FIELD,
            DEFAULT_VALUE_FIELD, EVENT_FIELD, IMPORTED_VALUE_FIELD, MODEL_FIELD, TYPE_FIELD, USER_ATTRIBUTE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ComponentPropertyBindingProperties bindingProperties;

    private final Map<String, FormBindingElement> bindings;

    private final ComponentPropertyBindingProperties collectionBindingProperties;

    private final List<ComponentProperty> concat;

    private final ComponentConditionProperty condition;

    private final Boolean configured;

    private final String defaultValue;

    private final String event;

    private final String importedValue;

    private final String model;

    private final String type;

    private final String userAttribute;

    private final String value;

    private ComponentProperty(BuilderImpl builder) {
        this.bindingProperties = builder.bindingProperties;
        this.bindings = builder.bindings;
        this.collectionBindingProperties = builder.collectionBindingProperties;
        this.concat = builder.concat;
        this.condition = builder.condition;
        this.configured = builder.configured;
        this.defaultValue = builder.defaultValue;
        this.event = builder.event;
        this.importedValue = builder.importedValue;
        this.model = builder.model;
        this.type = builder.type;
        this.userAttribute = builder.userAttribute;
        this.value = builder.value;
    }

    /**
     * <p>
     * The information to bind the component property to data at runtime.
     * </p>
     * 
     * @return The information to bind the component property to data at runtime.
     */
    public final ComponentPropertyBindingProperties bindingProperties() {
        return bindingProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Bindings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBindings() {
        return bindings != null && !(bindings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The information to bind the component property to form data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBindings} method.
     * </p>
     * 
     * @return The information to bind the component property to form data.
     */
    public final Map<String, FormBindingElement> bindings() {
        return bindings;
    }

    /**
     * <p>
     * The information to bind the component property to data at runtime. Use this for collection components.
     * </p>
     * 
     * @return The information to bind the component property to data at runtime. Use this for collection components.
     */
    public final ComponentPropertyBindingProperties collectionBindingProperties() {
        return collectionBindingProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Concat property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConcat() {
        return concat != null && !(concat instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of component properties to concatenate to create the value to assign to this component property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConcat} method.
     * </p>
     * 
     * @return A list of component properties to concatenate to create the value to assign to this component property.
     */
    public final List<ComponentProperty> concat() {
        return concat;
    }

    /**
     * <p>
     * The conditional expression to use to assign a value to the component property..
     * </p>
     * 
     * @return The conditional expression to use to assign a value to the component property..
     */
    public final ComponentConditionProperty condition() {
        return condition;
    }

    /**
     * <p>
     * Specifies whether the user configured the property in Amplify Studio after importing it.
     * </p>
     * 
     * @return Specifies whether the user configured the property in Amplify Studio after importing it.
     */
    public final Boolean configured() {
        return configured;
    }

    /**
     * <p>
     * The default value to assign to the component property.
     * </p>
     * 
     * @return The default value to assign to the component property.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * An event that occurs in your app. Use this for workflow data binding.
     * </p>
     * 
     * @return An event that occurs in your app. Use this for workflow data binding.
     */
    public final String event() {
        return event;
    }

    /**
     * <p>
     * The default value assigned to property when the component is imported into an app.
     * </p>
     * 
     * @return The default value assigned to property when the component is imported into an app.
     */
    public final String importedValue() {
        return importedValue;
    }

    /**
     * <p>
     * The data model to use to assign a value to the component property.
     * </p>
     * 
     * @return The data model to use to assign a value to the component property.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The component type.
     * </p>
     * 
     * @return The component type.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * An authenticated user attribute to use to assign a value to the component property.
     * </p>
     * 
     * @return An authenticated user attribute to use to assign a value to the component property.
     */
    public final String userAttribute() {
        return userAttribute;
    }

    /**
     * <p>
     * The value to assign to the component property.
     * </p>
     * 
     * @return The value to assign to the component property.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bindingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasBindings() ? bindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(collectionBindingProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasConcat() ? concat() : null);
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(configured());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(importedValue());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(userAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentProperty)) {
            return false;
        }
        ComponentProperty other = (ComponentProperty) obj;
        return Objects.equals(bindingProperties(), other.bindingProperties()) && hasBindings() == other.hasBindings()
                && Objects.equals(bindings(), other.bindings())
                && Objects.equals(collectionBindingProperties(), other.collectionBindingProperties())
                && hasConcat() == other.hasConcat() && Objects.equals(concat(), other.concat())
                && Objects.equals(condition(), other.condition()) && Objects.equals(configured(), other.configured())
                && Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(event(), other.event())
                && Objects.equals(importedValue(), other.importedValue()) && Objects.equals(model(), other.model())
                && Objects.equals(type(), other.type()) && Objects.equals(userAttribute(), other.userAttribute())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentProperty").add("BindingProperties", bindingProperties())
                .add("Bindings", hasBindings() ? bindings() : null)
                .add("CollectionBindingProperties", collectionBindingProperties()).add("Concat", hasConcat() ? concat() : null)
                .add("Condition", condition()).add("Configured", configured()).add("DefaultValue", defaultValue())
                .add("Event", event()).add("ImportedValue", importedValue()).add("Model", model()).add("Type", type())
                .add("UserAttribute", userAttribute()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bindingProperties":
            return Optional.ofNullable(clazz.cast(bindingProperties()));
        case "bindings":
            return Optional.ofNullable(clazz.cast(bindings()));
        case "collectionBindingProperties":
            return Optional.ofNullable(clazz.cast(collectionBindingProperties()));
        case "concat":
            return Optional.ofNullable(clazz.cast(concat()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "configured":
            return Optional.ofNullable(clazz.cast(configured()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "event":
            return Optional.ofNullable(clazz.cast(event()));
        case "importedValue":
            return Optional.ofNullable(clazz.cast(importedValue()));
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "userAttribute":
            return Optional.ofNullable(clazz.cast(userAttribute()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentProperty, T> g) {
        return obj -> g.apply((ComponentProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentProperty> {
        /**
         * <p>
         * The information to bind the component property to data at runtime.
         * </p>
         * 
         * @param bindingProperties
         *        The information to bind the component property to data at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bindingProperties(ComponentPropertyBindingProperties bindingProperties);

        /**
         * <p>
         * The information to bind the component property to data at runtime.
         * </p>
         * This is a convenience that creates an instance of the {@link ComponentPropertyBindingProperties.Builder}
         * avoiding the need to create one manually via {@link ComponentPropertyBindingProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComponentPropertyBindingProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #bindingProperties(ComponentPropertyBindingProperties)}.
         * 
         * @param bindingProperties
         *        a consumer that will call methods on {@link ComponentPropertyBindingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bindingProperties(ComponentPropertyBindingProperties)
         */
        default Builder bindingProperties(Consumer<ComponentPropertyBindingProperties.Builder> bindingProperties) {
            return bindingProperties(ComponentPropertyBindingProperties.builder().applyMutation(bindingProperties).build());
        }

        /**
         * <p>
         * The information to bind the component property to form data.
         * </p>
         * 
         * @param bindings
         *        The information to bind the component property to form data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bindings(Map<String, FormBindingElement> bindings);

        /**
         * <p>
         * The information to bind the component property to data at runtime. Use this for collection components.
         * </p>
         * 
         * @param collectionBindingProperties
         *        The information to bind the component property to data at runtime. Use this for collection components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionBindingProperties(ComponentPropertyBindingProperties collectionBindingProperties);

        /**
         * <p>
         * The information to bind the component property to data at runtime. Use this for collection components.
         * </p>
         * This is a convenience that creates an instance of the {@link ComponentPropertyBindingProperties.Builder}
         * avoiding the need to create one manually via {@link ComponentPropertyBindingProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComponentPropertyBindingProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #collectionBindingProperties(ComponentPropertyBindingProperties)}.
         * 
         * @param collectionBindingProperties
         *        a consumer that will call methods on {@link ComponentPropertyBindingProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectionBindingProperties(ComponentPropertyBindingProperties)
         */
        default Builder collectionBindingProperties(
                Consumer<ComponentPropertyBindingProperties.Builder> collectionBindingProperties) {
            return collectionBindingProperties(ComponentPropertyBindingProperties.builder()
                    .applyMutation(collectionBindingProperties).build());
        }

        /**
         * <p>
         * A list of component properties to concatenate to create the value to assign to this component property.
         * </p>
         * 
         * @param concat
         *        A list of component properties to concatenate to create the value to assign to this component
         *        property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concat(Collection<ComponentProperty> concat);

        /**
         * <p>
         * A list of component properties to concatenate to create the value to assign to this component property.
         * </p>
         * 
         * @param concat
         *        A list of component properties to concatenate to create the value to assign to this component
         *        property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concat(ComponentProperty... concat);

        /**
         * <p>
         * A list of component properties to concatenate to create the value to assign to this component property.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComponentProperty>.Builder} avoiding the
         * need to create one manually via {@link List<ComponentProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComponentProperty>.Builder#build()} is called immediately
         * and its result is passed to {@link #concat(List<ComponentProperty>)}.
         * 
         * @param concat
         *        a consumer that will call methods on {@link List<ComponentProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #concat(List<ComponentProperty>)
         */
        Builder concat(Consumer<Builder>... concat);

        /**
         * <p>
         * The conditional expression to use to assign a value to the component property..
         * </p>
         * 
         * @param condition
         *        The conditional expression to use to assign a value to the component property..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(ComponentConditionProperty condition);

        /**
         * <p>
         * The conditional expression to use to assign a value to the component property..
         * </p>
         * This is a convenience that creates an instance of the {@link ComponentConditionProperty.Builder} avoiding the
         * need to create one manually via {@link ComponentConditionProperty#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComponentConditionProperty.Builder#build()} is called immediately
         * and its result is passed to {@link #condition(ComponentConditionProperty)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link ComponentConditionProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(ComponentConditionProperty)
         */
        default Builder condition(Consumer<ComponentConditionProperty.Builder> condition) {
            return condition(ComponentConditionProperty.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * Specifies whether the user configured the property in Amplify Studio after importing it.
         * </p>
         * 
         * @param configured
         *        Specifies whether the user configured the property in Amplify Studio after importing it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configured(Boolean configured);

        /**
         * <p>
         * The default value to assign to the component property.
         * </p>
         * 
         * @param defaultValue
         *        The default value to assign to the component property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * An event that occurs in your app. Use this for workflow data binding.
         * </p>
         * 
         * @param event
         *        An event that occurs in your app. Use this for workflow data binding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(String event);

        /**
         * <p>
         * The default value assigned to property when the component is imported into an app.
         * </p>
         * 
         * @param importedValue
         *        The default value assigned to property when the component is imported into an app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedValue(String importedValue);

        /**
         * <p>
         * The data model to use to assign a value to the component property.
         * </p>
         * 
         * @param model
         *        The data model to use to assign a value to the component property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The component type.
         * </p>
         * 
         * @param type
         *        The component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * An authenticated user attribute to use to assign a value to the component property.
         * </p>
         * 
         * @param userAttribute
         *        An authenticated user attribute to use to assign a value to the component property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttribute(String userAttribute);

        /**
         * <p>
         * The value to assign to the component property.
         * </p>
         * 
         * @param value
         *        The value to assign to the component property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private ComponentPropertyBindingProperties bindingProperties;

        private Map<String, FormBindingElement> bindings = DefaultSdkAutoConstructMap.getInstance();

        private ComponentPropertyBindingProperties collectionBindingProperties;

        private List<ComponentProperty> concat = DefaultSdkAutoConstructList.getInstance();

        private ComponentConditionProperty condition;

        private Boolean configured;

        private String defaultValue;

        private String event;

        private String importedValue;

        private String model;

        private String type;

        private String userAttribute;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentProperty model) {
            bindingProperties(model.bindingProperties);
            bindings(model.bindings);
            collectionBindingProperties(model.collectionBindingProperties);
            concat(model.concat);
            condition(model.condition);
            configured(model.configured);
            defaultValue(model.defaultValue);
            event(model.event);
            importedValue(model.importedValue);
            model(model.model);
            type(model.type);
            userAttribute(model.userAttribute);
            value(model.value);
        }

        public final ComponentPropertyBindingProperties.Builder getBindingProperties() {
            return bindingProperties != null ? bindingProperties.toBuilder() : null;
        }

        public final void setBindingProperties(ComponentPropertyBindingProperties.BuilderImpl bindingProperties) {
            this.bindingProperties = bindingProperties != null ? bindingProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder bindingProperties(ComponentPropertyBindingProperties bindingProperties) {
            this.bindingProperties = bindingProperties;
            return this;
        }

        public final Map<String, FormBindingElement.Builder> getBindings() {
            Map<String, FormBindingElement.Builder> result = FormBindingsCopier.copyToBuilder(this.bindings);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBindings(Map<String, FormBindingElement.BuilderImpl> bindings) {
            this.bindings = FormBindingsCopier.copyFromBuilder(bindings);
        }

        @Override
        @Transient
        public final Builder bindings(Map<String, FormBindingElement> bindings) {
            this.bindings = FormBindingsCopier.copy(bindings);
            return this;
        }

        public final ComponentPropertyBindingProperties.Builder getCollectionBindingProperties() {
            return collectionBindingProperties != null ? collectionBindingProperties.toBuilder() : null;
        }

        public final void setCollectionBindingProperties(
                ComponentPropertyBindingProperties.BuilderImpl collectionBindingProperties) {
            this.collectionBindingProperties = collectionBindingProperties != null ? collectionBindingProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder collectionBindingProperties(ComponentPropertyBindingProperties collectionBindingProperties) {
            this.collectionBindingProperties = collectionBindingProperties;
            return this;
        }

        public final List<Builder> getConcat() {
            List<Builder> result = ComponentPropertyListCopier.copyToBuilder(this.concat);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConcat(Collection<BuilderImpl> concat) {
            this.concat = ComponentPropertyListCopier.copyFromBuilder(concat);
        }

        @Override
        @Transient
        public final Builder concat(Collection<ComponentProperty> concat) {
            this.concat = ComponentPropertyListCopier.copy(concat);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder concat(ComponentProperty... concat) {
            concat(Arrays.asList(concat));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder concat(Consumer<Builder>... concat) {
            concat(Stream.of(concat).map(c -> ComponentProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ComponentConditionProperty.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(ComponentConditionProperty.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        @Transient
        public final Builder condition(ComponentConditionProperty condition) {
            this.condition = condition;
            return this;
        }

        public final Boolean getConfigured() {
            return configured;
        }

        public final void setConfigured(Boolean configured) {
            this.configured = configured;
        }

        @Override
        @Transient
        public final Builder configured(Boolean configured) {
            this.configured = configured;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Transient
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final String getImportedValue() {
            return importedValue;
        }

        public final void setImportedValue(String importedValue) {
            this.importedValue = importedValue;
        }

        @Override
        @Transient
        public final Builder importedValue(String importedValue) {
            this.importedValue = importedValue;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        @Transient
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getUserAttribute() {
            return userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        @Transient
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ComponentProperty build() {
            return new ComponentProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
