/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the style configuration of a unique variation of a main component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentVariant implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentVariant.Builder, ComponentVariant> {
    private static final SdkField<Map<String, Map<String, String>>> OVERRIDES_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("overrides")
            .getter(getter(ComponentVariant::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VARIANT_VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("variantValues")
            .getter(getter(ComponentVariant::variantValues))
            .setter(setter(Builder::variantValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variantValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDES_FIELD,
            VARIANT_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Map<String, String>> overrides;

    private final Map<String, String> variantValues;

    private ComponentVariant(BuilderImpl builder) {
        this.overrides = builder.overrides;
        this.variantValues = builder.variantValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The properties of the component variant that can be overriden when customizing an instance of the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return The properties of the component variant that can be overriden when customizing an instance of the
     *         component.
     */
    public final Map<String, Map<String, String>> overrides() {
        return overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the VariantValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVariantValues() {
        return variantValues != null && !(variantValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The combination of variants that comprise this variant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariantValues} method.
     * </p>
     * 
     * @return The combination of variants that comprise this variant.
     */
    public final Map<String, String> variantValues() {
        return variantValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVariantValues() ? variantValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentVariant)) {
            return false;
        }
        ComponentVariant other = (ComponentVariant) obj;
        return hasOverrides() == other.hasOverrides() && Objects.equals(overrides(), other.overrides())
                && hasVariantValues() == other.hasVariantValues() && Objects.equals(variantValues(), other.variantValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentVariant").add("Overrides", hasOverrides() ? overrides() : null)
                .add("VariantValues", hasVariantValues() ? variantValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "variantValues":
            return Optional.ofNullable(clazz.cast(variantValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentVariant, T> g) {
        return obj -> g.apply((ComponentVariant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentVariant> {
        /**
         * <p>
         * The properties of the component variant that can be overriden when customizing an instance of the component.
         * </p>
         * 
         * @param overrides
         *        The properties of the component variant that can be overriden when customizing an instance of the
         *        component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Map<String, ? extends Map<String, String>> overrides);

        /**
         * <p>
         * The combination of variants that comprise this variant.
         * </p>
         * 
         * @param variantValues
         *        The combination of variants that comprise this variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variantValues(Map<String, String> variantValues);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Map<String, String>> overrides = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> variantValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentVariant model) {
            overrides(model.overrides);
            variantValues(model.variantValues);
        }

        public final Map<String, ? extends Map<String, String>> getOverrides() {
            if (overrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return overrides;
        }

        public final void setOverrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
        }

        @Override
        @Transient
        public final Builder overrides(Map<String, ? extends Map<String, String>> overrides) {
            this.overrides = ComponentOverridesCopier.copy(overrides);
            return this;
        }

        public final Map<String, String> getVariantValues() {
            if (variantValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return variantValues;
        }

        public final void setVariantValues(Map<String, String> variantValues) {
            this.variantValues = ComponentVariantValuesCopier.copy(variantValues);
        }

        @Override
        @Transient
        public final Builder variantValues(Map<String, String> variantValues) {
            this.variantValues = ComponentVariantValuesCopier.copy(variantValues);
            return this;
        }

        @Override
        public ComponentVariant build() {
            return new ComponentVariant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
