/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThemeRequest extends AmplifyUiBuilderRequest implements
        ToCopyableBuilder<CreateThemeRequest.Builder, CreateThemeRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(CreateThemeRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateThemeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(CreateThemeRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()).build();

    private static final SdkField<CreateThemeData> THEME_TO_CREATE_FIELD = SdkField
            .<CreateThemeData> builder(MarshallingType.SDK_POJO)
            .memberName("themeToCreate")
            .getter(getter(CreateThemeRequest::themeToCreate))
            .setter(setter(Builder::themeToCreate))
            .constructor(CreateThemeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("themeToCreate").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            CLIENT_TOKEN_FIELD, ENVIRONMENT_NAME_FIELD, THEME_TO_CREATE_FIELD));

    private final String appId;

    private final String clientToken;

    private final String environmentName;

    private final CreateThemeData themeToCreate;

    private CreateThemeRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.clientToken = builder.clientToken;
        this.environmentName = builder.environmentName;
        this.themeToCreate = builder.themeToCreate;
    }

    /**
     * <p>
     * The unique ID of the Amplify app associated with the theme.
     * </p>
     * 
     * @return The unique ID of the Amplify app associated with the theme.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The unique client token.
     * </p>
     * 
     * @return The unique client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the backend environment that is a part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is a part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * Represents the configuration of the theme to create.
     * </p>
     * 
     * @return Represents the configuration of the theme to create.
     */
    public final CreateThemeData themeToCreate() {
        return themeToCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(themeToCreate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeRequest)) {
            return false;
        }
        CreateThemeRequest other = (CreateThemeRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(themeToCreate(), other.themeToCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThemeRequest").add("AppId", appId()).add("ClientToken", clientToken())
                .add("EnvironmentName", environmentName()).add("ThemeToCreate", themeToCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "themeToCreate":
            return Optional.ofNullable(clazz.cast(themeToCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeRequest, T> g) {
        return obj -> g.apply((CreateThemeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateThemeRequest> {
        /**
         * <p>
         * The unique ID of the Amplify app associated with the theme.
         * </p>
         * 
         * @param appId
         *        The unique ID of the Amplify app associated with the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The unique client token.
         * </p>
         * 
         * @param clientToken
         *        The unique client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the backend environment that is a part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is a part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * Represents the configuration of the theme to create.
         * </p>
         * 
         * @param themeToCreate
         *        Represents the configuration of the theme to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeToCreate(CreateThemeData themeToCreate);

        /**
         * <p>
         * Represents the configuration of the theme to create.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateThemeData.Builder} avoiding the need to
         * create one manually via {@link CreateThemeData#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateThemeData.Builder#build()} is called immediately and its
         * result is passed to {@link #themeToCreate(CreateThemeData)}.
         * 
         * @param themeToCreate
         *        a consumer that will call methods on {@link CreateThemeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themeToCreate(CreateThemeData)
         */
        default Builder themeToCreate(Consumer<CreateThemeData.Builder> themeToCreate) {
            return themeToCreate(CreateThemeData.builder().applyMutation(themeToCreate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyUiBuilderRequest.BuilderImpl implements Builder {
        private String appId;

        private String clientToken;

        private String environmentName;

        private CreateThemeData themeToCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeRequest model) {
            super(model);
            appId(model.appId);
            clientToken(model.clientToken);
            environmentName(model.environmentName);
            themeToCreate(model.themeToCreate);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        @Transient
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final CreateThemeData.Builder getThemeToCreate() {
            return themeToCreate != null ? themeToCreate.toBuilder() : null;
        }

        public final void setThemeToCreate(CreateThemeData.BuilderImpl themeToCreate) {
            this.themeToCreate = themeToCreate != null ? themeToCreate.build() : null;
        }

        @Override
        @Transient
        public final Builder themeToCreate(CreateThemeData themeToCreate) {
            this.themeToCreate = themeToCreate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThemeRequest build() {
            return new CreateThemeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
