/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a request to exchange an access code for a token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExchangeCodeForTokenRequestBody implements SdkPojo, Serializable,
        ToCopyableBuilder<ExchangeCodeForTokenRequestBody.Builder, ExchangeCodeForTokenRequestBody> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ExchangeCodeForTokenRequestBody::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redirectUri").getter(getter(ExchangeCodeForTokenRequestBody::redirectUri))
            .setter(setter(Builder::redirectUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CODE_FIELD, REDIRECT_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String redirectUri;

    private ExchangeCodeForTokenRequestBody(BuilderImpl builder) {
        this.code = builder.code;
        this.redirectUri = builder.redirectUri;
    }

    /**
     * <p>
     * The access code to send in the request.
     * </p>
     * 
     * @return The access code to send in the request.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The location of the application that will receive the access code.
     * </p>
     * 
     * @return The location of the application that will receive the access code.
     */
    public final String redirectUri() {
        return redirectUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(redirectUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExchangeCodeForTokenRequestBody)) {
            return false;
        }
        ExchangeCodeForTokenRequestBody other = (ExchangeCodeForTokenRequestBody) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(redirectUri(), other.redirectUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExchangeCodeForTokenRequestBody")
                .add("Code", code() == null ? null : "*** Sensitive Data Redacted ***").add("RedirectUri", redirectUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "redirectUri":
            return Optional.ofNullable(clazz.cast(redirectUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExchangeCodeForTokenRequestBody, T> g) {
        return obj -> g.apply((ExchangeCodeForTokenRequestBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExchangeCodeForTokenRequestBody> {
        /**
         * <p>
         * The access code to send in the request.
         * </p>
         * 
         * @param code
         *        The access code to send in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The location of the application that will receive the access code.
         * </p>
         * 
         * @param redirectUri
         *        The location of the application that will receive the access code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUri(String redirectUri);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String redirectUri;

        private BuilderImpl() {
        }

        private BuilderImpl(ExchangeCodeForTokenRequestBody model) {
            code(model.code);
            redirectUri(model.redirectUri);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRedirectUri() {
            return redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        @Transient
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @Override
        public ExchangeCodeForTokenRequestBody build() {
            return new ExchangeCodeForTokenRequestBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
