/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a refresh token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshTokenRequestBody implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshTokenRequestBody.Builder, RefreshTokenRequestBody> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(RefreshTokenRequestBody::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String token;

    private RefreshTokenRequestBody(BuilderImpl builder) {
        this.token = builder.token;
    }

    /**
     * <p>
     * The token to use to refresh a previously issued access token that might have expired.
     * </p>
     * 
     * @return The token to use to refresh a previously issued access token that might have expired.
     */
    public final String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTokenRequestBody)) {
            return false;
        }
        RefreshTokenRequestBody other = (RefreshTokenRequestBody) obj;
        return Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshTokenRequestBody")
                .add("Token", token() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshTokenRequestBody, T> g) {
        return obj -> g.apply((RefreshTokenRequestBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshTokenRequestBody> {
        /**
         * <p>
         * The token to use to refresh a previously issued access token that might have expired.
         * </p>
         * 
         * @param token
         *        The token to use to refresh a previously issued access token that might have expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);
    }

    static final class BuilderImpl implements Builder {
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTokenRequestBody model) {
            token(model.token);
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        @Transient
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public RefreshTokenRequestBody build() {
            return new RefreshTokenRequestBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
