/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A theme is a collection of style settings that apply globally to the components associated with an Amplify
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Theme implements SdkPojo, Serializable, ToCopyableBuilder<Theme.Builder, Theme> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(Theme::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Theme::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(Theme::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Theme::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(Theme::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Theme::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ThemeValues>> OVERRIDES_FIELD = SdkField
            .<List<ThemeValues>> builder(MarshallingType.LIST)
            .memberName("overrides")
            .getter(getter(Theme::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Theme::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ThemeValues>> VALUES_FIELD = SdkField
            .<List<ThemeValues>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(Theme::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            CREATED_AT_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, MODIFIED_AT_FIELD, NAME_FIELD, OVERRIDES_FIELD, TAGS_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final Instant createdAt;

    private final String environmentName;

    private final String id;

    private final Instant modifiedAt;

    private final String name;

    private final List<ThemeValues> overrides;

    private final Map<String, String> tags;

    private final List<ThemeValues> values;

    private Theme(BuilderImpl builder) {
        this.appId = builder.appId;
        this.createdAt = builder.createdAt;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.modifiedAt = builder.modifiedAt;
        this.name = builder.name;
        this.overrides = builder.overrides;
        this.tags = builder.tags;
        this.values = builder.values;
    }

    /**
     * <p>
     * The unique ID for the Amplify app associated with the theme.
     * </p>
     * 
     * @return The unique ID for the Amplify app associated with the theme.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The time that the theme was created.
     * </p>
     * 
     * @return The time that the theme was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the backend environment that is a part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is a part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The ID for the theme.
     * </p>
     * 
     * @return The ID for the theme.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time that the theme was modified.
     * </p>
     * 
     * @return The time that the theme was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The name of the theme.
     * </p>
     * 
     * @return The name of the theme.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the properties that can be overriden to customize a theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return Describes the properties that can be overriden to customize a theme.
     */
    public final List<ThemeValues> overrides() {
        return overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more key-value pairs to use when tagging the theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more key-value pairs to use when tagging the theme.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that defines the properties of the theme.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of key-value pairs that defines the properties of the theme.
     */
    public final List<ThemeValues> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Theme)) {
            return false;
        }
        Theme other = (Theme) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(id(), other.id())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(name(), other.name())
                && hasOverrides() == other.hasOverrides() && Objects.equals(overrides(), other.overrides())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Theme").add("AppId", appId()).add("CreatedAt", createdAt())
                .add("EnvironmentName", environmentName()).add("Id", id()).add("ModifiedAt", modifiedAt()).add("Name", name())
                .add("Overrides", hasOverrides() ? overrides() : null).add("Tags", hasTags() ? tags() : null)
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Theme, T> g) {
        return obj -> g.apply((Theme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Theme> {
        /**
         * <p>
         * The unique ID for the Amplify app associated with the theme.
         * </p>
         * 
         * @param appId
         *        The unique ID for the Amplify app associated with the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The time that the theme was created.
         * </p>
         * 
         * @param createdAt
         *        The time that the theme was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The name of the backend environment that is a part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is a part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The ID for the theme.
         * </p>
         * 
         * @param id
         *        The ID for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time that the theme was modified.
         * </p>
         * 
         * @param modifiedAt
         *        The time that the theme was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The name of the theme.
         * </p>
         * 
         * @param name
         *        The name of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the properties that can be overriden to customize a theme.
         * </p>
         * 
         * @param overrides
         *        Describes the properties that can be overriden to customize a theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(Collection<ThemeValues> overrides);

        /**
         * <p>
         * Describes the properties that can be overriden to customize a theme.
         * </p>
         * 
         * @param overrides
         *        Describes the properties that can be overriden to customize a theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(ThemeValues... overrides);

        /**
         * <p>
         * Describes the properties that can be overriden to customize a theme.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThemeValues>.Builder} avoiding the need to
         * create one manually via {@link List<ThemeValues>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThemeValues>.Builder#build()} is called immediately and its
         * result is passed to {@link #overrides(List<ThemeValues>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link List<ThemeValues>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(List<ThemeValues>)
         */
        Builder overrides(Consumer<ThemeValues.Builder>... overrides);

        /**
         * <p>
         * One or more key-value pairs to use when tagging the theme.
         * </p>
         * 
         * @param tags
         *        One or more key-value pairs to use when tagging the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of key-value pairs that defines the properties of the theme.
         * </p>
         * 
         * @param values
         *        A list of key-value pairs that defines the properties of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<ThemeValues> values);

        /**
         * <p>
         * A list of key-value pairs that defines the properties of the theme.
         * </p>
         * 
         * @param values
         *        A list of key-value pairs that defines the properties of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(ThemeValues... values);

        /**
         * <p>
         * A list of key-value pairs that defines the properties of the theme.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThemeValues>.Builder} avoiding the need to
         * create one manually via {@link List<ThemeValues>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThemeValues>.Builder#build()} is called immediately and its
         * result is passed to {@link #values(List<ThemeValues>)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link List<ThemeValues>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(List<ThemeValues>)
         */
        Builder values(Consumer<ThemeValues.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private Instant createdAt;

        private String environmentName;

        private String id;

        private Instant modifiedAt;

        private String name;

        private List<ThemeValues> overrides = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<ThemeValues> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Theme model) {
            appId(model.appId);
            createdAt(model.createdAt);
            environmentName(model.environmentName);
            id(model.id);
            modifiedAt(model.modifiedAt);
            name(model.name);
            overrides(model.overrides);
            tags(model.tags);
            values(model.values);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        @Transient
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        @Transient
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ThemeValues.Builder> getOverrides() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<ThemeValues.BuilderImpl> overrides) {
            this.overrides = ThemeValuesListCopier.copyFromBuilder(overrides);
        }

        @Override
        @Transient
        public final Builder overrides(Collection<ThemeValues> overrides) {
            this.overrides = ThemeValuesListCopier.copy(overrides);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(ThemeValues... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(Consumer<ThemeValues.Builder>... overrides) {
            overrides(Stream.of(overrides).map(c -> ThemeValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final List<ThemeValues.Builder> getValues() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<ThemeValues.BuilderImpl> values) {
            this.values = ThemeValuesListCopier.copyFromBuilder(values);
        }

        @Override
        @Transient
        public final Builder values(Collection<ThemeValues> values) {
            this.values = ThemeValuesListCopier.copy(values);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(ThemeValues... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(Consumer<ThemeValues.Builder>... values) {
            values(Stream.of(values).map(c -> ThemeValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Theme build() {
            return new Theme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
