/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ThemeValuesListCopier {
    static List<ThemeValues> copy(Collection<? extends ThemeValues> themeValuesListParam) {
        List<ThemeValues> list;
        if (themeValuesListParam == null || themeValuesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThemeValues> modifiableList = new ArrayList<>();
            themeValuesListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ThemeValues> copyFromBuilder(Collection<? extends ThemeValues.Builder> themeValuesListParam) {
        List<ThemeValues> list;
        if (themeValuesListParam == null || themeValuesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThemeValues> modifiableList = new ArrayList<>();
            themeValuesListParam.forEach(entry -> {
                ThemeValues member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ThemeValues.Builder> copyToBuilder(Collection<? extends ThemeValues> themeValuesListParam) {
        List<ThemeValues.Builder> list;
        if (themeValuesListParam == null || themeValuesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ThemeValues.Builder> modifiableList = new ArrayList<>();
            themeValuesListParam.forEach(entry -> {
                ThemeValues.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
