/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the field position.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldPosition implements SdkPojo, Serializable, ToCopyableBuilder<FieldPosition.Builder, FieldPosition> {
    private static final SdkField<String> BELOW_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("below")
            .getter(getter(FieldPosition::below)).setter(setter(Builder::below))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("below").build()).build();

    private static final SdkField<String> FIXED_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fixed")
            .getter(getter(FieldPosition::fixedAsString)).setter(setter(Builder::fixed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixed").build()).build();

    private static final SdkField<String> RIGHT_OF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rightOf").getter(getter(FieldPosition::rightOf)).setter(setter(Builder::rightOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rightOf").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BELOW_FIELD, FIXED_FIELD,
            RIGHT_OF_FIELD));

    private static final long serialVersionUID = 1L;

    private final String below;

    private final String fixed;

    private final String rightOf;

    private final Type type;

    private FieldPosition(BuilderImpl builder) {
        this.below = builder.below;
        this.fixed = builder.fixed;
        this.rightOf = builder.rightOf;
        this.type = builder.type;
    }

    /**
     * <p>
     * The field position is below the field specified by the string.
     * </p>
     * 
     * @return The field position is below the field specified by the string.
     */
    public final String below() {
        return below;
    }

    /**
     * <p>
     * The field position is fixed and doesn't change in relation to other fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixed} will return
     * {@link FixedPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAsString}.
     * </p>
     * 
     * @return The field position is fixed and doesn't change in relation to other fields.
     * @see FixedPosition
     */
    public final FixedPosition fixed() {
        return FixedPosition.fromValue(fixed);
    }

    /**
     * <p>
     * The field position is fixed and doesn't change in relation to other fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixed} will return
     * {@link FixedPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAsString}.
     * </p>
     * 
     * @return The field position is fixed and doesn't change in relation to other fields.
     * @see FixedPosition
     */
    public final String fixedAsString() {
        return fixed;
    }

    /**
     * <p>
     * The field position is to the right of the field specified by the string.
     * </p>
     * 
     * @return The field position is to the right of the field specified by the string.
     */
    public final String rightOf() {
        return rightOf;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(below());
        hashCode = 31 * hashCode + Objects.hashCode(fixedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rightOf());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldPosition)) {
            return false;
        }
        FieldPosition other = (FieldPosition) obj;
        return Objects.equals(below(), other.below()) && Objects.equals(fixedAsString(), other.fixedAsString())
                && Objects.equals(rightOf(), other.rightOf());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldPosition").add("Below", below()).add("Fixed", fixedAsString()).add("RightOf", rightOf())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "below":
            return Optional.ofNullable(clazz.cast(below()));
        case "fixed":
            return Optional.ofNullable(clazz.cast(fixedAsString()));
        case "rightOf":
            return Optional.ofNullable(clazz.cast(rightOf()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #below()} initialized to the given value.
     *
     * <p>
     * The field position is below the field specified by the string.
     * </p>
     * 
     * @param below
     *        The field position is below the field specified by the string.
     */
    public static FieldPosition fromBelow(String below) {
        return builder().below(below).build();
    }

    /**
     * Create an instance of this class with {@link #fixedAsString()} initialized to the given value.
     *
     * <p>
     * The field position is fixed and doesn't change in relation to other fields.
     * </p>
     * 
     * @param fixed
     *        The field position is fixed and doesn't change in relation to other fields.
     * @see FixedPosition
     */
    public static FieldPosition fromFixed(String fixed) {
        return builder().fixed(fixed).build();
    }

    /**
     * Create an instance of this class with {@link #fixedAsString()} initialized to the given value.
     *
     * <p>
     * The field position is fixed and doesn't change in relation to other fields.
     * </p>
     * 
     * @param fixed
     *        The field position is fixed and doesn't change in relation to other fields.
     * @see FixedPosition
     */
    public static FieldPosition fromFixed(FixedPosition fixed) {
        return builder().fixed(fixed).build();
    }

    /**
     * Create an instance of this class with {@link #rightOf()} initialized to the given value.
     *
     * <p>
     * The field position is to the right of the field specified by the string.
     * </p>
     * 
     * @param rightOf
     *        The field position is to the right of the field specified by the string.
     */
    public static FieldPosition fromRightOf(String rightOf) {
        return builder().rightOf(rightOf).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldPosition, T> g) {
        return obj -> g.apply((FieldPosition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldPosition> {
        /**
         * <p>
         * The field position is below the field specified by the string.
         * </p>
         * 
         * @param below
         *        The field position is below the field specified by the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder below(String below);

        /**
         * <p>
         * The field position is fixed and doesn't change in relation to other fields.
         * </p>
         * 
         * @param fixed
         *        The field position is fixed and doesn't change in relation to other fields.
         * @see FixedPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedPosition
         */
        Builder fixed(String fixed);

        /**
         * <p>
         * The field position is fixed and doesn't change in relation to other fields.
         * </p>
         * 
         * @param fixed
         *        The field position is fixed and doesn't change in relation to other fields.
         * @see FixedPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedPosition
         */
        Builder fixed(FixedPosition fixed);

        /**
         * <p>
         * The field position is to the right of the field specified by the string.
         * </p>
         * 
         * @param rightOf
         *        The field position is to the right of the field specified by the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightOf(String rightOf);
    }

    static final class BuilderImpl implements Builder {
        private String below;

        private String fixed;

        private String rightOf;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FieldPosition model) {
            below(model.below);
            fixed(model.fixed);
            rightOf(model.rightOf);
        }

        public final String getBelow() {
            return below;
        }

        public final void setBelow(String below) {
            Object oldValue = this.below;
            this.below = below;
            handleUnionValueChange(Type.BELOW, oldValue, this.below);
        }

        @Override
        public final Builder below(String below) {
            Object oldValue = this.below;
            this.below = below;
            handleUnionValueChange(Type.BELOW, oldValue, this.below);
            return this;
        }

        public final String getFixed() {
            return fixed;
        }

        public final void setFixed(String fixed) {
            Object oldValue = this.fixed;
            this.fixed = fixed;
            handleUnionValueChange(Type.FIXED, oldValue, this.fixed);
        }

        @Override
        public final Builder fixed(String fixed) {
            Object oldValue = this.fixed;
            this.fixed = fixed;
            handleUnionValueChange(Type.FIXED, oldValue, this.fixed);
            return this;
        }

        @Override
        public final Builder fixed(FixedPosition fixed) {
            this.fixed(fixed == null ? null : fixed.toString());
            return this;
        }

        public final String getRightOf() {
            return rightOf;
        }

        public final void setRightOf(String rightOf) {
            Object oldValue = this.rightOf;
            this.rightOf = rightOf;
            handleUnionValueChange(Type.RIGHT_OF, oldValue, this.rightOf);
        }

        @Override
        public final Builder rightOf(String rightOf) {
            Object oldValue = this.rightOf;
            this.rightOf = rightOf;
            handleUnionValueChange(Type.RIGHT_OF, oldValue, this.rightOf);
            return this;
        }

        @Override
        public FieldPosition build() {
            return new FieldPosition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FieldPosition#type()
     */
    public enum Type {
        BELOW,

        FIXED,

        RIGHT_OF,

        UNKNOWN_TO_SDK_VERSION
    }
}
