/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration settings for a <code>Form</code> user interface (UI) element for an Amplify app. A form is
 * a component you can add to your project by specifying a data source as the default configuration for the form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Form implements SdkPojo, Serializable, ToCopyableBuilder<Form.Builder, Form> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(Form::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<FormCTA> CTA_FIELD = SdkField.<FormCTA> builder(MarshallingType.SDK_POJO).memberName("cta")
            .getter(getter(Form::cta)).setter(setter(Builder::cta)).constructor(FormCTA::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cta").build()).build();

    private static final SdkField<FormDataTypeConfig> DATA_TYPE_FIELD = SdkField
            .<FormDataTypeConfig> builder(MarshallingType.SDK_POJO).memberName("dataType").getter(getter(Form::dataType))
            .setter(setter(Builder::dataType)).constructor(FormDataTypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(Form::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<Map<String, FieldConfig>> FIELDS_FIELD = SdkField
            .<Map<String, FieldConfig>> builder(MarshallingType.MAP)
            .memberName("fields")
            .getter(getter(Form::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FieldConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FORM_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formActionType").getter(getter(Form::formActionTypeAsString)).setter(setter(Builder::formActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formActionType").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Form::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Form::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(Form::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<Map<String, SectionalElement>> SECTIONAL_ELEMENTS_FIELD = SdkField
            .<Map<String, SectionalElement>> builder(MarshallingType.MAP)
            .memberName("sectionalElements")
            .getter(getter(Form::sectionalElements))
            .setter(setter(Builder::sectionalElements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sectionalElements").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SectionalElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(SectionalElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<FormStyle> STYLE_FIELD = SdkField.<FormStyle> builder(MarshallingType.SDK_POJO)
            .memberName("style").getter(getter(Form::style)).setter(setter(Builder::style)).constructor(FormStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("style").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Form::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, CTA_FIELD,
            DATA_TYPE_FIELD, ENVIRONMENT_NAME_FIELD, FIELDS_FIELD, FORM_ACTION_TYPE_FIELD, ID_FIELD, NAME_FIELD,
            SCHEMA_VERSION_FIELD, SECTIONAL_ELEMENTS_FIELD, STYLE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final FormCTA cta;

    private final FormDataTypeConfig dataType;

    private final String environmentName;

    private final Map<String, FieldConfig> fields;

    private final String formActionType;

    private final String id;

    private final String name;

    private final String schemaVersion;

    private final Map<String, SectionalElement> sectionalElements;

    private final FormStyle style;

    private final Map<String, String> tags;

    private Form(BuilderImpl builder) {
        this.appId = builder.appId;
        this.cta = builder.cta;
        this.dataType = builder.dataType;
        this.environmentName = builder.environmentName;
        this.fields = builder.fields;
        this.formActionType = builder.formActionType;
        this.id = builder.id;
        this.name = builder.name;
        this.schemaVersion = builder.schemaVersion;
        this.sectionalElements = builder.sectionalElements;
        this.style = builder.style;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique ID of the Amplify app associated with the form.
     * </p>
     * 
     * @return The unique ID of the Amplify app associated with the form.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * Stores the call to action configuration for the form.
     * </p>
     * 
     * @return Stores the call to action configuration for the form.
     */
    public final FormCTA cta() {
        return cta;
    }

    /**
     * <p>
     * The type of data source to use to create the form.
     * </p>
     * 
     * @return The type of data source to use to create the form.
     */
    public final FormDataTypeConfig dataType() {
        return dataType;
    }

    /**
     * <p>
     * The name of the backend environment that is a part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is a part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Stores the information about the form's fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return Stores the information about the form's fields.
     */
    public final Map<String, FieldConfig> fields() {
        return fields;
    }

    /**
     * <p>
     * The operation to perform on the specified form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formActionType}
     * will return {@link FormActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formActionTypeAsString}.
     * </p>
     * 
     * @return The operation to perform on the specified form.
     * @see FormActionType
     */
    public final FormActionType formActionType() {
        return FormActionType.fromValue(formActionType);
    }

    /**
     * <p>
     * The operation to perform on the specified form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formActionType}
     * will return {@link FormActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formActionTypeAsString}.
     * </p>
     * 
     * @return The operation to perform on the specified form.
     * @see FormActionType
     */
    public final String formActionTypeAsString() {
        return formActionType;
    }

    /**
     * <p>
     * The unique ID of the form.
     * </p>
     * 
     * @return The unique ID of the form.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the form.
     * </p>
     * 
     * @return The name of the form.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The schema version of the form when it was imported.
     * </p>
     * 
     * @return The schema version of the form when it was imported.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the SectionalElements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSectionalElements() {
        return sectionalElements != null && !(sectionalElements instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Stores the visual helper elements for the form that are not associated with any data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSectionalElements} method.
     * </p>
     * 
     * @return Stores the visual helper elements for the form that are not associated with any data.
     */
    public final Map<String, SectionalElement> sectionalElements() {
        return sectionalElements;
    }

    /**
     * <p>
     * Stores the configuration for the form's style.
     * </p>
     * 
     * @return Stores the configuration for the form's style.
     */
    public final FormStyle style() {
        return style;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more key-value pairs to use when tagging the form.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more key-value pairs to use when tagging the form.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(cta());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(formActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasSectionalElements() ? sectionalElements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(style());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Form)) {
            return false;
        }
        Form other = (Form) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(cta(), other.cta())
                && Objects.equals(dataType(), other.dataType()) && Objects.equals(environmentName(), other.environmentName())
                && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(formActionTypeAsString(), other.formActionTypeAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(schemaVersion(), other.schemaVersion())
                && hasSectionalElements() == other.hasSectionalElements()
                && Objects.equals(sectionalElements(), other.sectionalElements()) && Objects.equals(style(), other.style())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Form").add("AppId", appId()).add("Cta", cta()).add("DataType", dataType())
                .add("EnvironmentName", environmentName()).add("Fields", hasFields() ? fields() : null)
                .add("FormActionType", formActionTypeAsString()).add("Id", id()).add("Name", name())
                .add("SchemaVersion", schemaVersion())
                .add("SectionalElements", hasSectionalElements() ? sectionalElements() : null).add("Style", style())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "cta":
            return Optional.ofNullable(clazz.cast(cta()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "formActionType":
            return Optional.ofNullable(clazz.cast(formActionTypeAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "sectionalElements":
            return Optional.ofNullable(clazz.cast(sectionalElements()));
        case "style":
            return Optional.ofNullable(clazz.cast(style()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Form, T> g) {
        return obj -> g.apply((Form) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Form> {
        /**
         * <p>
         * The unique ID of the Amplify app associated with the form.
         * </p>
         * 
         * @param appId
         *        The unique ID of the Amplify app associated with the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Stores the call to action configuration for the form.
         * </p>
         * 
         * @param cta
         *        Stores the call to action configuration for the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cta(FormCTA cta);

        /**
         * <p>
         * Stores the call to action configuration for the form.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormCTA.Builder} avoiding the need to
         * create one manually via {@link FormCTA#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormCTA.Builder#build()} is called immediately and its result is
         * passed to {@link #cta(FormCTA)}.
         * 
         * @param cta
         *        a consumer that will call methods on {@link FormCTA.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cta(FormCTA)
         */
        default Builder cta(Consumer<FormCTA.Builder> cta) {
            return cta(FormCTA.builder().applyMutation(cta).build());
        }

        /**
         * <p>
         * The type of data source to use to create the form.
         * </p>
         * 
         * @param dataType
         *        The type of data source to use to create the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(FormDataTypeConfig dataType);

        /**
         * <p>
         * The type of data source to use to create the form.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormDataTypeConfig.Builder} avoiding the
         * need to create one manually via {@link FormDataTypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormDataTypeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataType(FormDataTypeConfig)}.
         * 
         * @param dataType
         *        a consumer that will call methods on {@link FormDataTypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataType(FormDataTypeConfig)
         */
        default Builder dataType(Consumer<FormDataTypeConfig.Builder> dataType) {
            return dataType(FormDataTypeConfig.builder().applyMutation(dataType).build());
        }

        /**
         * <p>
         * The name of the backend environment that is a part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is a part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * Stores the information about the form's fields.
         * </p>
         * 
         * @param fields
         *        Stores the information about the form's fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, FieldConfig> fields);

        /**
         * <p>
         * The operation to perform on the specified form.
         * </p>
         * 
         * @param formActionType
         *        The operation to perform on the specified form.
         * @see FormActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormActionType
         */
        Builder formActionType(String formActionType);

        /**
         * <p>
         * The operation to perform on the specified form.
         * </p>
         * 
         * @param formActionType
         *        The operation to perform on the specified form.
         * @see FormActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormActionType
         */
        Builder formActionType(FormActionType formActionType);

        /**
         * <p>
         * The unique ID of the form.
         * </p>
         * 
         * @param id
         *        The unique ID of the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the form.
         * </p>
         * 
         * @param name
         *        The name of the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The schema version of the form when it was imported.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of the form when it was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * Stores the visual helper elements for the form that are not associated with any data.
         * </p>
         * 
         * @param sectionalElements
         *        Stores the visual helper elements for the form that are not associated with any data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionalElements(Map<String, SectionalElement> sectionalElements);

        /**
         * <p>
         * Stores the configuration for the form's style.
         * </p>
         * 
         * @param style
         *        Stores the configuration for the form's style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder style(FormStyle style);

        /**
         * <p>
         * Stores the configuration for the form's style.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormStyle.Builder} avoiding the need to
         * create one manually via {@link FormStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #style(FormStyle)}.
         * 
         * @param style
         *        a consumer that will call methods on {@link FormStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #style(FormStyle)
         */
        default Builder style(Consumer<FormStyle.Builder> style) {
            return style(FormStyle.builder().applyMutation(style).build());
        }

        /**
         * <p>
         * One or more key-value pairs to use when tagging the form.
         * </p>
         * 
         * @param tags
         *        One or more key-value pairs to use when tagging the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private FormCTA cta;

        private FormDataTypeConfig dataType;

        private String environmentName;

        private Map<String, FieldConfig> fields = DefaultSdkAutoConstructMap.getInstance();

        private String formActionType;

        private String id;

        private String name;

        private String schemaVersion;

        private Map<String, SectionalElement> sectionalElements = DefaultSdkAutoConstructMap.getInstance();

        private FormStyle style;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Form model) {
            appId(model.appId);
            cta(model.cta);
            dataType(model.dataType);
            environmentName(model.environmentName);
            fields(model.fields);
            formActionType(model.formActionType);
            id(model.id);
            name(model.name);
            schemaVersion(model.schemaVersion);
            sectionalElements(model.sectionalElements);
            style(model.style);
            tags(model.tags);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final FormCTA.Builder getCta() {
            return cta != null ? cta.toBuilder() : null;
        }

        public final void setCta(FormCTA.BuilderImpl cta) {
            this.cta = cta != null ? cta.build() : null;
        }

        @Override
        public final Builder cta(FormCTA cta) {
            this.cta = cta;
            return this;
        }

        public final FormDataTypeConfig.Builder getDataType() {
            return dataType != null ? dataType.toBuilder() : null;
        }

        public final void setDataType(FormDataTypeConfig.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(FormDataTypeConfig dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final Map<String, FieldConfig.Builder> getFields() {
            Map<String, FieldConfig.Builder> result = FieldsMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, FieldConfig.BuilderImpl> fields) {
            this.fields = FieldsMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, FieldConfig> fields) {
            this.fields = FieldsMapCopier.copy(fields);
            return this;
        }

        public final String getFormActionType() {
            return formActionType;
        }

        public final void setFormActionType(String formActionType) {
            this.formActionType = formActionType;
        }

        @Override
        public final Builder formActionType(String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        @Override
        public final Builder formActionType(FormActionType formActionType) {
            this.formActionType(formActionType == null ? null : formActionType.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final Map<String, SectionalElement.Builder> getSectionalElements() {
            Map<String, SectionalElement.Builder> result = SectionalElementMapCopier.copyToBuilder(this.sectionalElements);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSectionalElements(Map<String, SectionalElement.BuilderImpl> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copyFromBuilder(sectionalElements);
        }

        @Override
        public final Builder sectionalElements(Map<String, SectionalElement> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copy(sectionalElements);
            return this;
        }

        public final FormStyle.Builder getStyle() {
            return style != null ? style.toBuilder() : null;
        }

        public final void setStyle(FormStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(FormStyle style) {
            this.style = style;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Form build() {
            return new Form(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
