/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Stores the metadata information about a feature on a form or view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMetadataFlagBody implements SdkPojo, Serializable,
        ToCopyableBuilder<PutMetadataFlagBody.Builder, PutMetadataFlagBody> {
    private static final SdkField<String> NEW_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newValue").getter(getter(PutMetadataFlagBody::newValue)).setter(setter(Builder::newValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String newValue;

    private PutMetadataFlagBody(BuilderImpl builder) {
        this.newValue = builder.newValue;
    }

    /**
     * <p>
     * The new information to store.
     * </p>
     * 
     * @return The new information to store.
     */
    public final String newValue() {
        return newValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetadataFlagBody)) {
            return false;
        }
        PutMetadataFlagBody other = (PutMetadataFlagBody) obj;
        return Objects.equals(newValue(), other.newValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMetadataFlagBody").add("NewValue", newValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "newValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetadataFlagBody, T> g) {
        return obj -> g.apply((PutMetadataFlagBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutMetadataFlagBody> {
        /**
         * <p>
         * The new information to store.
         * </p>
         * 
         * @param newValue
         *        The new information to store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(String newValue);
    }

    static final class BuilderImpl implements Builder {
        private String newValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetadataFlagBody model) {
            newValue(model.newValue);
        }

        public final String getNewValue() {
            return newValue;
        }

        public final void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        @Override
        public final Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        @Override
        public PutMetadataFlagBody build() {
            return new PutMetadataFlagBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
