/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Associates a component property to a binding property. This enables exposed properties on the top level component to
 * propagate data to the component's property values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentPropertyBindingProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentPropertyBindingProperties.Builder, ComponentPropertyBindingProperties> {
    private static final SdkField<String> PROPERTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("property").getter(getter(ComponentPropertyBindingProperties::property))
            .setter(setter(Builder::property))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("property").build()).build();

    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("field")
            .getter(getter(ComponentPropertyBindingProperties::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_FIELD, FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String property;

    private final String field;

    private ComponentPropertyBindingProperties(BuilderImpl builder) {
        this.property = builder.property;
        this.field = builder.field;
    }

    /**
     * <p>
     * The component property to bind to the data field.
     * </p>
     * 
     * @return The component property to bind to the data field.
     */
    public final String property() {
        return property;
    }

    /**
     * <p>
     * The data field to bind the property to.
     * </p>
     * 
     * @return The data field to bind the property to.
     */
    public final String field() {
        return field;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(property());
        hashCode = 31 * hashCode + Objects.hashCode(field());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentPropertyBindingProperties)) {
            return false;
        }
        ComponentPropertyBindingProperties other = (ComponentPropertyBindingProperties) obj;
        return Objects.equals(property(), other.property()) && Objects.equals(field(), other.field());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentPropertyBindingProperties").add("Property", property()).add("Field", field()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "property":
            return Optional.ofNullable(clazz.cast(property()));
        case "field":
            return Optional.ofNullable(clazz.cast(field()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentPropertyBindingProperties, T> g) {
        return obj -> g.apply((ComponentPropertyBindingProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentPropertyBindingProperties> {
        /**
         * <p>
         * The component property to bind to the data field.
         * </p>
         * 
         * @param property
         *        The component property to bind to the data field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder property(String property);

        /**
         * <p>
         * The data field to bind the property to.
         * </p>
         * 
         * @param field
         *        The data field to bind the property to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);
    }

    static final class BuilderImpl implements Builder {
        private String property;

        private String field;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentPropertyBindingProperties model) {
            property(model.property);
            field(model.field);
        }

        public final String getProperty() {
            return property;
        }

        public final void setProperty(String property) {
            this.property = property;
        }

        @Override
        public final Builder property(String property) {
            this.property = property;
            return this;
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public ComponentPropertyBindingProperties build() {
            return new ComponentPropertyBindingProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
