/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of an event. You can bind an event and a corresponding action to a <code>Component</code>
 * or a <code>ComponentChild</code>. A button click is an example of an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentEvent implements SdkPojo, Serializable, ToCopyableBuilder<ComponentEvent.Builder, ComponentEvent> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ComponentEvent::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> BINDING_EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bindingEvent").getter(getter(ComponentEvent::bindingEvent)).setter(setter(Builder::bindingEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindingEvent").build()).build();

    private static final SdkField<ActionParameters> PARAMETERS_FIELD = SdkField
            .<ActionParameters> builder(MarshallingType.SDK_POJO).memberName("parameters")
            .getter(getter(ComponentEvent::parameters)).setter(setter(Builder::parameters))
            .constructor(ActionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            BINDING_EVENT_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String bindingEvent;

    private final ActionParameters parameters;

    private ComponentEvent(BuilderImpl builder) {
        this.action = builder.action;
        this.bindingEvent = builder.bindingEvent;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The action to perform when a specific event is raised.
     * </p>
     * 
     * @return The action to perform when a specific event is raised.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is called
     * when the action is performed.
     * </p>
     * 
     * @return Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is
     *         called when the action is performed.
     */
    public final String bindingEvent() {
        return bindingEvent;
    }

    /**
     * <p>
     * Describes information about the action.
     * </p>
     * 
     * @return Describes information about the action.
     */
    public final ActionParameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(bindingEvent());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentEvent)) {
            return false;
        }
        ComponentEvent other = (ComponentEvent) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(bindingEvent(), other.bindingEvent())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentEvent").add("Action", action()).add("BindingEvent", bindingEvent())
                .add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "bindingEvent":
            return Optional.ofNullable(clazz.cast(bindingEvent()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentEvent, T> g) {
        return obj -> g.apply((ComponentEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentEvent> {
        /**
         * <p>
         * The action to perform when a specific event is raised.
         * </p>
         * 
         * @param action
         *        The action to perform when a specific event is raised.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is called
         * when the action is performed.
         * </p>
         * 
         * @param bindingEvent
         *        Binds an event to an action on a component. When you specify a <code>bindingEvent</code>, the event is
         *        called when the action is performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bindingEvent(String bindingEvent);

        /**
         * <p>
         * Describes information about the action.
         * </p>
         * 
         * @param parameters
         *        Describes information about the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ActionParameters parameters);

        /**
         * <p>
         * Describes information about the action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionParameters.Builder} avoiding the
         * need to create one manually via {@link ActionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(ActionParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link ActionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(ActionParameters)
         */
        default Builder parameters(Consumer<ActionParameters.Builder> parameters) {
            return parameters(ActionParameters.builder().applyMutation(parameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String bindingEvent;

        private ActionParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentEvent model) {
            action(model.action);
            bindingEvent(model.bindingEvent);
            parameters(model.parameters);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getBindingEvent() {
            return bindingEvent;
        }

        public final void setBindingEvent(String bindingEvent) {
            this.bindingEvent = bindingEvent;
        }

        @Override
        public final Builder bindingEvent(String bindingEvent) {
            this.bindingEvent = bindingEvent;
            return this;
        }

        public final ActionParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(ActionParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(ActionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public ComponentEvent build() {
            return new ComponentEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
