/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for the default input values to display for a field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldInputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldInputConfig.Builder, FieldInputConfig> {
    private static final SdkField<Boolean> DEFAULT_CHECKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultChecked").getter(getter(FieldInputConfig::defaultChecked))
            .setter(setter(Builder::defaultChecked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultChecked").build()).build();

    private static final SdkField<String> DEFAULT_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultCountryCode").getter(getter(FieldInputConfig::defaultCountryCode))
            .setter(setter(Builder::defaultCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCountryCode").build())
            .build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultValue").getter(getter(FieldInputConfig::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DESCRIPTIVE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("descriptiveText").getter(getter(FieldInputConfig::descriptiveText))
            .setter(setter(Builder::descriptiveText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptiveText").build()).build();

    private static final SdkField<Boolean> IS_ARRAY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isArray").getter(getter(FieldInputConfig::isArray)).setter(setter(Builder::isArray))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArray").build()).build();

    private static final SdkField<Float> MAX_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("maxValue")
            .getter(getter(FieldInputConfig::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxValue").build()).build();

    private static final SdkField<Float> MIN_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("minValue")
            .getter(getter(FieldInputConfig::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minValue").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FieldInputConfig::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PLACEHOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("placeholder").getter(getter(FieldInputConfig::placeholder)).setter(setter(Builder::placeholder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placeholder").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readOnly").getter(getter(FieldInputConfig::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(FieldInputConfig::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<Float> STEP_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("step")
            .getter(getter(FieldInputConfig::step)).setter(setter(Builder::step))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("step").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FieldInputConfig::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(FieldInputConfig::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<ValueMappings> VALUE_MAPPINGS_FIELD = SdkField
            .<ValueMappings> builder(MarshallingType.SDK_POJO).memberName("valueMappings")
            .getter(getter(FieldInputConfig::valueMappings)).setter(setter(Builder::valueMappings))
            .constructor(ValueMappings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueMappings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_CHECKED_FIELD,
            DEFAULT_COUNTRY_CODE_FIELD, DEFAULT_VALUE_FIELD, DESCRIPTIVE_TEXT_FIELD, IS_ARRAY_FIELD, MAX_VALUE_FIELD,
            MIN_VALUE_FIELD, NAME_FIELD, PLACEHOLDER_FIELD, READ_ONLY_FIELD, REQUIRED_FIELD, STEP_FIELD, TYPE_FIELD, VALUE_FIELD,
            VALUE_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean defaultChecked;

    private final String defaultCountryCode;

    private final String defaultValue;

    private final String descriptiveText;

    private final Boolean isArray;

    private final Float maxValue;

    private final Float minValue;

    private final String name;

    private final String placeholder;

    private final Boolean readOnly;

    private final Boolean required;

    private final Float step;

    private final String type;

    private final String value;

    private final ValueMappings valueMappings;

    private FieldInputConfig(BuilderImpl builder) {
        this.defaultChecked = builder.defaultChecked;
        this.defaultCountryCode = builder.defaultCountryCode;
        this.defaultValue = builder.defaultValue;
        this.descriptiveText = builder.descriptiveText;
        this.isArray = builder.isArray;
        this.maxValue = builder.maxValue;
        this.minValue = builder.minValue;
        this.name = builder.name;
        this.placeholder = builder.placeholder;
        this.readOnly = builder.readOnly;
        this.required = builder.required;
        this.step = builder.step;
        this.type = builder.type;
        this.value = builder.value;
        this.valueMappings = builder.valueMappings;
    }

    /**
     * <p>
     * Specifies whether a field has a default value.
     * </p>
     * 
     * @return Specifies whether a field has a default value.
     */
    public final Boolean defaultChecked() {
        return defaultChecked;
    }

    /**
     * <p>
     * The default country code for a phone number.
     * </p>
     * 
     * @return The default country code for a phone number.
     */
    public final String defaultCountryCode() {
        return defaultCountryCode;
    }

    /**
     * <p>
     * The default value for the field.
     * </p>
     * 
     * @return The default value for the field.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The text to display to describe the field.
     * </p>
     * 
     * @return The text to display to describe the field.
     */
    public final String descriptiveText() {
        return descriptiveText;
    }

    /**
     * <p>
     * Specifies whether to render the field as an array. This property is ignored if the <code>dataSourceType</code>
     * for the form is a Data Store.
     * </p>
     * 
     * @return Specifies whether to render the field as an array. This property is ignored if the
     *         <code>dataSourceType</code> for the form is a Data Store.
     */
    public final Boolean isArray() {
        return isArray;
    }

    /**
     * <p>
     * The maximum value to display for the field.
     * </p>
     * 
     * @return The maximum value to display for the field.
     */
    public final Float maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * The minimum value to display for the field.
     * </p>
     * 
     * @return The minimum value to display for the field.
     */
    public final Float minValue() {
        return minValue;
    }

    /**
     * <p>
     * The name of the field.
     * </p>
     * 
     * @return The name of the field.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The text to display as a placeholder for the field.
     * </p>
     * 
     * @return The text to display as a placeholder for the field.
     */
    public final String placeholder() {
        return placeholder;
    }

    /**
     * <p>
     * Specifies a read only field.
     * </p>
     * 
     * @return Specifies a read only field.
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * Specifies a field that requires input.
     * </p>
     * 
     * @return Specifies a field that requires input.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * The stepping increment for a numeric value in a field.
     * </p>
     * 
     * @return The stepping increment for a numeric value in a field.
     */
    public final Float step() {
        return step;
    }

    /**
     * <p>
     * The input type for the field.
     * </p>
     * 
     * @return The input type for the field.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The value for the field.
     * </p>
     * 
     * @return The value for the field.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The information to use to customize the input fields with data at runtime.
     * </p>
     * 
     * @return The information to use to customize the input fields with data at runtime.
     */
    public final ValueMappings valueMappings() {
        return valueMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultChecked());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(descriptiveText());
        hashCode = 31 * hashCode + Objects.hashCode(isArray());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(placeholder());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(step());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(valueMappings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldInputConfig)) {
            return false;
        }
        FieldInputConfig other = (FieldInputConfig) obj;
        return Objects.equals(defaultChecked(), other.defaultChecked())
                && Objects.equals(defaultCountryCode(), other.defaultCountryCode())
                && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(descriptiveText(), other.descriptiveText()) && Objects.equals(isArray(), other.isArray())
                && Objects.equals(maxValue(), other.maxValue()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(name(), other.name()) && Objects.equals(placeholder(), other.placeholder())
                && Objects.equals(readOnly(), other.readOnly()) && Objects.equals(required(), other.required())
                && Objects.equals(step(), other.step()) && Objects.equals(type(), other.type())
                && Objects.equals(value(), other.value()) && Objects.equals(valueMappings(), other.valueMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldInputConfig").add("DefaultChecked", defaultChecked())
                .add("DefaultCountryCode", defaultCountryCode()).add("DefaultValue", defaultValue())
                .add("DescriptiveText", descriptiveText()).add("IsArray", isArray()).add("MaxValue", maxValue())
                .add("MinValue", minValue()).add("Name", name()).add("Placeholder", placeholder()).add("ReadOnly", readOnly())
                .add("Required", required()).add("Step", step()).add("Type", type()).add("Value", value())
                .add("ValueMappings", valueMappings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultChecked":
            return Optional.ofNullable(clazz.cast(defaultChecked()));
        case "defaultCountryCode":
            return Optional.ofNullable(clazz.cast(defaultCountryCode()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "descriptiveText":
            return Optional.ofNullable(clazz.cast(descriptiveText()));
        case "isArray":
            return Optional.ofNullable(clazz.cast(isArray()));
        case "maxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "minValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "placeholder":
            return Optional.ofNullable(clazz.cast(placeholder()));
        case "readOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "step":
            return Optional.ofNullable(clazz.cast(step()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "valueMappings":
            return Optional.ofNullable(clazz.cast(valueMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldInputConfig, T> g) {
        return obj -> g.apply((FieldInputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldInputConfig> {
        /**
         * <p>
         * Specifies whether a field has a default value.
         * </p>
         * 
         * @param defaultChecked
         *        Specifies whether a field has a default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultChecked(Boolean defaultChecked);

        /**
         * <p>
         * The default country code for a phone number.
         * </p>
         * 
         * @param defaultCountryCode
         *        The default country code for a phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCountryCode(String defaultCountryCode);

        /**
         * <p>
         * The default value for the field.
         * </p>
         * 
         * @param defaultValue
         *        The default value for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The text to display to describe the field.
         * </p>
         * 
         * @param descriptiveText
         *        The text to display to describe the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptiveText(String descriptiveText);

        /**
         * <p>
         * Specifies whether to render the field as an array. This property is ignored if the
         * <code>dataSourceType</code> for the form is a Data Store.
         * </p>
         * 
         * @param isArray
         *        Specifies whether to render the field as an array. This property is ignored if the
         *        <code>dataSourceType</code> for the form is a Data Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArray(Boolean isArray);

        /**
         * <p>
         * The maximum value to display for the field.
         * </p>
         * 
         * @param maxValue
         *        The maximum value to display for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Float maxValue);

        /**
         * <p>
         * The minimum value to display for the field.
         * </p>
         * 
         * @param minValue
         *        The minimum value to display for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Float minValue);

        /**
         * <p>
         * The name of the field.
         * </p>
         * 
         * @param name
         *        The name of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The text to display as a placeholder for the field.
         * </p>
         * 
         * @param placeholder
         *        The text to display as a placeholder for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeholder(String placeholder);

        /**
         * <p>
         * Specifies a read only field.
         * </p>
         * 
         * @param readOnly
         *        Specifies a read only field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * Specifies a field that requires input.
         * </p>
         * 
         * @param required
         *        Specifies a field that requires input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * The stepping increment for a numeric value in a field.
         * </p>
         * 
         * @param step
         *        The stepping increment for a numeric value in a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder step(Float step);

        /**
         * <p>
         * The input type for the field.
         * </p>
         * 
         * @param type
         *        The input type for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The value for the field.
         * </p>
         * 
         * @param value
         *        The value for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The information to use to customize the input fields with data at runtime.
         * </p>
         * 
         * @param valueMappings
         *        The information to use to customize the input fields with data at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueMappings(ValueMappings valueMappings);

        /**
         * <p>
         * The information to use to customize the input fields with data at runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValueMappings.Builder} avoiding the need
         * to create one manually via {@link ValueMappings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValueMappings.Builder#build()} is called immediately and its
         * result is passed to {@link #valueMappings(ValueMappings)}.
         * 
         * @param valueMappings
         *        a consumer that will call methods on {@link ValueMappings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueMappings(ValueMappings)
         */
        default Builder valueMappings(Consumer<ValueMappings.Builder> valueMappings) {
            return valueMappings(ValueMappings.builder().applyMutation(valueMappings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean defaultChecked;

        private String defaultCountryCode;

        private String defaultValue;

        private String descriptiveText;

        private Boolean isArray;

        private Float maxValue;

        private Float minValue;

        private String name;

        private String placeholder;

        private Boolean readOnly;

        private Boolean required;

        private Float step;

        private String type;

        private String value;

        private ValueMappings valueMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldInputConfig model) {
            defaultChecked(model.defaultChecked);
            defaultCountryCode(model.defaultCountryCode);
            defaultValue(model.defaultValue);
            descriptiveText(model.descriptiveText);
            isArray(model.isArray);
            maxValue(model.maxValue);
            minValue(model.minValue);
            name(model.name);
            placeholder(model.placeholder);
            readOnly(model.readOnly);
            required(model.required);
            step(model.step);
            type(model.type);
            value(model.value);
            valueMappings(model.valueMappings);
        }

        public final Boolean getDefaultChecked() {
            return defaultChecked;
        }

        public final void setDefaultChecked(Boolean defaultChecked) {
            this.defaultChecked = defaultChecked;
        }

        @Override
        public final Builder defaultChecked(Boolean defaultChecked) {
            this.defaultChecked = defaultChecked;
            return this;
        }

        public final String getDefaultCountryCode() {
            return defaultCountryCode;
        }

        public final void setDefaultCountryCode(String defaultCountryCode) {
            this.defaultCountryCode = defaultCountryCode;
        }

        @Override
        public final Builder defaultCountryCode(String defaultCountryCode) {
            this.defaultCountryCode = defaultCountryCode;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescriptiveText() {
            return descriptiveText;
        }

        public final void setDescriptiveText(String descriptiveText) {
            this.descriptiveText = descriptiveText;
        }

        @Override
        public final Builder descriptiveText(String descriptiveText) {
            this.descriptiveText = descriptiveText;
            return this;
        }

        public final Boolean getIsArray() {
            return isArray;
        }

        public final void setIsArray(Boolean isArray) {
            this.isArray = isArray;
        }

        @Override
        public final Builder isArray(Boolean isArray) {
            this.isArray = isArray;
            return this;
        }

        public final Float getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Float maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Float maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final Float getMinValue() {
            return minValue;
        }

        public final void setMinValue(Float minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Float minValue) {
            this.minValue = minValue;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlaceholder() {
            return placeholder;
        }

        public final void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public final Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final Float getStep() {
            return step;
        }

        public final void setStep(Float step) {
            this.step = step;
        }

        @Override
        public final Builder step(Float step) {
            this.step = step;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final ValueMappings.Builder getValueMappings() {
            return valueMappings != null ? valueMappings.toBuilder() : null;
        }

        public final void setValueMappings(ValueMappings.BuilderImpl valueMappings) {
            this.valueMappings = valueMappings != null ? valueMappings.build() : null;
        }

        @Override
        public final Builder valueMappings(ValueMappings valueMappings) {
            this.valueMappings = valueMappings;
            return this;
        }

        @Override
        public FieldInputConfig build() {
            return new FieldInputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
