/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderException;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.CreateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.DeleteThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExchangeCodeForTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetMetadataResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.GetThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.InternalServerException;
import software.amazon.awssdk.services.amplifyuibuilder.model.InvalidParameterException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.PutMetadataFlagResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.RefreshTokenResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.ResourceConflictException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.amplifyuibuilder.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.amplifyuibuilder.model.UnauthorizedException;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateComponentResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateFormResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.UpdateThemeResponse;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsIterable;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsIterable;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesIterable;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsIterable;
import software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable;

/**
 * Service client for accessing AWS Amplify UI Builder. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Amplify UI Builder API provides a programmatic interface for creating and configuring user interface (UI)
 * component libraries and themes for use in your Amplify applications. You can then connect these UI components to an
 * application's backend Amazon Web Services resources.
 * </p>
 * <p>
 * You can also use the Amplify Studio visual designer to create UI components and model data for an app. For more
 * information, see <a href="https://docs.amplify.aws/console/adminui/intro">Introduction</a> in the <i>Amplify
 * Docs</i>.
 * </p>
 * <p>
 * The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development.
 * For more information, see the <a href="https://docs.amplify.aws/">Amplify Framework</a>. For more information about
 * deploying an Amplify application to Amazon Web Services, see the <a
 * href="https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html">Amplify User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AmplifyUiBuilderClient extends AwsClient {
    String SERVICE_NAME = "amplifyuibuilder";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "amplifyuibuilder";

    /**
     * <p>
     * Creates a new component for an Amplify app.
     * </p>
     *
     * @param createComponentRequest
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentResponse createComponent(CreateComponentRequest createComponentRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new component for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateComponentRequest#builder()}
     * </p>
     *
     * @param createComponentRequest
     *        A {@link Consumer} that will call methods on {@link CreateComponentRequest.Builder} to create a request.
     * @return Result of the CreateComponent operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateComponentResponse createComponent(Consumer<CreateComponentRequest.Builder> createComponentRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return createComponent(CreateComponentRequest.builder().applyMutation(createComponentRequest).build());
    }

    /**
     * <p>
     * Creates a new form for an Amplify app.
     * </p>
     *
     * @param createFormRequest
     * @return Result of the CreateForm operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFormResponse createForm(CreateFormRequest createFormRequest) throws ServiceQuotaExceededException,
            ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new form for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFormRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFormRequest#builder()}
     * </p>
     *
     * @param createFormRequest
     *        A {@link Consumer} that will call methods on {@link CreateFormRequest.Builder} to create a request.
     * @return Result of the CreateForm operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateFormResponse createForm(Consumer<CreateFormRequest.Builder> createFormRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return createForm(CreateFormRequest.builder().applyMutation(createFormRequest).build());
    }

    /**
     * <p>
     * Creates a theme to apply to the components in an Amplify app.
     * </p>
     *
     * @param createThemeRequest
     * @return Result of the CreateTheme operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateThemeResponse createTheme(CreateThemeRequest createThemeRequest) throws ServiceQuotaExceededException,
            ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a theme to apply to the components in an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateThemeRequest#builder()}
     * </p>
     *
     * @param createThemeRequest
     *        A {@link Consumer} that will call methods on {@link CreateThemeRequest.Builder} to create a request.
     * @return Result of the CreateTheme operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You exceeded your service quota. Service quotas, also referred to as limits, are the maximum number of
     *         service resources or operations for your Amazon Web Services account.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/CreateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateThemeResponse createTheme(Consumer<CreateThemeRequest.Builder> createThemeRequest)
            throws ServiceQuotaExceededException, ResourceConflictException, InternalServerException, InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return createTheme(CreateThemeRequest.builder().applyMutation(createThemeRequest).build());
    }

    /**
     * <p>
     * Deletes a component from an Amplify app.
     * </p>
     *
     * @param deleteComponentRequest
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(DeleteComponentRequest deleteComponentRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a component from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComponentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteComponentRequest#builder()}
     * </p>
     *
     * @param deleteComponentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteComponentRequest.Builder} to create a request.
     * @return Result of the DeleteComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteComponentResponse deleteComponent(Consumer<DeleteComponentRequest.Builder> deleteComponentRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return deleteComponent(DeleteComponentRequest.builder().applyMutation(deleteComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a form from an Amplify app.
     * </p>
     *
     * @param deleteFormRequest
     * @return Result of the DeleteForm operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteForm" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFormResponse deleteForm(DeleteFormRequest deleteFormRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a form from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFormRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFormRequest#builder()}
     * </p>
     *
     * @param deleteFormRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFormRequest.Builder} to create a request.
     * @return Result of the DeleteForm operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteForm" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteFormResponse deleteForm(Consumer<DeleteFormRequest.Builder> deleteFormRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return deleteForm(DeleteFormRequest.builder().applyMutation(deleteFormRequest).build());
    }

    /**
     * <p>
     * Deletes a theme from an Amplify app.
     * </p>
     *
     * @param deleteThemeRequest
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteThemeResponse deleteTheme(DeleteThemeRequest deleteThemeRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a theme from an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThemeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteThemeRequest#builder()}
     * </p>
     *
     * @param deleteThemeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThemeRequest.Builder} to create a request.
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/DeleteTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteThemeResponse deleteTheme(Consumer<DeleteThemeRequest.Builder> deleteThemeRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return deleteTheme(DeleteThemeRequest.builder().applyMutation(deleteThemeRequest).build());
    }

    /**
     * <p>
     * Exchanges an access code for a token.
     * </p>
     *
     * @param exchangeCodeForTokenRequest
     * @return Result of the ExchangeCodeForToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExchangeCodeForToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken"
     *      target="_top">AWS API Documentation</a>
     */
    default ExchangeCodeForTokenResponse exchangeCodeForToken(ExchangeCodeForTokenRequest exchangeCodeForTokenRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exchanges an access code for a token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExchangeCodeForTokenRequest.Builder} avoiding the
     * need to create one manually via {@link ExchangeCodeForTokenRequest#builder()}
     * </p>
     *
     * @param exchangeCodeForTokenRequest
     *        A {@link Consumer} that will call methods on {@link ExchangeCodeForTokenRequest.Builder} to create a
     *        request.
     * @return Result of the ExchangeCodeForToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExchangeCodeForToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExchangeCodeForToken"
     *      target="_top">AWS API Documentation</a>
     */
    default ExchangeCodeForTokenResponse exchangeCodeForToken(
            Consumer<ExchangeCodeForTokenRequest.Builder> exchangeCodeForTokenRequest) throws InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return exchangeCodeForToken(ExchangeCodeForTokenRequest.builder().applyMutation(exchangeCodeForTokenRequest).build());
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportComponentsRequest
     * @return Result of the ExportComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsResponse exportComponents(ExportComponentsRequest exportComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportComponentsRequest.Builder} avoiding the need
     * to create one manually via {@link ExportComponentsRequest#builder()}
     * </p>
     *
     * @param exportComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ExportComponentsRequest.Builder} to create a request.
     * @return Result of the ExportComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsResponse exportComponents(Consumer<ExportComponentsRequest.Builder> exportComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportComponents(ExportComponentsRequest.builder().applyMutation(exportComponentsRequest).build());
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsIterable responses = client.exportComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsIterable responses = client
     *             .exportComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsIterable responses = client.exportComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param exportComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsIterable exportComponentsPaginator(ExportComponentsRequest exportComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports component configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsIterable responses = client.exportComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsIterable responses = client
     *             .exportComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportComponentsIterable responses = client.exportComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ExportComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportComponentsRequest.Builder} avoiding the need
     * to create one manually via {@link ExportComponentsRequest#builder()}
     * </p>
     *
     * @param exportComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ExportComponentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportComponentsIterable exportComponentsPaginator(Consumer<ExportComponentsRequest.Builder> exportComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportComponentsPaginator(ExportComponentsRequest.builder().applyMutation(exportComponentsRequest).build());
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportFormsRequest
     * @return Result of the ExportForms operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportFormsResponse exportForms(ExportFormsRequest exportFormsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ExportFormsRequest#builder()}
     * </p>
     *
     * @param exportFormsRequest
     *        A {@link Consumer} that will call methods on {@link ExportFormsRequest.Builder} to create a request.
     * @return Result of the ExportForms operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportFormsResponse exportForms(Consumer<ExportFormsRequest.Builder> exportFormsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportForms(ExportFormsRequest.builder().applyMutation(exportFormsRequest).build());
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsIterable responses = client.exportFormsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsIterable responses = client
     *             .exportFormsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsIterable responses = client.exportFormsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation.</b>
     * </p>
     *
     * @param exportFormsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportFormsIterable exportFormsPaginator(ExportFormsRequest exportFormsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports form configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsIterable responses = client.exportFormsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsIterable responses = client
     *             .exportFormsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportFormsIterable responses = client.exportFormsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportForms(software.amazon.awssdk.services.amplifyuibuilder.model.ExportFormsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ExportFormsRequest#builder()}
     * </p>
     *
     * @param exportFormsRequest
     *        A {@link Consumer} that will call methods on {@link ExportFormsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportFormsIterable exportFormsPaginator(Consumer<ExportFormsRequest.Builder> exportFormsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportFormsPaginator(ExportFormsRequest.builder().applyMutation(exportFormsRequest).build());
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     *
     * @param exportThemesRequest
     * @return Result of the ExportThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesResponse exportThemes(ExportThemesRequest exportThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ExportThemesRequest#builder()}
     * </p>
     *
     * @param exportThemesRequest
     *        A {@link Consumer} that will call methods on {@link ExportThemesRequest.Builder} to create a request.
     * @return Result of the ExportThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesResponse exportThemes(Consumer<ExportThemesRequest.Builder> exportThemesRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportThemes(ExportThemesRequest.builder().applyMutation(exportThemesRequest).build());
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesIterable responses = client.exportThemesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesIterable responses = client
     *             .exportThemesPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesIterable responses = client.exportThemesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation.</b>
     * </p>
     *
     * @param exportThemesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesIterable exportThemesPaginator(ExportThemesRequest exportThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports theme configurations to code that is ready to integrate into an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesIterable responses = client.exportThemesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesIterable responses = client
     *             .exportThemesPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ExportThemesIterable responses = client.exportThemesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #exportThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ExportThemesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ExportThemesRequest#builder()}
     * </p>
     *
     * @param exportThemesRequest
     *        A {@link Consumer} that will call methods on {@link ExportThemesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ExportThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ExportThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportThemesIterable exportThemesPaginator(Consumer<ExportThemesRequest.Builder> exportThemesRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return exportThemesPaginator(ExportThemesRequest.builder().applyMutation(exportThemesRequest).build());
    }

    /**
     * <p>
     * Returns an existing component for an Amplify app.
     * </p>
     *
     * @param getComponentRequest
     * @return Result of the GetComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComponentResponse getComponent(GetComponentRequest getComponentRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing component for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComponentRequest.Builder} avoiding the need to
     * create one manually via {@link GetComponentRequest#builder()}
     * </p>
     *
     * @param getComponentRequest
     *        A {@link Consumer} that will call methods on {@link GetComponentRequest.Builder} to create a request.
     * @return Result of the GetComponent operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetComponent" target="_top">AWS
     *      API Documentation</a>
     */
    default GetComponentResponse getComponent(Consumer<GetComponentRequest.Builder> getComponentRequest)
            throws InternalServerException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return getComponent(GetComponentRequest.builder().applyMutation(getComponentRequest).build());
    }

    /**
     * <p>
     * Returns an existing form for an Amplify app.
     * </p>
     *
     * @param getFormRequest
     * @return Result of the GetForm operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetForm" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFormResponse getForm(GetFormRequest getFormRequest) throws InternalServerException, InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing form for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFormRequest.Builder} avoiding the need to create
     * one manually via {@link GetFormRequest#builder()}
     * </p>
     *
     * @param getFormRequest
     *        A {@link Consumer} that will call methods on {@link GetFormRequest.Builder} to create a request.
     * @return Result of the GetForm operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetForm" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFormResponse getForm(Consumer<GetFormRequest.Builder> getFormRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return getForm(GetFormRequest.builder().applyMutation(getFormRequest).build());
    }

    /**
     * <p>
     * Returns existing metadata for an Amplify app.
     * </p>
     *
     * @param getMetadataRequest
     * @return Result of the GetMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You don't have permission to perform this operation.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMetadataResponse getMetadata(GetMetadataRequest getMetadataRequest) throws UnauthorizedException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns existing metadata for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetadataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetadataRequest#builder()}
     * </p>
     *
     * @param getMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetMetadataRequest.Builder} to create a request.
     * @return Result of the GetMetadata operation returned by the service.
     * @throws UnauthorizedException
     *         You don't have permission to perform this operation.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMetadataResponse getMetadata(Consumer<GetMetadataRequest.Builder> getMetadataRequest)
            throws UnauthorizedException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return getMetadata(GetMetadataRequest.builder().applyMutation(getMetadataRequest).build());
    }

    /**
     * <p>
     * Returns an existing theme for an Amplify app.
     * </p>
     *
     * @param getThemeRequest
     * @return Result of the GetTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default GetThemeResponse getTheme(GetThemeRequest getThemeRequest) throws InternalServerException, InvalidParameterException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an existing theme for an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetThemeRequest.Builder} avoiding the need to
     * create one manually via {@link GetThemeRequest#builder()}
     * </p>
     *
     * @param getThemeRequest
     *        A {@link Consumer} that will call methods on {@link GetThemeRequest.Builder} to create a request.
     * @return Result of the GetTheme operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.GetTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/GetTheme" target="_top">AWS API
     *      Documentation</a>
     */
    default GetThemeResponse getTheme(Consumer<GetThemeRequest.Builder> getThemeRequest) throws InternalServerException,
            InvalidParameterException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return getTheme(GetThemeRequest.builder().applyMutation(getThemeRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listComponentsRequest
     * @return Result of the ListComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsResponse listComponents(ListComponentsRequest listComponentsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return Result of the ListComponents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsResponse listComponents(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return listComponents(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComponentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(ListComponentsRequest listComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of components for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client
     *             .listComponentsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListComponentsIterable responses = client.listComponentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComponents(software.amazon.awssdk.services.amplifyuibuilder.model.ListComponentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComponentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListComponentsRequest#builder()}
     * </p>
     *
     * @param listComponentsRequest
     *        A {@link Consumer} that will call methods on {@link ListComponentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListComponents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListComponentsIterable listComponentsPaginator(Consumer<ListComponentsRequest.Builder> listComponentsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return listComponentsPaginator(ListComponentsRequest.builder().applyMutation(listComponentsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listFormsRequest
     * @return Result of the ListForms operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFormsResponse listForms(ListFormsRequest listFormsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFormsRequest#builder()}
     * </p>
     *
     * @param listFormsRequest
     *        A {@link Consumer} that will call methods on {@link ListFormsRequest.Builder} to create a request.
     * @return Result of the ListForms operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFormsResponse listForms(Consumer<ListFormsRequest.Builder> listFormsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return listForms(ListFormsRequest.builder().applyMutation(listFormsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsIterable responses = client.listFormsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsIterable responses = client.listFormsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsIterable responses = client.listFormsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)} operation.</b>
     * </p>
     *
     * @param listFormsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFormsIterable listFormsPaginator(ListFormsRequest listFormsRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of forms for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsIterable responses = client.listFormsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsIterable responses = client.listFormsPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListFormsIterable responses = client.listFormsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listForms(software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFormsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFormsRequest#builder()}
     * </p>
     *
     * @param listFormsRequest
     *        A {@link Consumer} that will call methods on {@link ListFormsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFormsIterable listFormsPaginator(Consumer<ListFormsRequest.Builder> listFormsRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return listFormsPaginator(ListFormsRequest.builder().applyMutation(listFormsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     *
     * @param listThemesRequest
     * @return Result of the ListThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesResponse listThemes(ListThemesRequest listThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThemesRequest#builder()}
     * </p>
     *
     * @param listThemesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemesRequest.Builder} to create a request.
     * @return Result of the ListThemes operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesResponse listThemes(Consumer<ListThemesRequest.Builder> listThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return listThemes(ListThemesRequest.builder().applyMutation(listThemesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client
     *             .listThemesPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation.</b>
     * </p>
     *
     * @param listThemesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesIterable listThemesPaginator(ListThemesRequest listThemesRequest) throws InternalServerException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of themes for a specified Amplify app and backend environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client
     *             .listThemesPaginator(request);
     *     for (software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifyuibuilder.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.amplifyuibuilder.model.ListThemesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThemesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThemesRequest#builder()}
     * </p>
     *
     * @param listThemesRequest
     *        A {@link Consumer} that will call methods on {@link ListThemesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ListThemes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListThemesIterable listThemesPaginator(Consumer<ListThemesRequest.Builder> listThemesRequest)
            throws InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return listThemesPaginator(ListThemesRequest.builder().applyMutation(listThemesRequest).build());
    }

    /**
     * <p>
     * Stores the metadata information about a feature on a form.
     * </p>
     *
     * @param putMetadataFlagRequest
     * @return Result of the PutMetadataFlag operation returned by the service.
     * @throws UnauthorizedException
     *         You don't have permission to perform this operation.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.PutMetadataFlag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/PutMetadataFlag"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMetadataFlagResponse putMetadataFlag(PutMetadataFlagRequest putMetadataFlagRequest) throws UnauthorizedException,
            InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores the metadata information about a feature on a form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMetadataFlagRequest.Builder} avoiding the need
     * to create one manually via {@link PutMetadataFlagRequest#builder()}
     * </p>
     *
     * @param putMetadataFlagRequest
     *        A {@link Consumer} that will call methods on {@link PutMetadataFlagRequest.Builder} to create a request.
     * @return Result of the PutMetadataFlag operation returned by the service.
     * @throws UnauthorizedException
     *         You don't have permission to perform this operation.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.PutMetadataFlag
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/PutMetadataFlag"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMetadataFlagResponse putMetadataFlag(Consumer<PutMetadataFlagRequest.Builder> putMetadataFlagRequest)
            throws UnauthorizedException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        return putMetadataFlag(PutMetadataFlagRequest.builder().applyMutation(putMetadataFlagRequest).build());
    }

    /**
     * <p>
     * Refreshes a previously issued access token that might have expired.
     * </p>
     *
     * @param refreshTokenRequest
     * @return Result of the RefreshToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.RefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken" target="_top">AWS
     *      API Documentation</a>
     */
    default RefreshTokenResponse refreshToken(RefreshTokenRequest refreshTokenRequest) throws InvalidParameterException,
            AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Refreshes a previously issued access token that might have expired.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshTokenRequest.Builder} avoiding the need to
     * create one manually via {@link RefreshTokenRequest#builder()}
     * </p>
     *
     * @param refreshTokenRequest
     *        A {@link Consumer} that will call methods on {@link RefreshTokenRequest.Builder} to create a request.
     * @return Result of the RefreshToken operation returned by the service.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.RefreshToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/RefreshToken" target="_top">AWS
     *      API Documentation</a>
     */
    default RefreshTokenResponse refreshToken(Consumer<RefreshTokenRequest.Builder> refreshTokenRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, AmplifyUiBuilderException {
        return refreshToken(RefreshTokenRequest.builder().applyMutation(refreshTokenRequest).build());
    }

    /**
     * <p>
     * Updates an existing component.
     * </p>
     *
     * @param updateComponentRequest
     * @return Result of the UpdateComponent operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentResponse updateComponent(UpdateComponentRequest updateComponentRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateComponentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateComponentRequest#builder()}
     * </p>
     *
     * @param updateComponentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateComponentRequest.Builder} to create a request.
     * @return Result of the UpdateComponent operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateComponentResponse updateComponent(Consumer<UpdateComponentRequest.Builder> updateComponentRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return updateComponent(UpdateComponentRequest.builder().applyMutation(updateComponentRequest).build());
    }

    /**
     * <p>
     * Updates an existing form.
     * </p>
     *
     * @param updateFormRequest
     * @return Result of the UpdateForm operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFormResponse updateForm(UpdateFormRequest updateFormRequest) throws ResourceConflictException,
            InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFormRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFormRequest#builder()}
     * </p>
     *
     * @param updateFormRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFormRequest.Builder} to create a request.
     * @return Result of the UpdateForm operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateForm" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFormResponse updateForm(Consumer<UpdateFormRequest.Builder> updateFormRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return updateForm(UpdateFormRequest.builder().applyMutation(updateFormRequest).build());
    }

    /**
     * <p>
     * Updates an existing theme.
     * </p>
     *
     * @param updateThemeRequest
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateThemeResponse updateTheme(UpdateThemeRequest updateThemeRequest) throws ResourceConflictException,
            InternalServerException, InvalidParameterException, AwsServiceException, SdkClientException,
            AmplifyUiBuilderException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing theme.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThemeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateThemeRequest#builder()}
     * </p>
     *
     * @param updateThemeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThemeRequest.Builder} to create a request.
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws InternalServerException
     *         An internal error has occurred. Please retry your request.
     * @throws InvalidParameterException
     *         An invalid or out-of-range value was supplied for the input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AmplifyUiBuilderException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AmplifyUiBuilderClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/UpdateTheme" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateThemeResponse updateTheme(Consumer<UpdateThemeRequest.Builder> updateThemeRequest)
            throws ResourceConflictException, InternalServerException, InvalidParameterException, AwsServiceException,
            SdkClientException, AmplifyUiBuilderException {
        return updateTheme(UpdateThemeRequest.builder().applyMutation(updateThemeRequest).build());
    }

    /**
     * Create a {@link AmplifyUiBuilderClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AmplifyUiBuilderClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AmplifyUiBuilderClient}.
     */
    static AmplifyUiBuilderClientBuilder builder() {
        return new DefaultAmplifyUiBuilderClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default AmplifyUiBuilderServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
