/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a theme's properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThemeValue implements SdkPojo, Serializable, ToCopyableBuilder<ThemeValue.Builder, ThemeValue> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(ThemeValue::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<List<ThemeValues>> CHILDREN_FIELD = SdkField
            .<List<ThemeValues>> builder(MarshallingType.LIST)
            .memberName("children")
            .getter(getter(ThemeValue::children))
            .setter(setter(Builder::children))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("children").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeValues> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeValues::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, CHILDREN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private final List<ThemeValues> children;

    private ThemeValue(BuilderImpl builder) {
        this.value = builder.value;
        this.children = builder.children;
    }

    /**
     * <p>
     * The value of a theme property.
     * </p>
     * 
     * @return The value of a theme property.
     */
    public final String value() {
        return value;
    }

    /**
     * For responses, this returns true if the service returned a value for the Children property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChildren() {
        return children != null && !(children instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that define the theme's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChildren} method.
     * </p>
     * 
     * @return A list of key-value pairs that define the theme's properties.
     */
    public final List<ThemeValues> children() {
        return children;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildren() ? children() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeValue)) {
            return false;
        }
        ThemeValue other = (ThemeValue) obj;
        return Objects.equals(value(), other.value()) && hasChildren() == other.hasChildren()
                && Objects.equals(children(), other.children());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThemeValue").add("Value", value()).add("Children", hasChildren() ? children() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "children":
            return Optional.ofNullable(clazz.cast(children()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThemeValue, T> g) {
        return obj -> g.apply((ThemeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThemeValue> {
        /**
         * <p>
         * The value of a theme property.
         * </p>
         * 
         * @param value
         *        The value of a theme property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * A list of key-value pairs that define the theme's properties.
         * </p>
         * 
         * @param children
         *        A list of key-value pairs that define the theme's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(Collection<ThemeValues> children);

        /**
         * <p>
         * A list of key-value pairs that define the theme's properties.
         * </p>
         * 
         * @param children
         *        A list of key-value pairs that define the theme's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder children(ThemeValues... children);

        /**
         * <p>
         * A list of key-value pairs that define the theme's properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder#build()} is called
         * immediately and its result is passed to {@link #children(List<ThemeValues>)}.
         * 
         * @param children
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.amplifyuibuilder.model.ThemeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #children(java.util.Collection<ThemeValues>)
         */
        Builder children(Consumer<ThemeValues.Builder>... children);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private List<ThemeValues> children = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeValue model) {
            value(model.value);
            children(model.children);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final List<ThemeValues.Builder> getChildren() {
            List<ThemeValues.Builder> result = ThemeValuesListCopier.copyToBuilder(this.children);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChildren(Collection<ThemeValues.BuilderImpl> children) {
            this.children = ThemeValuesListCopier.copyFromBuilder(children);
        }

        @Override
        public final Builder children(Collection<ThemeValues> children) {
            this.children = ThemeValuesListCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(ThemeValues... children) {
            children(Arrays.asList(children));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Consumer<ThemeValues.Builder>... children) {
            children(Stream.of(children).map(c -> ThemeValues.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ThemeValue build() {
            return new ThemeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
