/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependenciesCopier;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenDependency;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenFeatureFlags;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobAsset;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobGenericDataSchema;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobRenderConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.CodegenJobStatus;
import software.amazon.awssdk.services.amplifyuibuilder.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodegenJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodegenJob> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CodegenJob.getter(CodegenJob::id)).setter(CodegenJob.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(CodegenJob.getter(CodegenJob::appId)).setter(CodegenJob.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(CodegenJob.getter(CodegenJob::environmentName)).setter(CodegenJob.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<CodegenJobRenderConfig> RENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renderConfig").getter(CodegenJob.getter(CodegenJob::renderConfig)).setter(CodegenJob.setter(Builder::renderConfig)).constructor(CodegenJobRenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderConfig").build()}).build();
    private static final SdkField<CodegenJobGenericDataSchema> GENERIC_DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("genericDataSchema").getter(CodegenJob.getter(CodegenJob::genericDataSchema)).setter(CodegenJob.setter(Builder::genericDataSchema)).constructor(CodegenJobGenericDataSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("genericDataSchema").build()}).build();
    private static final SdkField<Boolean> AUTO_GENERATE_FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoGenerateForms").getter(CodegenJob.getter(CodegenJob::autoGenerateForms)).setter(CodegenJob.setter(Builder::autoGenerateForms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoGenerateForms").build()}).build();
    private static final SdkField<CodegenFeatureFlags> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("features").getter(CodegenJob.getter(CodegenJob::features)).setter(CodegenJob.setter(Builder::features)).constructor(CodegenFeatureFlags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CodegenJob.getter(CodegenJob::statusAsString)).setter(CodegenJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(CodegenJob.getter(CodegenJob::statusMessage)).setter(CodegenJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<CodegenJobAsset> ASSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("asset").getter(CodegenJob.getter(CodegenJob::asset)).setter(CodegenJob.setter(Builder::asset)).constructor(CodegenJobAsset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asset").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CodegenJob.getter(CodegenJob::tags)).setter(CodegenJob.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CodegenJob.getter(CodegenJob::createdAt)).setter(CodegenJob.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(CodegenJob.getter(CodegenJob::modifiedAt)).setter(CodegenJob.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<CodegenDependency>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependencies").getter(CodegenJob.getter(CodegenJob::dependencies)).setter(CodegenJob.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodegenDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, APP_ID_FIELD, ENVIRONMENT_NAME_FIELD, RENDER_CONFIG_FIELD, GENERIC_DATA_SCHEMA_FIELD, AUTO_GENERATE_FORMS_FIELD, FEATURES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, ASSET_FIELD, TAGS_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, DEPENDENCIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("appId", APP_ID_FIELD);
            this.put("environmentName", ENVIRONMENT_NAME_FIELD);
            this.put("renderConfig", RENDER_CONFIG_FIELD);
            this.put("genericDataSchema", GENERIC_DATA_SCHEMA_FIELD);
            this.put("autoGenerateForms", AUTO_GENERATE_FORMS_FIELD);
            this.put("features", FEATURES_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusMessage", STATUS_MESSAGE_FIELD);
            this.put("asset", ASSET_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("modifiedAt", MODIFIED_AT_FIELD);
            this.put("dependencies", DEPENDENCIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String appId;
    private final String environmentName;
    private final CodegenJobRenderConfig renderConfig;
    private final CodegenJobGenericDataSchema genericDataSchema;
    private final Boolean autoGenerateForms;
    private final CodegenFeatureFlags features;
    private final String status;
    private final String statusMessage;
    private final CodegenJobAsset asset;
    private final Map<String, String> tags;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final List<CodegenDependency> dependencies;

    private CodegenJob(BuilderImpl builder) {
        this.id = builder.id;
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.renderConfig = builder.renderConfig;
        this.genericDataSchema = builder.genericDataSchema;
        this.autoGenerateForms = builder.autoGenerateForms;
        this.features = builder.features;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.asset = builder.asset;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.dependencies = builder.dependencies;
    }

    public final String id() {
        return this.id;
    }

    public final String appId() {
        return this.appId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final CodegenJobRenderConfig renderConfig() {
        return this.renderConfig;
    }

    public final CodegenJobGenericDataSchema genericDataSchema() {
        return this.genericDataSchema;
    }

    public final Boolean autoGenerateForms() {
        return this.autoGenerateForms;
    }

    public final CodegenFeatureFlags features() {
        return this.features;
    }

    public final CodegenJobStatus status() {
        return CodegenJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final CodegenJobAsset asset() {
        return this.asset;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<CodegenDependency> dependencies() {
        return this.dependencies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.renderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.genericDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGenerateForms());
        hashCode = 31 * hashCode + Objects.hashCode(this.features());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.asset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenJob)) {
            return false;
        }
        CodegenJob other = (CodegenJob)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.renderConfig(), other.renderConfig()) && Objects.equals(this.genericDataSchema(), other.genericDataSchema()) && Objects.equals(this.autoGenerateForms(), other.autoGenerateForms()) && Objects.equals(this.features(), other.features()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.asset(), other.asset()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies());
    }

    public final String toString() {
        return ToString.builder((String)"CodegenJob").add("Id", (Object)this.id()).add("AppId", (Object)this.appId()).add("EnvironmentName", (Object)this.environmentName()).add("RenderConfig", (Object)this.renderConfig()).add("GenericDataSchema", (Object)this.genericDataSchema()).add("AutoGenerateForms", (Object)this.autoGenerateForms()).add("Features", (Object)this.features()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Asset", (Object)this.asset()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "renderConfig": {
                return Optional.ofNullable(clazz.cast(this.renderConfig()));
            }
            case "genericDataSchema": {
                return Optional.ofNullable(clazz.cast(this.genericDataSchema()));
            }
            case "autoGenerateForms": {
                return Optional.ofNullable(clazz.cast(this.autoGenerateForms()));
            }
            case "features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "asset": {
                return Optional.ofNullable(clazz.cast(this.asset()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CodegenJob, T> g) {
        return obj -> g.apply((CodegenJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String appId;
        private String environmentName;
        private CodegenJobRenderConfig renderConfig;
        private CodegenJobGenericDataSchema genericDataSchema;
        private Boolean autoGenerateForms;
        private CodegenFeatureFlags features;
        private String status;
        private String statusMessage;
        private CodegenJobAsset asset;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant modifiedAt;
        private List<CodegenDependency> dependencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenJob model) {
            this.id(model.id);
            this.appId(model.appId);
            this.environmentName(model.environmentName);
            this.renderConfig(model.renderConfig);
            this.genericDataSchema(model.genericDataSchema);
            this.autoGenerateForms(model.autoGenerateForms);
            this.features(model.features);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.asset(model.asset);
            this.tags(model.tags);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.dependencies(model.dependencies);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final CodegenJobRenderConfig.Builder getRenderConfig() {
            return this.renderConfig != null ? this.renderConfig.toBuilder() : null;
        }

        public final void setRenderConfig(CodegenJobRenderConfig.BuilderImpl renderConfig) {
            this.renderConfig = renderConfig != null ? renderConfig.build() : null;
        }

        @Override
        public final Builder renderConfig(CodegenJobRenderConfig renderConfig) {
            this.renderConfig = renderConfig;
            return this;
        }

        public final CodegenJobGenericDataSchema.Builder getGenericDataSchema() {
            return this.genericDataSchema != null ? this.genericDataSchema.toBuilder() : null;
        }

        public final void setGenericDataSchema(CodegenJobGenericDataSchema.BuilderImpl genericDataSchema) {
            this.genericDataSchema = genericDataSchema != null ? genericDataSchema.build() : null;
        }

        @Override
        public final Builder genericDataSchema(CodegenJobGenericDataSchema genericDataSchema) {
            this.genericDataSchema = genericDataSchema;
            return this;
        }

        public final Boolean getAutoGenerateForms() {
            return this.autoGenerateForms;
        }

        public final void setAutoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
        }

        @Override
        public final Builder autoGenerateForms(Boolean autoGenerateForms) {
            this.autoGenerateForms = autoGenerateForms;
            return this;
        }

        public final CodegenFeatureFlags.Builder getFeatures() {
            return this.features != null ? this.features.toBuilder() : null;
        }

        public final void setFeatures(CodegenFeatureFlags.BuilderImpl features) {
            this.features = features != null ? features.build() : null;
        }

        @Override
        public final Builder features(CodegenFeatureFlags features) {
            this.features = features;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodegenJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final CodegenJobAsset.Builder getAsset() {
            return this.asset != null ? this.asset.toBuilder() : null;
        }

        public final void setAsset(CodegenJobAsset.BuilderImpl asset) {
            this.asset = asset != null ? asset.build() : null;
        }

        @Override
        public final Builder asset(CodegenJobAsset asset) {
            this.asset = asset;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final List<CodegenDependency.Builder> getDependencies() {
            List<CodegenDependency.Builder> result = CodegenDependenciesCopier.copyToBuilder(this.dependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependencies(Collection<CodegenDependency.BuilderImpl> dependencies) {
            this.dependencies = CodegenDependenciesCopier.copyFromBuilder(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<CodegenDependency> dependencies) {
            this.dependencies = CodegenDependenciesCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(CodegenDependency ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<CodegenDependency.Builder> ... dependencies) {
            this.dependencies(Stream.of(dependencies).map(c -> (CodegenDependency)((CodegenDependency.Builder)CodegenDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CodegenJob build() {
            return new CodegenJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodegenJob> {
        public Builder id(String var1);

        public Builder appId(String var1);

        public Builder environmentName(String var1);

        public Builder renderConfig(CodegenJobRenderConfig var1);

        default public Builder renderConfig(Consumer<CodegenJobRenderConfig.Builder> renderConfig) {
            return this.renderConfig((CodegenJobRenderConfig)((CodegenJobRenderConfig.Builder)CodegenJobRenderConfig.builder().applyMutation(renderConfig)).build());
        }

        public Builder genericDataSchema(CodegenJobGenericDataSchema var1);

        default public Builder genericDataSchema(Consumer<CodegenJobGenericDataSchema.Builder> genericDataSchema) {
            return this.genericDataSchema((CodegenJobGenericDataSchema)((CodegenJobGenericDataSchema.Builder)CodegenJobGenericDataSchema.builder().applyMutation(genericDataSchema)).build());
        }

        public Builder autoGenerateForms(Boolean var1);

        public Builder features(CodegenFeatureFlags var1);

        default public Builder features(Consumer<CodegenFeatureFlags.Builder> features) {
            return this.features((CodegenFeatureFlags)((CodegenFeatureFlags.Builder)CodegenFeatureFlags.builder().applyMutation(features)).build());
        }

        public Builder status(String var1);

        public Builder status(CodegenJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder asset(CodegenJobAsset var1);

        default public Builder asset(Consumer<CodegenJobAsset.Builder> asset) {
            return this.asset((CodegenJobAsset)((CodegenJobAsset.Builder)CodegenJobAsset.builder().applyMutation(asset)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder dependencies(Collection<CodegenDependency> var1);

        public Builder dependencies(CodegenDependency ... var1);

        public Builder dependencies(Consumer<CodegenDependency.Builder> ... var1);
    }
}

