/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshTokenResponse
extends AmplifyUiBuilderResponse
implements ToCopyableBuilder<Builder, RefreshTokenResponse> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(RefreshTokenResponse.getter(RefreshTokenResponse::accessToken)).setter(RefreshTokenResponse.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("expiresIn").getter(RefreshTokenResponse.getter(RefreshTokenResponse::expiresIn)).setter(RefreshTokenResponse.setter(Builder::expiresIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, EXPIRES_IN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accessToken", ACCESS_TOKEN_FIELD);
            this.put("expiresIn", EXPIRES_IN_FIELD);
        }
    });
    private final String accessToken;
    private final Integer expiresIn;

    private RefreshTokenResponse(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.expiresIn = builder.expiresIn;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final Integer expiresIn() {
        return this.expiresIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshTokenResponse)) {
            return false;
        }
        RefreshTokenResponse other = (RefreshTokenResponse)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.expiresIn(), other.expiresIn());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshTokenResponse").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("ExpiresIn", (Object)this.expiresIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "expiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RefreshTokenResponse, T> g) {
        return obj -> g.apply((RefreshTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderResponse.BuilderImpl
    implements Builder {
        private String accessToken;
        private Integer expiresIn;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshTokenResponse model) {
            super(model);
            this.accessToken(model.accessToken);
            this.expiresIn(model.expiresIn);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Integer getExpiresIn() {
            return this.expiresIn;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @Override
        public RefreshTokenResponse build() {
            return new RefreshTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RefreshTokenResponse> {
        public Builder accessToken(String var1);

        public Builder expiresIn(Integer var1);
    }
}

