/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents all of the information that is required to create a form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFormData implements SdkPojo, Serializable, ToCopyableBuilder<CreateFormData.Builder, CreateFormData> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFormData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<FormDataTypeConfig> DATA_TYPE_FIELD = SdkField
            .<FormDataTypeConfig> builder(MarshallingType.SDK_POJO).memberName("dataType")
            .getter(getter(CreateFormData::dataType)).setter(setter(Builder::dataType)).constructor(FormDataTypeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> FORM_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formActionType").getter(getter(CreateFormData::formActionTypeAsString))
            .setter(setter(Builder::formActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formActionType").build()).build();

    private static final SdkField<Map<String, FieldConfig>> FIELDS_FIELD = SdkField
            .<Map<String, FieldConfig>> builder(MarshallingType.MAP)
            .memberName("fields")
            .getter(getter(CreateFormData::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FieldConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<FormStyle> STYLE_FIELD = SdkField.<FormStyle> builder(MarshallingType.SDK_POJO)
            .memberName("style").getter(getter(CreateFormData::style)).setter(setter(Builder::style))
            .constructor(FormStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("style").build()).build();

    private static final SdkField<Map<String, SectionalElement>> SECTIONAL_ELEMENTS_FIELD = SdkField
            .<Map<String, SectionalElement>> builder(MarshallingType.MAP)
            .memberName("sectionalElements")
            .getter(getter(CreateFormData::sectionalElements))
            .setter(setter(Builder::sectionalElements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sectionalElements").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SectionalElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(SectionalElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(CreateFormData::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<FormCTA> CTA_FIELD = SdkField.<FormCTA> builder(MarshallingType.SDK_POJO).memberName("cta")
            .getter(getter(CreateFormData::cta)).setter(setter(Builder::cta)).constructor(FormCTA::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cta").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateFormData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> LABEL_DECORATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("labelDecorator").getter(getter(CreateFormData::labelDecoratorAsString))
            .setter(setter(Builder::labelDecorator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelDecorator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD,
            FORM_ACTION_TYPE_FIELD, FIELDS_FIELD, STYLE_FIELD, SECTIONAL_ELEMENTS_FIELD, SCHEMA_VERSION_FIELD, CTA_FIELD,
            TAGS_FIELD, LABEL_DECORATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final FormDataTypeConfig dataType;

    private final String formActionType;

    private final Map<String, FieldConfig> fields;

    private final FormStyle style;

    private final Map<String, SectionalElement> sectionalElements;

    private final String schemaVersion;

    private final FormCTA cta;

    private final Map<String, String> tags;

    private final String labelDecorator;

    private CreateFormData(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.formActionType = builder.formActionType;
        this.fields = builder.fields;
        this.style = builder.style;
        this.sectionalElements = builder.sectionalElements;
        this.schemaVersion = builder.schemaVersion;
        this.cta = builder.cta;
        this.tags = builder.tags;
        this.labelDecorator = builder.labelDecorator;
    }

    /**
     * <p>
     * The name of the form.
     * </p>
     * 
     * @return The name of the form.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of data source to use to create the form.
     * </p>
     * 
     * @return The type of data source to use to create the form.
     */
    public final FormDataTypeConfig dataType() {
        return dataType;
    }

    /**
     * <p>
     * Specifies whether to perform a create or update action on the form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formActionType}
     * will return {@link FormActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formActionTypeAsString}.
     * </p>
     * 
     * @return Specifies whether to perform a create or update action on the form.
     * @see FormActionType
     */
    public final FormActionType formActionType() {
        return FormActionType.fromValue(formActionType);
    }

    /**
     * <p>
     * Specifies whether to perform a create or update action on the form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formActionType}
     * will return {@link FormActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formActionTypeAsString}.
     * </p>
     * 
     * @return Specifies whether to perform a create or update action on the form.
     * @see FormActionType
     */
    public final String formActionTypeAsString() {
        return formActionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration information for the form's fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The configuration information for the form's fields.
     */
    public final Map<String, FieldConfig> fields() {
        return fields;
    }

    /**
     * <p>
     * The configuration for the form's style.
     * </p>
     * 
     * @return The configuration for the form's style.
     */
    public final FormStyle style() {
        return style;
    }

    /**
     * For responses, this returns true if the service returned a value for the SectionalElements property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSectionalElements() {
        return sectionalElements != null && !(sectionalElements instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration information for the visual helper elements for the form. These elements are not associated with
     * any data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSectionalElements} method.
     * </p>
     * 
     * @return The configuration information for the visual helper elements for the form. These elements are not
     *         associated with any data.
     */
    public final Map<String, SectionalElement> sectionalElements() {
        return sectionalElements;
    }

    /**
     * <p>
     * The schema version of the form.
     * </p>
     * 
     * @return The schema version of the form.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The <code>FormCTA</code> object that stores the call to action configuration for the form.
     * </p>
     * 
     * @return The <code>FormCTA</code> object that stores the call to action configuration for the form.
     */
    public final FormCTA cta() {
        return cta;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more key-value pairs to use when tagging the form data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more key-value pairs to use when tagging the form data.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies an icon or decoration to display on the form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelDecorator}
     * will return {@link LabelDecorator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #labelDecoratorAsString}.
     * </p>
     * 
     * @return Specifies an icon or decoration to display on the form.
     * @see LabelDecorator
     */
    public final LabelDecorator labelDecorator() {
        return LabelDecorator.fromValue(labelDecorator);
    }

    /**
     * <p>
     * Specifies an icon or decoration to display on the form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelDecorator}
     * will return {@link LabelDecorator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #labelDecoratorAsString}.
     * </p>
     * 
     * @return Specifies an icon or decoration to display on the form.
     * @see LabelDecorator
     */
    public final String labelDecoratorAsString() {
        return labelDecorator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(formActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(style());
        hashCode = 31 * hashCode + Objects.hashCode(hasSectionalElements() ? sectionalElements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cta());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(labelDecoratorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFormData)) {
            return false;
        }
        CreateFormData other = (CreateFormData) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dataType(), other.dataType())
                && Objects.equals(formActionTypeAsString(), other.formActionTypeAsString()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && Objects.equals(style(), other.style())
                && hasSectionalElements() == other.hasSectionalElements()
                && Objects.equals(sectionalElements(), other.sectionalElements())
                && Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(cta(), other.cta())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(labelDecoratorAsString(), other.labelDecoratorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFormData").add("Name", name()).add("DataType", dataType())
                .add("FormActionType", formActionTypeAsString()).add("Fields", hasFields() ? fields() : null)
                .add("Style", style()).add("SectionalElements", hasSectionalElements() ? sectionalElements() : null)
                .add("SchemaVersion", schemaVersion()).add("Cta", cta()).add("Tags", hasTags() ? tags() : null)
                .add("LabelDecorator", labelDecoratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "formActionType":
            return Optional.ofNullable(clazz.cast(formActionTypeAsString()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "style":
            return Optional.ofNullable(clazz.cast(style()));
        case "sectionalElements":
            return Optional.ofNullable(clazz.cast(sectionalElements()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "cta":
            return Optional.ofNullable(clazz.cast(cta()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "labelDecorator":
            return Optional.ofNullable(clazz.cast(labelDecoratorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("formActionType", FORM_ACTION_TYPE_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("style", STYLE_FIELD);
        map.put("sectionalElements", SECTIONAL_ELEMENTS_FIELD);
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        map.put("cta", CTA_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("labelDecorator", LABEL_DECORATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFormData, T> g) {
        return obj -> g.apply((CreateFormData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFormData> {
        /**
         * <p>
         * The name of the form.
         * </p>
         * 
         * @param name
         *        The name of the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of data source to use to create the form.
         * </p>
         * 
         * @param dataType
         *        The type of data source to use to create the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(FormDataTypeConfig dataType);

        /**
         * <p>
         * The type of data source to use to create the form.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormDataTypeConfig.Builder} avoiding the
         * need to create one manually via {@link FormDataTypeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormDataTypeConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataType(FormDataTypeConfig)}.
         * 
         * @param dataType
         *        a consumer that will call methods on {@link FormDataTypeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataType(FormDataTypeConfig)
         */
        default Builder dataType(Consumer<FormDataTypeConfig.Builder> dataType) {
            return dataType(FormDataTypeConfig.builder().applyMutation(dataType).build());
        }

        /**
         * <p>
         * Specifies whether to perform a create or update action on the form.
         * </p>
         * 
         * @param formActionType
         *        Specifies whether to perform a create or update action on the form.
         * @see FormActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormActionType
         */
        Builder formActionType(String formActionType);

        /**
         * <p>
         * Specifies whether to perform a create or update action on the form.
         * </p>
         * 
         * @param formActionType
         *        Specifies whether to perform a create or update action on the form.
         * @see FormActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FormActionType
         */
        Builder formActionType(FormActionType formActionType);

        /**
         * <p>
         * The configuration information for the form's fields.
         * </p>
         * 
         * @param fields
         *        The configuration information for the form's fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, FieldConfig> fields);

        /**
         * <p>
         * The configuration for the form's style.
         * </p>
         * 
         * @param style
         *        The configuration for the form's style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder style(FormStyle style);

        /**
         * <p>
         * The configuration for the form's style.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormStyle.Builder} avoiding the need to
         * create one manually via {@link FormStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #style(FormStyle)}.
         * 
         * @param style
         *        a consumer that will call methods on {@link FormStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #style(FormStyle)
         */
        default Builder style(Consumer<FormStyle.Builder> style) {
            return style(FormStyle.builder().applyMutation(style).build());
        }

        /**
         * <p>
         * The configuration information for the visual helper elements for the form. These elements are not associated
         * with any data.
         * </p>
         * 
         * @param sectionalElements
         *        The configuration information for the visual helper elements for the form. These elements are not
         *        associated with any data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionalElements(Map<String, SectionalElement> sectionalElements);

        /**
         * <p>
         * The schema version of the form.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The <code>FormCTA</code> object that stores the call to action configuration for the form.
         * </p>
         * 
         * @param cta
         *        The <code>FormCTA</code> object that stores the call to action configuration for the form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cta(FormCTA cta);

        /**
         * <p>
         * The <code>FormCTA</code> object that stores the call to action configuration for the form.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormCTA.Builder} avoiding the need to
         * create one manually via {@link FormCTA#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormCTA.Builder#build()} is called immediately and its result is
         * passed to {@link #cta(FormCTA)}.
         * 
         * @param cta
         *        a consumer that will call methods on {@link FormCTA.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cta(FormCTA)
         */
        default Builder cta(Consumer<FormCTA.Builder> cta) {
            return cta(FormCTA.builder().applyMutation(cta).build());
        }

        /**
         * <p>
         * One or more key-value pairs to use when tagging the form data.
         * </p>
         * 
         * @param tags
         *        One or more key-value pairs to use when tagging the form data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Specifies an icon or decoration to display on the form.
         * </p>
         * 
         * @param labelDecorator
         *        Specifies an icon or decoration to display on the form.
         * @see LabelDecorator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDecorator
         */
        Builder labelDecorator(String labelDecorator);

        /**
         * <p>
         * Specifies an icon or decoration to display on the form.
         * </p>
         * 
         * @param labelDecorator
         *        Specifies an icon or decoration to display on the form.
         * @see LabelDecorator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelDecorator
         */
        Builder labelDecorator(LabelDecorator labelDecorator);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private FormDataTypeConfig dataType;

        private String formActionType;

        private Map<String, FieldConfig> fields = DefaultSdkAutoConstructMap.getInstance();

        private FormStyle style;

        private Map<String, SectionalElement> sectionalElements = DefaultSdkAutoConstructMap.getInstance();

        private String schemaVersion;

        private FormCTA cta;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String labelDecorator;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFormData model) {
            name(model.name);
            dataType(model.dataType);
            formActionType(model.formActionType);
            fields(model.fields);
            style(model.style);
            sectionalElements(model.sectionalElements);
            schemaVersion(model.schemaVersion);
            cta(model.cta);
            tags(model.tags);
            labelDecorator(model.labelDecorator);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final FormDataTypeConfig.Builder getDataType() {
            return dataType != null ? dataType.toBuilder() : null;
        }

        public final void setDataType(FormDataTypeConfig.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(FormDataTypeConfig dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getFormActionType() {
            return formActionType;
        }

        public final void setFormActionType(String formActionType) {
            this.formActionType = formActionType;
        }

        @Override
        public final Builder formActionType(String formActionType) {
            this.formActionType = formActionType;
            return this;
        }

        @Override
        public final Builder formActionType(FormActionType formActionType) {
            this.formActionType(formActionType == null ? null : formActionType.toString());
            return this;
        }

        public final Map<String, FieldConfig.Builder> getFields() {
            Map<String, FieldConfig.Builder> result = FieldsMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, FieldConfig.BuilderImpl> fields) {
            this.fields = FieldsMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, FieldConfig> fields) {
            this.fields = FieldsMapCopier.copy(fields);
            return this;
        }

        public final FormStyle.Builder getStyle() {
            return style != null ? style.toBuilder() : null;
        }

        public final void setStyle(FormStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(FormStyle style) {
            this.style = style;
            return this;
        }

        public final Map<String, SectionalElement.Builder> getSectionalElements() {
            Map<String, SectionalElement.Builder> result = SectionalElementMapCopier.copyToBuilder(this.sectionalElements);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSectionalElements(Map<String, SectionalElement.BuilderImpl> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copyFromBuilder(sectionalElements);
        }

        @Override
        public final Builder sectionalElements(Map<String, SectionalElement> sectionalElements) {
            this.sectionalElements = SectionalElementMapCopier.copy(sectionalElements);
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final FormCTA.Builder getCta() {
            return cta != null ? cta.toBuilder() : null;
        }

        public final void setCta(FormCTA.BuilderImpl cta) {
            this.cta = cta != null ? cta.build() : null;
        }

        @Override
        public final Builder cta(FormCTA cta) {
            this.cta = cta;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getLabelDecorator() {
            return labelDecorator;
        }

        public final void setLabelDecorator(String labelDecorator) {
            this.labelDecorator = labelDecorator;
        }

        @Override
        public final Builder labelDecorator(String labelDecorator) {
            this.labelDecorator = labelDecorator;
            return this;
        }

        @Override
        public final Builder labelDecorator(LabelDecorator labelDecorator) {
            this.labelDecorator(labelDecorator == null ? null : labelDecorator.toString());
            return this;
        }

        @Override
        public CreateFormData build() {
            return new CreateFormData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
